/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.simulator.RealNodeSecretPingTest;
import freenet.support.Logger;

public class RealNodeTest {
    static final int EXIT_BASE = 1024;
    static final int EXIT_CANNOT_DELETE_OLD_DATA = 1027;
    static final int EXIT_PING_TARGET_NOT_REACHED = 1028;
    static final int EXIT_INSERT_FAILED = 1029;
    static final int EXIT_REQUEST_FAILED = 1030;
    static final int EXIT_BAD_DATA = 1031;

    static void makeKleinbergNetwork(Node[] nodes, boolean idealLocations, int degree, boolean forceNeighbourConnections) {
        if (idealLocations) {
            double div = 1.0 / (double)nodes.length;
            double loc = 0.0;
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i].setLocation(loc);
                loc += div;
            }
        }
        if (forceNeighbourConnections) {
            for (int i = 0; i < nodes.length; ++i) {
                int next = (i + 1) % nodes.length;
                RealNodeTest.connect(nodes[i], nodes[next]);
            }
        }
        for (int i = 0; i < nodes.length; ++i) {
            Node b;
            Node a = nodes[i];
            double norm = 0.0;
            for (int j = 0; j < nodes.length; ++j) {
                b = nodes[j];
                if (a.getLocation() == b.getLocation()) continue;
                norm += 1.0 / RealNodeTest.distance(a, b);
            }
            block4: for (int k = 0; k < nodes.length; ++k) {
                b = nodes[k];
                if (a.getLocation() == b.getLocation()) continue;
                double p = 1.0 / RealNodeTest.distance(a, b) / norm;
                for (int n = 0; n < degree / 2; ++n) {
                    if (!(Math.random() < p)) continue;
                    RealNodeTest.connect(a, b);
                    continue block4;
                }
            }
        }
    }

    static void connect(Node a, Node b) {
        try {
            a.connect(b);
            b.connect(a);
        }
        catch (FSParseException e) {
            Logger.error(RealNodeSecretPingTest.class, "cannot connect!!!!", e);
        }
        catch (PeerParseException e) {
            Logger.error(RealNodeSecretPingTest.class, "cannot connect #2!!!!", e);
        }
        catch (ReferenceSignatureVerificationException e) {
            Logger.error(RealNodeSecretPingTest.class, "cannot connect #3!!!!", e);
        }
    }

    static double distance(Node a, Node b) {
        double aL = a.getLocation();
        double bL = b.getLocation();
        return Location.distance(aL, bL);
    }

    static String getPortNumber(PeerNode p) {
        if (p == null || p.getPeer() == null) {
            return "null";
        }
        return Integer.toString(p.getPeer().getPort());
    }

    static String getPortNumber(Node n) {
        if (n == null) {
            return "null";
        }
        return Integer.toString(n.getDarknetPortNumber());
    }

    static void waitForAllConnected(Node[] nodes) throws InterruptedException {
        long tStart = System.currentTimeMillis();
        while (true) {
            int countFullyConnected = 0;
            int countReallyConnected = 0;
            int totalPeers = 0;
            int totalConnections = 0;
            int totalPartialConnections = 0;
            int totalCompatibleConnections = 0;
            int totalBackedOff = 0;
            double totalPingTime = 0.0;
            double maxPingTime = 0.0;
            double minPingTime = Double.MAX_VALUE;
            for (int i = 0; i < nodes.length; ++i) {
                int countConnected = nodes[i].peers.countConnectedDarknetPeers();
                int countAlmostConnected = nodes[i].peers.countAlmostConnectedDarknetPeers();
                int countTotal = nodes[i].peers.countValidPeers();
                int countBackedOff = nodes[i].peers.countBackedOffPeers();
                int countCompatible = nodes[i].peers.countCompatibleDarknetPeers();
                totalPeers += countTotal;
                totalConnections += countConnected;
                totalPartialConnections += countAlmostConnected;
                totalCompatibleConnections += countCompatible;
                totalBackedOff += countBackedOff;
                double pingTime = nodes[i].nodeStats.getNodeAveragePingTime();
                totalPingTime += pingTime;
                if (pingTime > maxPingTime) {
                    maxPingTime = pingTime;
                }
                if (pingTime < minPingTime) {
                    minPingTime = pingTime;
                }
                if (countConnected == countTotal) {
                    ++countFullyConnected;
                    if (countBackedOff == 0) {
                        ++countReallyConnected;
                    }
                } else if (Logger.shouldLog(4, RealNodeTest.class)) {
                    Logger.minor(RealNodeTest.class, "Connection count for " + nodes[i] + " : " + countConnected + " partial " + countAlmostConnected);
                }
                if (countBackedOff <= 0 || !Logger.shouldLog(4, RealNodeTest.class)) continue;
                Logger.minor(RealNodeTest.class, "Backed off: " + nodes[i] + " : " + countBackedOff);
            }
            double avgPingTime = totalPingTime / (double)nodes.length;
            if (countFullyConnected == nodes.length && countReallyConnected == nodes.length && minPingTime < 700.0 && maxPingTime < 700.0 && avgPingTime < 700.0) {
                System.err.println("All nodes fully connected");
                Logger.normal(RealNodeTest.class, "All nodes fully connected");
                System.err.println();
                return;
            }
            long tDelta = (System.currentTimeMillis() - tStart) / 1000L;
            System.err.println("Waiting for nodes to be fully connected: " + countFullyConnected + " / " + nodes.length + " (" + totalConnections + " / " + totalPeers + " connections total partial " + totalPartialConnections + " compatible " + totalCompatibleConnections + ") - backed off " + totalBackedOff + " ping min/avg/max " + (int)minPingTime + "/" + (int)avgPingTime + "/" + (int)maxPingTime + " at " + tDelta + 's');
            Logger.normal(RealNodeTest.class, "Waiting for nodes to be fully connected: " + countFullyConnected + " / " + nodes.length + " (" + totalConnections + " / " + totalPeers + " connections total partial " + totalPartialConnections + " compatible " + totalCompatibleConnections + ") - backed off " + totalBackedOff + " ping min/avg/max " + (int)minPingTime + "/" + (int)avgPingTime + "/" + (int)maxPingTime + " at " + tDelta + 's');
            Thread.sleep(1000L);
        }
    }
}

