/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Location;
import freenet.node.NetworkIDManager;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.PeerNode;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import java.io.File;

public class RealNodeSecretPingTest {
    static final int NUMBER_OF_NODES = 15;
    static final short MAX_HTL = 6;
    static final int DEGREE = 5;
    static final short PING_HTL = 6;
    static final short DAWN_HTL = 4;
    static final int SECRETPONG_TIMEOUT = 5000;
    static final long storeSize = 0x100000L;
    public static int DARKNET_PORT_BASE = RealNodeRoutingTest.DARKNET_PORT_END;
    public static final int DARKNET_PORT_END = DARKNET_PORT_BASE + 15;

    public static void main(String[] args) throws FSParseException, PeerParseException, LoggerHook.InvalidThresholdException, NodeInitException, ReferenceSignatureVerificationException {
        int i;
        System.out.println("SecretPing (CRAM) test using real nodes:");
        System.out.println();
        String wd = "realNodeSecretPingTest";
        new File(wd).mkdir();
        NodeStarter.globalTestInit(wd, false, 16, "freenet.node.Location:normal,freenet.node.simulator.RealNodeSecretPingTest:normal,freenet.node.NetworkIDManager:normal", true);
        DummyRandomSource random = new DummyRandomSource();
        Node[] nodes = new Node[15];
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        NetworkIDManager.disableSecretPings = false;
        NetworkIDManager.disableSecretPinger = true;
        for (i = 0; i < 15; ++i) {
            nodes[i] = NodeStarter.createTestNode(DARKNET_PORT_BASE + i, 0, wd, true, (short)6, 0, random, executor, 7500, 0x100000L, true, true, false, false, false, true, true, 0, true, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created node " + i);
        }
        Logger.normal(RealNodeRoutingTest.class, "Created 15 nodes");
        RealNodeSecretPingTest.makeKleinbergNetwork(nodes);
        Logger.normal(RealNodeRoutingTest.class, "Added small-world links");
        for (i = 0; i < 15; ++i) {
            nodes[i].start(false);
        }
        int cycleNumber = 0;
        BootstrappingDecayingRunningAverage avg2 = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 100, null);
        while (true) {
            ++cycleNumber;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Node source = nodes[random.nextInt(15)];
            PeerNode verify = source.peers.getRandomPeer();
            PeerNode pathway = source.peers.getRandomPeer(verify);
            Logger.error(source, "verify (" + RealNodeSecretPingTest.getPortNumber(verify) + ") through: " + RealNodeSecretPingTest.getPortNumber(pathway) + "; so far " + avg2.currentValue());
            long uid = random.nextLong();
            long secret = random.nextLong();
            if (verify == null) {
                Logger.error(source, "verify peernode is null");
                continue;
            }
            if (pathway == null) {
                Logger.error(source, "pathway peernode is null");
                continue;
            }
            try {
                verify.sendSync(DMT.createFNPStoreSecret(uid, secret), null);
                if (!RealNodeSecretPingTest.getAck(source, verify, uid)) {
                    Logger.error(source, "did not get storesecret ack for " + uid);
                    avg2.report(0.0);
                    continue;
                }
                pathway.sendSync(DMT.createFNPSecretPing(uid, verify.getLocation(), (short)6, (short)4, 0, verify.getIdentity()), null);
                long result = RealNodeSecretPingTest.getSecretPingResponse(source, pathway, uid);
                if (result != secret) {
                    Logger.error(source, "not matched: " + secret + " != " + result);
                    avg2.report(0.0);
                    continue;
                }
                Logger.error(source, "match: " + secret);
                avg2.report(1.0);
                continue;
            }
            catch (NotConnectedException e) {
                Logger.error(source, "what?", e);
                avg2.report(0.0);
                continue;
            }
            catch (DisconnectedException e) {
                Logger.error(source, "huh?", e);
                avg2.report(0.0);
                continue;
            }
            break;
        }
    }

    private static boolean getAck(Node source, PeerNode pathway, long uid) throws DisconnectedException {
        MessageFilter mfAccepted = MessageFilter.create().setSource(pathway).setField("uid", uid).setTimeout(5000).setType(DMT.FNPAccepted);
        Message msg = source.getUSM().waitFor(mfAccepted, null);
        if (msg == null) {
            return false;
        }
        if (msg.getSpec() == DMT.FNPAccepted) {
            return true;
        }
        Logger.error(source, "got " + msg);
        return false;
    }

    private static long getSecretPingResponse(Node source, PeerNode pathway, long uid) throws DisconnectedException {
        MessageFilter mfPong = MessageFilter.create().setSource(pathway).setField("uid", uid).setTimeout(5000).setType(DMT.FNPSecretPong);
        MessageFilter mfRejectLoop = MessageFilter.create().setSource(pathway).setField("uid", uid).setTimeout(5000).setType(DMT.FNPRejectedLoop);
        Message msg = source.getUSM().waitFor(mfPong.or(mfRejectLoop), null);
        if (msg == null) {
            Logger.error(source, "fatal timeout in waiting for secretpong from " + RealNodeSecretPingTest.getPortNumber(pathway));
            return -2L;
        }
        if (msg.getSpec() == DMT.FNPSecretPong) {
            int suppliedCounter = msg.getInt("counter");
            long secret = msg.getLong("secret");
            Logger.normal(source, "got secret, counter=" + suppliedCounter);
            return secret;
        }
        if (msg.getSpec() == DMT.FNPRejectedLoop) {
            Logger.error(source, "top level secret ping should not reject!: " + RealNodeSecretPingTest.getPortNumber(source) + " -> " + RealNodeSecretPingTest.getPortNumber(pathway));
            return -1L;
        }
        return -3L;
    }

    static void makeKleinbergNetwork(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Node b;
            Node a = nodes[i];
            double norm = 0.0;
            for (int j = 0; j < nodes.length; ++j) {
                b = nodes[j];
                if (a.getLocation() == b.getLocation()) continue;
                norm += 1.0 / RealNodeSecretPingTest.distance(a, b);
            }
            block6: for (int k = 0; k < nodes.length; ++k) {
                b = nodes[k];
                if (a.getLocation() == b.getLocation()) continue;
                double p = 1.0 / RealNodeSecretPingTest.distance(a, b) / norm;
                for (int n = 0; n < 2; ++n) {
                    if (!(Math.random() < p)) continue;
                    try {
                        a.connect(b);
                        b.connect(a);
                    }
                    catch (FSParseException e) {
                        Logger.error(RealNodeSecretPingTest.class, "cannot connect!!!!", e);
                    }
                    catch (PeerParseException e) {
                        Logger.error(RealNodeSecretPingTest.class, "cannot connect #2!!!!", e);
                    }
                    catch (ReferenceSignatureVerificationException e) {
                        Logger.error(RealNodeSecretPingTest.class, "cannot connect #3!!!!", e);
                    }
                    continue block6;
                }
            }
        }
    }

    static double distance(Node a, Node b) {
        double aL = a.getLocation();
        double bL = b.getLocation();
        return Location.distance(aL, bL);
    }

    static String getPortNumber(PeerNode p) {
        if (p == null || p.getPeer() == null) {
            return "null";
        }
        return Integer.toString(p.getPeer().getPort());
    }

    static String getPortNumber(Node n) {
        if (n == null) {
            return "null";
        }
        return Integer.toString(n.getDarknetPortNumber());
    }
}

