/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.crypt.RandomSource;
import freenet.node.LocationManager;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.simulator.RealNodeTest;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.io.FileUtil;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.SimpleRunningAverage;
import java.io.File;

public class RealNodeRoutingTest
extends RealNodeTest {
    static final int NUMBER_OF_NODES = 500;
    static final int DEGREE = 10;
    static final short MAX_HTL = 10;
    static final boolean START_WITH_IDEAL_LOCATIONS = true;
    static final boolean FORCE_NEIGHBOUR_CONNECTIONS = true;
    static final int MAX_PINGS = 2000;
    static final boolean ENABLE_SWAPPING = false;
    static final boolean ENABLE_SWAP_QUEUEING = false;
    static final boolean ENABLE_FOAF = true;
    public static int DARKNET_PORT_BASE = 5178;
    public static final int DARKNET_PORT_END = DARKNET_PORT_BASE + 500;

    public static void main(String[] args) throws Exception {
        int i;
        System.out.println("Routing test using real nodes:");
        System.out.println();
        String dir = "realNodeRequestInsertTest";
        File wd = new File(dir);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        wd.mkdir();
        NodeStarter.globalTestInit(dir, false, 16, "", true);
        DummyRandomSource random = new DummyRandomSource();
        Node[] nodes = new Node[500];
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (i = 0; i < 500; ++i) {
            System.err.println("Creating node " + i);
            nodes[i] = NodeStarter.createTestNode(DARKNET_PORT_BASE + i, 0, dir, true, (short)10, 0, random, executor, 250000, 65536L, true, false, false, false, false, false, true, 0, true, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created node " + i);
        }
        Logger.normal(RealNodeRoutingTest.class, "Created 500 nodes");
        RealNodeRoutingTest.makeKleinbergNetwork(nodes, true, 10, true);
        Logger.normal(RealNodeRoutingTest.class, "Added random links");
        for (i = 0; i < 500; ++i) {
            System.err.println("Starting node " + i);
            nodes[i].start(false);
        }
        RealNodeRoutingTest.waitForAllConnected(nodes);
        RealNodeRoutingTest.waitForPingAverage(0.98, nodes, random, 2000, 5000);
    }

    static void waitForPingAverage(double accuracy, Node[] nodes, RandomSource random, int maxTests, int sleepTime) throws InterruptedException {
        int totalHopsTaken = 0;
        int cycleNumber = 0;
        int lastSwaps = 0;
        int lastNoSwaps = 0;
        int failures = 0;
        int successes = 0;
        SimpleRunningAverage avg = new SimpleRunningAverage(100, 0.0);
        BootstrappingDecayingRunningAverage avg2 = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 100, null);
        int pings = 0;
        for (int total = 0; total < maxTests; ++total) {
            int i;
            ++cycleNumber;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                System.err.println("Cycle " + cycleNumber + " node " + i2 + ": " + nodes[i2].getLocation());
            }
            int newSwaps = LocationManager.swaps;
            int totalStarted = LocationManager.startedSwaps;
            int noSwaps = LocationManager.noSwaps;
            System.err.println("Swaps: " + (newSwaps - lastSwaps));
            System.err.println("\nTotal swaps: Started*2: " + totalStarted * 2 + ", succeeded: " + newSwaps + ", last minute failures: " + noSwaps + ", ratio " + (double)noSwaps / (double)newSwaps + ", early failures: " + (totalStarted * 2 - (noSwaps + newSwaps)));
            System.err.println("This cycle ratio: " + (double)(noSwaps - lastNoSwaps) / (double)(newSwaps - lastSwaps));
            lastNoSwaps = noSwaps;
            System.err.println("Swaps rejected (already locked): " + LocationManager.swapsRejectedAlreadyLocked);
            System.err.println("Swaps rejected (nowhere to go): " + LocationManager.swapsRejectedNowhereToGo);
            System.err.println("Swaps rejected (rate limit): " + LocationManager.swapsRejectedRateLimit);
            System.err.println("Swaps rejected (recognized ID):" + LocationManager.swapsRejectedRecognizedID);
            System.err.println("Swaps failed:" + LocationManager.noSwaps);
            System.err.println("Swaps succeeded:" + LocationManager.swaps);
            double totalSwapInterval = 0.0;
            double totalSwapTime = 0.0;
            for (i = 0; i < nodes.length; ++i) {
                totalSwapInterval += (double)nodes[i].lm.getSendSwapInterval();
                totalSwapTime += (double)nodes[i].lm.getAverageSwapTime();
            }
            System.err.println("Average swap time: " + totalSwapTime / (double)nodes.length);
            System.err.println("Average swap sender interval: " + totalSwapInterval / (double)nodes.length);
            RealNodeRoutingTest.waitForAllConnected(nodes);
            lastSwaps = newSwaps;
            for (i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                try {
                    double ratio;
                    Node randomNode;
                    Node randomNode2 = randomNode = nodes[random.nextInt(nodes.length)];
                    while (randomNode2 == randomNode) {
                        randomNode2 = nodes[random.nextInt(nodes.length)];
                    }
                    double loc2 = randomNode2.getLocation();
                    Logger.normal(RealNodeRoutingTest.class, "Pinging " + randomNode2.getDarknetPortNumber() + " @ " + loc2 + " from " + randomNode.getDarknetPortNumber() + " @ " + randomNode.getLocation());
                    int hopsTaken = randomNode.routedPing(loc2, randomNode2.getDarknetIdentity());
                    ++pings;
                    if (hopsTaken < 0) {
                        avg.report(0.0);
                        avg2.report(0.0);
                        ratio = (double)successes / (double)(++failures + successes);
                        System.err.println("Routed ping " + pings + " FAILED from " + randomNode.getDarknetPortNumber() + " to " + randomNode2.getDarknetPortNumber() + " (long:" + ratio + ", short:" + avg.currentValue() + ", vague:" + avg2.currentValue() + ')');
                        continue;
                    }
                    totalHopsTaken += hopsTaken;
                    avg.report(1.0);
                    avg2.report(1.0);
                    ratio = (double)(++successes) / (double)(failures + successes);
                    System.err.println("Routed ping " + pings + " success: " + hopsTaken + ' ' + randomNode.getDarknetPortNumber() + " to " + randomNode2.getDarknetPortNumber() + " (long:" + ratio + ", short:" + avg.currentValue() + ", vague:" + avg2.currentValue() + ')');
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(RealNodeRoutingTest.class, "Caught " + t, t);
                }
            }
            if (pings <= 10 || !(avg.currentValue() > accuracy) || !((double)successes / (double)(failures + successes) > accuracy)) continue;
            System.err.println();
            System.err.println("Reached " + accuracy * 100.0 + "% accuracy.");
            System.err.println();
            System.err.println("Network size: " + nodes.length);
            System.err.println("Maximum HTL: 10");
            System.err.println("Average path length for successful requests: " + totalHopsTaken / successes);
            System.err.println("Total started swaps: " + LocationManager.startedSwaps);
            System.err.println("Total rejected swaps (already locked): " + LocationManager.swapsRejectedAlreadyLocked);
            System.err.println("Total swaps rejected (nowhere to go): " + LocationManager.swapsRejectedNowhereToGo);
            System.err.println("Total swaps rejected (rate limit): " + LocationManager.swapsRejectedRateLimit);
            System.err.println("Total swaps rejected (recognized ID):" + LocationManager.swapsRejectedRecognizedID);
            System.err.println("Total swaps failed:" + LocationManager.noSwaps);
            System.err.println("Total swaps succeeded:" + LocationManager.swaps);
            return;
        }
        System.exit(1028);
    }
}

