/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKSK;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.FSParseException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.io.ArrayBucket;
import freenet.support.io.FileUtil;
import freenet.support.math.SimpleRunningAverage;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;

public class RealNodeRequestInsertTest
extends RealNodeRoutingTest {
    static final int NUMBER_OF_NODES = 100;
    static final int DEGREE = 10;
    static final short MAX_HTL = 10;
    static final boolean START_WITH_IDEAL_LOCATIONS = true;
    static final boolean FORCE_NEIGHBOUR_CONNECTIONS = true;
    static final boolean ENABLE_SWAPPING = false;
    static final boolean ENABLE_ULPRS = false;
    static final boolean ENABLE_PER_NODE_FAILURE_TABLES = false;
    static final boolean ENABLE_SWAP_QUEUEING = false;
    static final boolean ENABLE_PACKET_COALESCING = true;
    static final boolean ENABLE_FOAF = true;
    static final int TARGET_SUCCESSES = 20;
    public static final int DARKNET_PORT_BASE = 5078;
    public static final int DARKNET_PORT_END = 5178;

    public static void main(String[] args) throws FSParseException, PeerParseException, CHKEncodeException, LoggerHook.InvalidThresholdException, NodeInitException, ReferenceSignatureVerificationException, InterruptedException {
        int i;
        String name = "realNodeRequestInsertTest";
        File wd = new File(name);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        wd.mkdir();
        NodeStarter.globalTestInit(name, false, 16, "", true);
        System.out.println("Insert/retrieve test");
        System.out.println();
        DummyRandomSource random = new DummyRandomSource();
        Node[] nodes = new Node[100];
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (i = 0; i < 100; ++i) {
            nodes[i] = NodeStarter.createTestNode(5078 + i, 0, name, false, (short)10, 20, random, executor, 50000, 262144L, true, false, false, false, false, false, true, 12000, true, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created node " + i);
        }
        RealNodeRequestInsertTest.makeKleinbergNetwork(nodes, true, 10, true);
        Logger.normal(RealNodeRoutingTest.class, "Added random links");
        for (i = 0; i < 100; ++i) {
            nodes[i].start(false);
            System.err.println("Started node " + i + "/" + nodes.length);
        }
        RealNodeRequestInsertTest.waitForAllConnected(nodes);
        RealNodeRequestInsertTest.waitForPingAverage(0.95, nodes, random, 2000, 1000);
        System.out.println();
        System.out.println("Ping average > 95%, lets do some inserts/requests");
        System.out.println();
        int requestNumber = 0;
        SimpleRunningAverage requestsAvg = new SimpleRunningAverage(100, 0.0);
        String baseString = System.currentTimeMillis() + " ";
        int insertAttempts = 0;
        int insertSuccesses = 0;
        int fetchSuccesses = 0;
        while (true) {
            try {
                while (true) {
                    int node2;
                    ClientKeyBlock block;
                    ClientKey fetchKey;
                    ClientKey insertKey;
                    FreenetURI testKey;
                    ++requestNumber;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    String dataString = baseString + requestNumber;
                    int node1 = random.nextInt(100);
                    Node randomNode = nodes[node1];
                    boolean isSSK = true;
                    byte[] buf = dataString.getBytes("UTF-8");
                    if (isSSK) {
                        testKey = new FreenetURI("KSK", dataString);
                        insertKey = InsertableClientSSK.create(testKey);
                        fetchKey = ClientKSK.create(testKey);
                        block = ((InsertableClientSSK)insertKey).encode(new ArrayBucket(buf), false, false, (short)-1, buf.length, random);
                    } else {
                        block = ClientCHKBlock.encode(buf, false, false, (short)-1, buf.length);
                        insertKey = fetchKey = block.getClientKey();
                        testKey = insertKey.getURI();
                    }
                    System.err.println();
                    System.err.println("Created random test key " + testKey + " = " + fetchKey.getNodeKey());
                    System.err.println();
                    byte[] data = dataString.getBytes("UTF-8");
                    Logger.minor(RealNodeRequestInsertTest.class, "Decoded: " + new String(block.memoryDecode()));
                    Logger.normal(RealNodeRequestInsertTest.class, "Insert Key: " + insertKey.getURI());
                    Logger.normal(RealNodeRequestInsertTest.class, "Fetch Key: " + fetchKey.getURI());
                    try {
                        ++insertAttempts;
                        randomNode.clientCore.realPut(block, true);
                        Logger.error(RealNodeRequestInsertTest.class, "Inserted to " + node1);
                        ++insertSuccesses;
                    }
                    catch (LowLevelPutException putEx) {
                        Logger.error(RealNodeRequestInsertTest.class, "Insert failed: " + putEx);
                        System.err.println("Insert failed: " + putEx);
                        System.exit(1029);
                    }
                    while ((node2 = random.nextInt(100)) == node1) {
                    }
                    Node fetchNode = nodes[node2];
                    block = fetchNode.clientCore.realGetKey(fetchKey, false, true, false);
                    if (block == null) {
                        int percentSuccess = 100 * fetchSuccesses / insertAttempts;
                        Logger.error(RealNodeRequestInsertTest.class, "Fetch #" + requestNumber + " FAILED (" + percentSuccess + "%); from " + node2);
                        requestsAvg.report(0.0);
                        System.exit(1030);
                    } else {
                        byte[] results = block.memoryDecode();
                        requestsAvg.report(1.0);
                        if (Arrays.equals(results, data)) {
                            int percentSuccess = 100 * ++fetchSuccesses / insertAttempts;
                            Logger.error(RealNodeRequestInsertTest.class, "Fetch #" + requestNumber + " from node " + node2 + " succeeded (" + percentSuccess + "%): " + new String(results));
                            System.err.println("Fetch #" + requestNumber + " succeeded (" + percentSuccess + "%): \"" + new String(results) + '\"');
                            if (fetchSuccesses == 20) {
                                System.err.println("Succeeded, 20 successful fetches");
                                System.exit(0);
                            }
                        } else {
                            Logger.error(RealNodeRequestInsertTest.class, "Returned invalid data!: " + new String(results));
                            System.err.println("Returned invalid data!: " + new String(results));
                            System.exit(1031);
                        }
                    }
                    StringBuilder load = new StringBuilder("Running UIDs for nodes: ");
                    int totalRunningUIDs = 0;
                    int totalRunningUIDsAlt = 0;
                    Vector<Long> runningUIDsList = new Vector<Long>();
                    for (int i2 = 0; i2 < nodes.length; ++i2) {
                        load.append(i2);
                        load.append(':');
                        nodes[i2].addRunningUIDs(runningUIDsList);
                        int runningUIDs = nodes[i2].getTotalRunningUIDs();
                        int runningUIDsAlt = nodes[i2].getTotalRunningUIDsAlt();
                        load.append(totalRunningUIDs += runningUIDs);
                        load.append(':');
                        load.append(totalRunningUIDsAlt += runningUIDsAlt);
                        if (i2 == nodes.length - 1) continue;
                        load.append(' ');
                    }
                    System.err.println(load.toString());
                    if (totalRunningUIDs != 0) {
                        System.err.println("Still running UIDs: " + totalRunningUIDs);
                    }
                    if (totalRunningUIDsAlt != 0) {
                        System.err.println("Still running UIDs (alt): " + totalRunningUIDsAlt);
                    }
                    if (runningUIDsList.isEmpty()) continue;
                    System.err.println("List of running UIDs: " + Arrays.toString(runningUIDsList.toArray()));
                }
            }
            catch (Throwable t) {
                Logger.error(RealNodeRequestInsertTest.class, "Caught " + t, t);
                continue;
            }
            break;
        }
    }
}

