/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.RandomSource;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.PeerNode;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;

public class RealNodePingTest {
    public static final int DARKNET_PORT1 = 5076;
    public static final int DARKNET_PORT2 = 5077;

    public static void main(String[] args) throws FSParseException, PeerParseException, InterruptedException, ReferenceSignatureVerificationException, NodeInitException, LoggerHook.InvalidThresholdException {
        RandomSource random = NodeStarter.globalTestInit("pingtest", false, 16, "", true);
        PooledExecutor executor = new PooledExecutor();
        Node node1 = NodeStarter.createTestNode(5076, 0, "pingtest", true, (short)10, 0, random, executor, 1000, 65536L, true, false, false, false, false, false, true, 0, false, false, null);
        Node node2 = NodeStarter.createTestNode(5077, 0, "pingtest", true, (short)10, 0, random, executor, 1000, 65536L, true, false, false, false, false, false, true, 0, false, false, null);
        node1.connect(node2);
        node2.connect(node1);
        node1.start(true);
        node2.start(true);
        PeerNode pn = node1.getPeerNodes()[0];
        int pingID = 0;
        Thread.sleep(20000L);
        while (true) {
            boolean success;
            Logger.minor(RealNodePingTest.class, "Sending PING " + pingID);
            try {
                success = pn.ping(pingID);
            }
            catch (NotConnectedException e1) {
                Logger.normal(RealNodePingTest.class, "Not connected");
                continue;
            }
            if (success) {
                Logger.normal(RealNodePingTest.class, "PING " + pingID + " successful");
            } else {
                Logger.normal(RealNodePingTest.class, "PING FAILED: " + pingID);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++pingID;
        }
    }
}

