/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.NetworkIDManager;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.node.simulator.RealNodeTest;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.TrivialRunningAverage;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealNodeNetworkColoringTest
extends RealNodeTest {
    static final int NUMBER_OF_NODES = 20;
    static final int BRIDGES = 3;
    static final int BRIDGE_LINKS = 2;
    static final short MAX_HTL = 6;
    static final int DEGREE = 5;
    static final boolean ENABLE_FOAF = false;
    static final long storeSize = 0x100000L;
    static final int DARKNET_PORT_BASE = 5033;
    static final int TOTAL_NODES = 43;
    static final int DARKNET_PORT_END = 5076;
    private static final Object log = new Object();

    public static void main(String[] args) throws FSParseException, PeerParseException, LoggerHook.InvalidThresholdException, NodeInitException, ReferenceSignatureVerificationException {
        int i;
        System.out.println("SecretPing/NetworkColoring test using real nodes:");
        System.out.println();
        String wd = "realNodeNetworkColorTest";
        new File(wd).mkdir();
        NodeStarter.globalTestInit(wd, false, 16, "freenet.node.Location:normal,freenet.node.simulator.RealNodeNetworkColoringTest:normal,freenet.node.NetworkIDManager:normal", true);
        DummyRandomSource random = new DummyRandomSource();
        Node[] subnetA = new Node[20];
        Node[] subnetB = new Node[20];
        Node[] bridges = new Node[3];
        int totalNodes = 43;
        Node[] allNodes = new Node[totalNodes];
        totalNodes = 0;
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        NetworkIDManager.disableSecretPings = false;
        NetworkIDManager.disableSecretPinger = false;
        for (i = 0; i < 20; ++i) {
            allNodes[totalNodes] = subnetA[i] = NodeStarter.createTestNode(5033 + totalNodes, 0, wd, true, (short)6, 0, random, executor, 10000, 0x100000L, true, true, false, false, false, false, true, 0, false, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created 'A' node " + ++totalNodes);
        }
        for (i = 0; i < 20; ++i) {
            allNodes[totalNodes] = subnetB[i] = NodeStarter.createTestNode(5033 + totalNodes, 0, wd, true, (short)6, 0, random, executor, 10000, 0x100000L, true, true, false, false, false, false, true, 0, false, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created 'B' node " + ++totalNodes);
        }
        for (i = 0; i < 3; ++i) {
            allNodes[totalNodes] = bridges[i] = NodeStarter.createTestNode(5033 + totalNodes, 0, wd, true, (short)6, 0, random, executor, 10000, 0x100000L, true, true, false, false, false, false, true, 0, false, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created bridge node " + ++totalNodes);
        }
        Logger.normal(RealNodeRoutingTest.class, "Created " + totalNodes + " nodes");
        RealNodeNetworkColoringTest.makeKleinbergNetwork(subnetA, true, 5, false);
        RealNodeNetworkColoringTest.makeKleinbergNetwork(subnetB, true, 5, false);
        int aTarget = RealNodeNetworkColoringTest.countLeafs(subnetA) + 1;
        int bTarget = RealNodeNetworkColoringTest.countLeafs(subnetB) + 1;
        int generalTarget = aTarget + bTarget + 3;
        Logger.normal(RealNodeRoutingTest.class, "Added small-world links, weakly connect the subnets");
        for (int b = 0; b < 3; ++b) {
            int i2;
            Node bridge = bridges[b];
            for (i2 = 0; i2 < 2; ++i2) {
                Node nodeA = subnetA[random.nextInt(20)];
                RealNodeNetworkColoringTest.connect(bridge, nodeA);
            }
            for (i2 = 0; i2 < 2; ++i2) {
                Node nodeB = subnetB[random.nextInt(20)];
                RealNodeNetworkColoringTest.connect(bridge, nodeB);
            }
        }
        for (int i3 = 0; i3 < totalNodes; ++i3) {
            allNodes[i3].start(false);
        }
        int cycleNumber = 0;
        BootstrappingDecayingRunningAverage general = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 2000, null);
        BootstrappingDecayingRunningAverage aRate = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 500, null);
        BootstrappingDecayingRunningAverage bRate = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 500, null);
        BootstrappingDecayingRunningAverage bridgeRate = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 500, null);
        HashSet<Integer> generalIds = new HashSet<Integer>();
        HashSet<Integer> aIds = new HashSet<Integer>();
        HashSet<Integer> bIds = new HashSet<Integer>();
        HashSet<Integer> bridgeIds = new HashSet<Integer>();
        while (true) {
            double rate;
            int id;
            long total;
            long good;
            int i4;
            ++cycleNumber;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            TrivialRunningAverage aLoc = new TrivialRunningAverage();
            TrivialRunningAverage bLoc = new TrivialRunningAverage();
            long totalSuccesses = 0L;
            long totalTotalPings = 0L;
            generalIds.clear();
            aIds.clear();
            bIds.clear();
            bridgeIds.clear();
            for (i4 = 0; i4 < 20; ++i4) {
                good = subnetA[i4].netid.secretPingSuccesses;
                total = subnetA[i4].netid.totalSecretPingAttempts;
                id = subnetA[i4].netid.ourNetworkId;
                aLoc.report(subnetA[i4].getLocation());
                totalSuccesses += good;
                totalTotalPings += total;
                rate = 0.0;
                if (total != 0L) {
                    rate = 1.0 * (double)good / (double)total;
                }
                general.report(rate);
                aRate.report(rate);
                generalIds.add(id);
                aIds.add(id);
            }
            for (i4 = 0; i4 < 20; ++i4) {
                good = subnetB[i4].netid.secretPingSuccesses;
                total = subnetB[i4].netid.totalSecretPingAttempts;
                id = subnetB[i4].netid.ourNetworkId;
                bLoc.report(subnetB[i4].getLocation());
                totalSuccesses += good;
                totalTotalPings += total;
                rate = 0.0;
                if (total != 0L) {
                    rate = 1.0 * (double)good / (double)total;
                }
                general.report(rate);
                bRate.report(rate);
                generalIds.add(id);
                bIds.add(id);
            }
            for (i4 = 0; i4 < 3; ++i4) {
                good = bridges[i4].netid.secretPingSuccesses;
                total = bridges[i4].netid.totalSecretPingAttempts;
                id = bridges[i4].netid.ourNetworkId;
                totalSuccesses += good;
                totalTotalPings += total;
                rate = 0.0;
                if (total != 0L) {
                    rate = 1.0 * (double)good / (double)total;
                }
                general.report(rate);
                bridgeRate.report(rate);
                generalIds.add(id);
                bridgeIds.add(id);
            }
            Logger.error(log, "cycle = " + cycleNumber);
            Logger.error(log, "total SecretPings= " + totalTotalPings);
            Logger.error(log, "total successful = " + totalSuccesses);
            Logger.error(log, "  pSuccess(All)  = " + general.currentValue());
            Logger.error(log, "  pSuccess( A )  = " + aRate.currentValue());
            Logger.error(log, "  pSuccess( B )  = " + bRate.currentValue());
            Logger.error(log, "  pSuccess(BRG)  = " + bridgeRate.currentValue());
            RealNodeNetworkColoringTest.idReport("All", generalIds, generalTarget);
            RealNodeNetworkColoringTest.idReport(" A ", aIds, aTarget);
            RealNodeNetworkColoringTest.idReport(" B ", bIds, bTarget);
            RealNodeNetworkColoringTest.idReport("BRG", bridgeIds, 3);
            Logger.error(log, " aLoc = " + aLoc.currentValue());
            Logger.error(log, " bLoc = " + bLoc.currentValue());
        }
    }

    private static void idReport(String group, HashSet<Integer> ids, int targetNum) {
        int size = ids.size();
        int MAX = 6;
        StringBuilder sb = new StringBuilder(Integer.toString(size)).append("/").append(Integer.toString(targetNum));
        sb.append(" ids (").append(group).append(") = ");
        Iterator<Integer> iter = ids.iterator();
        for (int i = 0; i <= MAX && i < size; ++i) {
            String thisId = iter.next().toString();
            if (i == 0) {
                sb.append(thisId);
                continue;
            }
            sb.append(", ").append(thisId);
        }
        if (size > MAX) {
            sb.append(", ...");
        }
        Logger.error(log, sb.toString());
    }

    private static int countLeafs(Node[] network) {
        int retval = 0;
        for (int i = 0; i < network.length; ++i) {
            int peers = network[i].peers.countValidPeers();
            if (peers > 1) continue;
            ++retval;
        }
        return retval;
    }
}

