/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class URIGeneratedMessage
extends FCPMessage {
    private final FreenetURI uri;
    private final String identifier;
    private final boolean global;

    public URIGeneratedMessage(FreenetURI uri, String identifier, boolean global) {
        this.uri = uri;
        this.identifier = identifier;
        this.global = global;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("URI", this.uri.toString());
        fs.putSingle("Identifier", this.identifier);
        fs.put("Global", this.global);
        return fs;
    }

    public String getName() {
        return "URIGenerated";
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "URIGenerated goes from server to client not the other way around", this.identifier, false);
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.delete((Object)this);
    }
}

