/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.TestDDACompleteMessage;
import freenet.support.SimpleFieldSet;

public class TestDDAResponseMessage
extends FCPMessage {
    public static final String NAME = "TestDDAResponse";
    public static final String READ_CONTENT = "ReadContent";
    final String identifier;
    final String readContent;

    public TestDDAResponseMessage(SimpleFieldSet sfs) throws MessageInvalidException {
        this.identifier = sfs.get("Directory");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Directory given!", null, false);
        }
        if (this.identifier.length() == 0) {
            throw new MessageInvalidException(5, "The specified Directory can't be empty!", null, false);
        }
        this.readContent = sfs.get(READ_CONTENT);
    }

    public SimpleFieldSet getFieldSet() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        FCPConnectionHandler.DDACheckJob job;
        try {
            job = handler.popDDACheck(this.identifier);
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, e.getMessage(), this.identifier, false);
        }
        if (job == null) {
            throw new MessageInvalidException(7, "The node doesn't know that testDDA identifier! double check it! (" + this.identifier + ").", this.identifier, false);
        }
        if (job.readFilename != null && this.readContent == null) {
            throw new MessageInvalidException(5, "You need to send ReadContent back to the node if you specify WantReadDirectory in TestDDARequest.", this.identifier, false);
        }
        TestDDACompleteMessage reply = new TestDDACompleteMessage(handler, job, this.readContent);
        handler.outputHandler.queue(reply);
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

