/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.TestDDAReplyMessage;
import freenet.support.SimpleFieldSet;

public class TestDDARequestMessage
extends FCPMessage {
    public static final String NAME = "TestDDARequest";
    public static final String DIRECTORY = "Directory";
    public static final String WANT_READ = "WantReadDirectory";
    public static final String WANT_WRITE = "WantWriteDirectory";
    final String identifier;
    final boolean wantRead;
    final boolean wantWrite;

    public TestDDARequestMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get(DIRECTORY);
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Directory given!", null, false);
        }
        if (this.identifier.length() == 0) {
            throw new MessageInvalidException(5, "The specified Directory can't be empty!", null, false);
        }
        this.wantRead = fs.getBoolean(WANT_READ, false);
        this.wantWrite = fs.getBoolean(WANT_WRITE, false);
        if (!this.wantRead && !this.wantWrite) {
            throw new MessageInvalidException(7, "Both WantReadDirectory and WantWriteDirectory are set to false: what's the point of sending a message?", this.identifier, false);
        }
    }

    public SimpleFieldSet getFieldSet() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        FCPConnectionHandler.DDACheckJob job;
        try {
            job = handler.enqueueDDACheck(this.identifier, this.wantRead, this.wantWrite);
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, e.getMessage(), this.identifier, false);
        }
        TestDDAReplyMessage reply = new TestDDAReplyMessage(job);
        handler.outputHandler.queue(reply);
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

