/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.USKCallback;
import freenet.keys.USK;
import freenet.node.NodeClientCore;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.SubscribeUSKMessage;
import freenet.node.fcp.SubscribedUSKUpdate;

public class SubscribeUSK
implements USKCallback {
    final FCPConnectionHandler handler;
    final String identifier;
    final NodeClientCore core;
    final boolean dontPoll;
    final short prio;
    final short prioProgress;
    final USK usk;

    public SubscribeUSK(SubscribeUSKMessage message, NodeClientCore core, FCPConnectionHandler handler) throws IdentifierCollisionException {
        this.handler = handler;
        this.dontPoll = message.dontPoll;
        this.identifier = message.identifier;
        this.core = core;
        this.usk = message.key;
        this.prio = message.prio;
        this.prioProgress = message.prioProgress;
        handler.addSubscription(this.identifier, this);
        core.uskManager.subscribe(message.key, this, !message.dontPoll, handler.getRebootClient().lowLevelClient);
    }

    public void onFoundEdition(long l, USK key, ObjectContainer container, ClientContext context, boolean wasMetadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (this.handler.isClosed()) {
            this.core.uskManager.unsubscribe(key, this);
            return;
        }
        SubscribedUSKUpdate msg = new SubscribedUSKUpdate(this.identifier, l, key, newKnownGood, newSlotToo);
        this.handler.outputHandler.queue(msg);
    }

    public short getPollingPriorityNormal() {
        return this.prio;
    }

    public short getPollingPriorityProgress() {
        return this.prioProgress;
    }

    public void unsubscribe() {
        this.core.uskManager.unsubscribe(this.usk, this);
    }
}

