/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.events.SplitfileProgressEvent;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class SimpleProgressMessage
extends FCPMessage {
    private final String ident;
    private final boolean global;
    private final SplitfileProgressEvent event;

    public SimpleProgressMessage(String identifier, boolean global, SplitfileProgressEvent event) {
        this.ident = identifier;
        this.event = event;
        this.global = global;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("Total", this.event.totalBlocks);
        fs.put("Required", this.event.minSuccessfulBlocks);
        fs.put("Failed", this.event.failedBlocks);
        fs.put("FatallyFailed", this.event.fatallyFailedBlocks);
        fs.put("Succeeded", this.event.succeedBlocks);
        fs.put("FinalizedTotal", this.event.finalizedTotal);
        fs.putSingle("Identifier", this.ident);
        if (this.global) {
            fs.putSingle("Global", "true");
        }
        return fs;
    }

    public String getName() {
        return "SimpleProgress";
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "SimpleProgress goes from server to client not the other way around", this.ident, this.global);
    }

    public double getFraction() {
        return (double)this.event.succeedBlocks / (double)this.event.totalBlocks;
    }

    public double getMinBlocks() {
        return this.event.minSuccessfulBlocks;
    }

    public double getTotalBlocks() {
        return this.event.totalBlocks;
    }

    public double getFetchedBlocks() {
        return this.event.succeedBlocks;
    }

    public double getFailedBlocks() {
        return this.event.failedBlocks;
    }

    public double getFatalyFailedBlocks() {
        return this.event.fatallyFailedBlocks;
    }

    public boolean isTotalFinalized() {
        return this.event.finalizedTotal;
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.event, 1);
        this.event.removeFrom(container);
        container.delete((Object)this);
    }
}

