/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Node;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class RemovePersistentRequest
extends FCPMessage {
    static final String NAME = "RemoveRequest";
    static final String ALT_NAME = "RemovePersistentRequest";
    final String identifier;
    final boolean global;

    public RemovePersistentRequest(SimpleFieldSet fs) throws MessageInvalidException {
        this.global = Fields.stringToBool(fs.get("Global"), false);
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "Must have Identifier", null, this.global);
        }
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        return fs;
    }

    public String getName() {
        return NAME;
    }

    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        ClientRequest req = handler.removePersistentRebootRequest(this.global, this.identifier);
        if (req == null && !this.global) {
            req = handler.removeRequestByIdentifier(this.identifier, true);
        }
        if (req == null) {
            try {
                handler.server.core.clientContext.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        try {
                            ClientRequest req = handler.removePersistentForeverRequest(RemovePersistentRequest.this.global, RemovePersistentRequest.this.identifier, container);
                            if (req == null) {
                                Logger.error(this, "Huh ? the request is null!");
                                return false;
                            }
                            return true;
                        }
                        catch (MessageInvalidException e) {
                            ProtocolErrorMessage err = new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global);
                            handler.outputHandler.queue(err);
                            return false;
                        }
                    }
                }, 7, false);
            }
            catch (DatabaseDisabledException e) {
                ProtocolErrorMessage err = new ProtocolErrorMessage(33, false, "Persistence disabled and non-persistent request not found", this.identifier, this.global);
                handler.outputHandler.queue(err);
            }
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

