/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ManifestElement;
import freenet.keys.FreenetURI;
import freenet.node.fcp.DirPutFile;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import java.net.MalformedURLException;

public class RedirectDirPutFile
extends DirPutFile {
    final FreenetURI targetURI;

    public RedirectDirPutFile(SimpleFieldSet subset, String identifier, boolean global) throws MessageInvalidException {
        super(subset, identifier, global);
        String target = subset.get("TargetURI");
        if (target == null) {
            throw new MessageInvalidException(5, "TargetURI missing but UploadFrom=redirect", identifier, global);
        }
        try {
            this.targetURI = new FreenetURI(target);
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(8, "Invalid TargetURI: " + e, identifier, global);
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "targetURI = " + this.targetURI);
        }
    }

    public Bucket getData() {
        return null;
    }

    public ManifestElement getElement() {
        return new ManifestElement(this.name, this.targetURI, this.getMIMEType());
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.delete((Object)this);
    }
}

