/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.FailureCodeTracker;
import freenet.client.InsertException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Fields;
import freenet.support.SimpleFieldSet;
import java.net.MalformedURLException;

public class PutFailedMessage
extends FCPMessage {
    final int code;
    final String codeDescription;
    final String extraDescription;
    final String shortCodeDescription;
    final FailureCodeTracker tracker;
    final FreenetURI expectedURI;
    final String identifier;
    final boolean global;
    final boolean isFatal;

    public PutFailedMessage(InsertException e, String identifier, boolean global) {
        this.code = e.getMode();
        this.codeDescription = InsertException.getMessage(this.code);
        this.shortCodeDescription = InsertException.getShortMessage(this.code);
        this.extraDescription = e.extra;
        this.tracker = e.errorCodes;
        this.expectedURI = e.uri;
        this.identifier = identifier;
        this.global = global;
        this.isFatal = InsertException.isFatal(this.code);
    }

    public PutFailedMessage(SimpleFieldSet fs, boolean useVerboseFields) throws MalformedURLException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new NullPointerException();
        }
        this.global = fs.getBoolean("Global", false);
        this.code = Integer.parseInt(fs.get("Code"));
        if (useVerboseFields) {
            this.codeDescription = fs.get("CodeDescription");
            this.isFatal = Fields.stringToBool(fs.get("Fatal"), false);
            this.shortCodeDescription = fs.get("ShortCodeDescription");
        } else {
            this.codeDescription = InsertException.getMessage(this.code);
            this.isFatal = InsertException.isFatal(this.code);
            this.shortCodeDescription = InsertException.getShortMessage(this.code);
        }
        this.extraDescription = fs.get("ExtraDescription");
        String euri = fs.get("ExpectedURI");
        this.expectedURI = euri != null && euri.length() > 0 ? new FreenetURI(euri) : null;
        SimpleFieldSet trackerSubset = fs.subset("Errors");
        this.tracker = trackerSubset != null ? new FailureCodeTracker(true, trackerSubset) : null;
    }

    public SimpleFieldSet getFieldSet() {
        return this.getFieldSet(true);
    }

    public SimpleFieldSet getFieldSet(boolean verbose) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        if (this.global) {
            fs.putSingle("Global", "true");
        }
        fs.put("Code", this.code);
        if (verbose) {
            fs.putSingle("CodeDescription", this.codeDescription);
        }
        if (this.extraDescription != null) {
            fs.putSingle("ExtraDescription", this.extraDescription);
        }
        if (this.tracker != null) {
            fs.tput("Errors", this.tracker.toFieldSet(verbose));
        }
        if (verbose) {
            fs.put("Fatal", this.isFatal);
        }
        if (verbose) {
            fs.putSingle("ShortCodeDescription", this.shortCodeDescription);
        }
        if (this.expectedURI != null) {
            fs.putSingle("ExpectedURI", this.expectedURI.toString());
        }
        return fs;
    }

    public String getName() {
        return "PutFailed";
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PutFailed goes from server to client not the other way around", this.identifier, this.global);
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this, 5);
        if (this.tracker != null) {
            this.tracker.removeFrom(container);
        }
        if (this.expectedURI != null) {
            this.expectedURI.removeFrom(container);
        }
        container.delete((Object)this);
    }
}

