/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ProtocolErrorMessage
extends FCPMessage {
    static final int CLIENT_HELLO_MUST_BE_FIRST_MESSAGE = 1;
    static final int NO_LATE_CLIENT_HELLOS = 2;
    static final int MESSAGE_PARSE_ERROR = 3;
    static final int FREENET_URI_PARSE_ERROR = 4;
    static final int MISSING_FIELD = 5;
    static final int ERROR_PARSING_NUMBER = 6;
    public static final int INVALID_MESSAGE = 7;
    static final int INVALID_FIELD = 8;
    static final int FILE_NOT_FOUND = 9;
    static final int DISK_TARGET_EXISTS = 10;
    static final int FILENAME_AND_TEMP_FILENAME_MUST_BE_IN_SAME_DIR = 11;
    static final int COULD_NOT_CREATE_FILE = 12;
    static final int COULD_NOT_WRITE_FILE = 13;
    static final int COULD_NOT_RENAME_FILE = 14;
    static final int NO_SUCH_IDENTIFIER = 15;
    static final int NOT_SUPPORTED = 16;
    static final int INTERNAL_ERROR = 17;
    static final int SHUTTING_DOWN = 18;
    static final int NO_SUCH_NODE_IDENTIFIER = 19;
    static final int URL_PARSE_ERROR = 20;
    static final int REF_PARSE_ERROR = 21;
    static final int FILE_PARSE_ERROR = 22;
    static final int NOT_A_FILE_ERROR = 23;
    static final int ACCESS_DENIED = 24;
    static final int DIRECT_DISK_ACCESS_DENIED = 25;
    static final int COULD_NOT_READ_FILE = 26;
    static final int REF_SIGNATURE_INVALID = 27;
    static final int CANNOT_PEER_WITH_SELF = 28;
    static final int DUPLICATE_PEER_REF = 29;
    static final int OPENNET_DISABLED = 30;
    static final int DARKNET_ONLY = 31;
    static final int NO_SUCH_PLUGIN = 32;
    static final int PERSISTENCE_DISABLED = 33;
    final int code;
    final String extra;
    final boolean fatal;
    final String ident;
    final boolean global;

    private String codeDescription() {
        switch (this.code) {
            case 1: {
                return "ClientHello must be first message";
            }
            case 2: {
                return "No late ClientHello's accepted";
            }
            case 3: {
                return "Unknown message parsing error";
            }
            case 4: {
                return "Error parsing freenet URI";
            }
            case 5: {
                return "Missing field";
            }
            case 6: {
                return "Error parsing a numeric field";
            }
            case 7: {
                return "Don't know what to do with message";
            }
            case 8: {
                return "Invalid field value";
            }
            case 9: {
                return "File not found, not a file or not readable";
            }
            case 10: {
                return "Disk target exists, refusing to overwrite for security reasons";
            }
            case 11: {
                return "Filename and temp filename must be in same directory (so can rename)";
            }
            case 12: {
                return "Could not create file";
            }
            case 13: {
                return "Could not write file";
            }
            case 14: {
                return "Could not rename file";
            }
            case 15: {
                return "No such identifier";
            }
            case 16: {
                return "Not supported";
            }
            case 17: {
                return "Internal error";
            }
            case 18: {
                return "Shutting down";
            }
            case 19: {
                return "No such nodeIdentifier";
            }
            case 20: {
                return "Error parsing URL";
            }
            case 21: {
                return "Reference could not be parsed";
            }
            case 22: {
                return "File could not be read";
            }
            case 23: {
                return "Filepath is not a file";
            }
            case 24: {
                return "Access denied";
            }
            case 25: {
                return "Direct Disk Access operation denied: did you send a FileHash field ? Did you use TestDDA?";
            }
            case 26: {
                return "Could not read file";
            }
            case 27: {
                return "Reference signature failed to verify";
            }
            case 28: {
                return "Node cannot peer with itself";
            }
            case 29: {
                return "Node already has a peer with that ref";
            }
            case 30: {
                return "Opennet is currently disabled in the node's configuration";
            }
            case 31: {
                return "Operation only available on a darknet peer";
            }
            case 32: {
                return "No such plugin";
            }
        }
        Logger.error(this, "Unknown error code: " + this.code, new Exception("debug"));
        return "(Unknown)";
    }

    public ProtocolErrorMessage(int code, boolean fatal, String extra, String ident, boolean global) {
        this.code = code;
        this.extra = extra;
        this.fatal = fatal;
        this.ident = ident;
        this.global = global;
    }

    public ProtocolErrorMessage(SimpleFieldSet fs) {
        this.ident = fs.get("Identifier");
        this.code = Integer.parseInt(fs.get("Code"));
        this.extra = fs.get("ExtraDescription");
        this.fatal = Fields.stringToBool(fs.get("Fatal"), false);
        this.global = Fields.stringToBool(fs.get("Global"), false);
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        if (this.ident != null) {
            sfs.putSingle("Identifier", this.ident);
        }
        sfs.put("Code", this.code);
        sfs.putSingle("CodeDescription", this.codeDescription());
        if (this.extra != null) {
            sfs.putSingle("ExtraDescription", this.extra);
        }
        sfs.put("Fatal", this.fatal);
        if (this.global) {
            sfs.putSingle("Global", "true");
        }
        return sfs;
    }

    public void run(FCPConnectionHandler handler, Node node) {
        Logger.error(this, "Client reported protocol error");
    }

    public String getName() {
        return "ProtocolError";
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

