/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.SimpleFieldSet;

public class PluginInfoMessage
extends FCPMessage {
    static final String NAME = "PluginInfo";
    private final String identifier;
    private final boolean detailed;
    private final String classname;
    private final String originuri;
    private final long started;
    private final boolean isTalkable;

    PluginInfoMessage(PluginInfoWrapper pi, String identifier, boolean detail) {
        this.identifier = identifier;
        this.detailed = detail;
        this.classname = pi.getPluginClassName();
        this.originuri = pi.getFilename();
        this.started = pi.getStarted();
        this.isTalkable = pi.isFCPPlugin();
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        if (this.identifier != null) {
            sfs.putSingle("Identifier", this.identifier);
        }
        sfs.putSingle("PluginName", this.classname);
        sfs.put("IsTalkable", this.isTalkable);
        if (this.detailed) {
            sfs.putSingle("OriginUri", this.originuri);
            sfs.put("Started", this.started);
        }
        return sfs;
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PluginInfo goes from server to client not the other way around", null, false);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

