/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ManifestElement;
import freenet.client.async.SimpleManifestPutter;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.DelayedFreeBucket;
import freenet.support.io.FileBucket;
import freenet.support.io.NullBucket;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentPutDir
extends FCPMessage {
    static final String name = "PersistentPutDir";
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final short priorityClass;
    final short persistenceType;
    final boolean global;
    private final HashMap<String, Object> manifestElements;
    final String defaultName;
    final String token;
    final boolean started;
    final int maxRetries;
    final boolean wasDiskPut;
    private final SimpleFieldSet cached;

    public PersistentPutDir(String identifier, FreenetURI uri, int verbosity, short priorityClass, short persistenceType, boolean global, String defaultName, HashMap<String, Object> manifestElements, String token, boolean started, int maxRetries, boolean wasDiskPut, ObjectContainer container) {
        this.identifier = identifier;
        this.uri = uri;
        this.verbosity = verbosity;
        this.priorityClass = priorityClass;
        this.persistenceType = persistenceType;
        this.global = global;
        this.defaultName = defaultName;
        this.manifestElements = manifestElements;
        this.token = token;
        this.started = started;
        this.maxRetries = maxRetries;
        this.wasDiskPut = wasDiskPut;
        this.cached = this.generateFieldSet(container);
    }

    private SimpleFieldSet generateFieldSet(ObjectContainer container) {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.put("Verbosity", this.verbosity);
        fs.putSingle("Persistence", ClientRequest.persistenceTypeString(this.persistenceType));
        fs.put("PriorityClass", this.priorityClass);
        fs.putSingle("Global", Boolean.toString(this.global));
        fs.putSingle("PutDirType", this.wasDiskPut ? "disk" : "complex");
        SimpleFieldSet files = new SimpleFieldSet(false);
        ManifestElement[] elements = SimpleManifestPutter.flatten(this.manifestElements);
        fs.putSingle("DefaultName", this.defaultName);
        for (int i = 0; i < elements.length; ++i) {
            String num = Integer.toString(i);
            ManifestElement e = elements[i];
            String mimeOverride = e.getMimeTypeOverride();
            SimpleFieldSet subset = new SimpleFieldSet(false);
            FreenetURI tempURI = e.getTargetURI();
            subset.putSingle("Name", e.getName());
            if (tempURI != null) {
                subset.putSingle("UploadFrom", "redirect");
                subset.putSingle("TargetURI", tempURI.toString());
            } else {
                Bucket origData;
                Bucket data = origData = e.getData();
                boolean deactivate = false;
                if (this.persistenceType == 2) {
                    boolean bl = deactivate = !container.ext().isActive((Object)data);
                }
                if (deactivate) {
                    container.activate((Object)data, 1);
                }
                if (data instanceof DelayedFreeBucket) {
                    data = ((DelayedFreeBucket)data).getUnderlying();
                }
                subset.put("DataLength", e.getSize());
                if (mimeOverride != null) {
                    subset.putSingle("Metadata.ContentType", mimeOverride);
                }
                if (data == null) {
                    Logger.error(this, "Bucket already freed: " + e.getData() + " for " + e + " for " + e.getName() + " for " + this.identifier);
                } else if (data instanceof FileBucket) {
                    subset.putSingle("UploadFrom", "disk");
                    subset.putSingle("Filename", ((FileBucket)data).getFile().getPath());
                } else if (data instanceof PaddedEphemerallyEncryptedBucket || data instanceof NullBucket) {
                    subset.putSingle("UploadFrom", "direct");
                } else {
                    throw new IllegalStateException("Don't know what to do with bucket: " + data);
                }
                if (deactivate) {
                    container.deactivate((Object)origData, 1);
                }
            }
            files.put(num, subset);
        }
        files.put("Count", elements.length);
        fs.put("Files", files);
        if (this.token != null) {
            fs.putSingle("ClientToken", this.token);
        }
        fs.put("Started", this.started);
        fs.put("MaxRetries", this.maxRetries);
        return fs;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return this.cached;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PersistentPut goes from server to client not the other way around", this.identifier, this.global);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.activate((Object)this.cached, Integer.MAX_VALUE);
        this.cached.removeFrom(container);
        container.delete((Object)this);
    }
}

