/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.ClientPutMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import java.io.File;

public class PersistentPut
extends FCPMessage {
    static final String name = "PersistentPut";
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final short priorityClass;
    final short uploadFrom;
    final short persistenceType;
    final File origFilename;
    final String mimeType;
    final boolean global;
    final FreenetURI targetURI;
    final long size;
    final String token;
    final boolean started;
    final int maxRetries;
    final String targetFilename;
    final boolean binaryBlob;

    public PersistentPut(String identifier, FreenetURI uri, int verbosity, short priorityClass, short uploadFrom, FreenetURI targetURI, short persistenceType, File origFilename, String mimeType, boolean global, long size, String clientToken, boolean started, int maxRetries, String targetFilename, boolean binaryBlob) {
        this.identifier = identifier;
        this.uri = uri;
        this.verbosity = verbosity;
        this.priorityClass = priorityClass;
        this.uploadFrom = uploadFrom;
        this.targetURI = targetURI;
        this.persistenceType = persistenceType;
        this.origFilename = origFilename;
        this.mimeType = mimeType;
        this.global = global;
        this.size = size;
        this.token = clientToken;
        this.started = started;
        this.maxRetries = maxRetries;
        this.targetFilename = targetFilename;
        this.binaryBlob = binaryBlob;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.put("Verbosity", this.verbosity);
        fs.put("PriorityClass", this.priorityClass);
        fs.putSingle("UploadFrom", ClientPutMessage.uploadFromString(this.uploadFrom));
        fs.putSingle("Persistence", ClientRequest.persistenceTypeString(this.persistenceType));
        if (this.origFilename != null) {
            fs.putSingle("Filename", this.origFilename.getAbsolutePath());
        }
        if (this.targetURI != null) {
            fs.putSingle("TargetURI", this.targetURI.toString());
        }
        if (this.mimeType != null) {
            fs.putSingle("Metadata.ContentType", this.mimeType);
        }
        fs.put("Global", this.global);
        if (this.size != -1L) {
            fs.put("DataLength", this.size);
        }
        if (this.token != null) {
            fs.putSingle("ClientToken", this.token);
        }
        fs.put("Started", this.started);
        fs.put("MaxRetries", this.maxRetries);
        if (this.targetFilename != null) {
            fs.putSingle("TargetFilename", this.targetFilename);
        }
        if (this.binaryBlob) {
            fs.put("BinaryBlob", this.binaryBlob);
        }
        return fs;
    }

    public String getName() {
        return name;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PersistentPut goes from server to client not the other way around", this.identifier, this.global);
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.activate((Object)this.origFilename, 5);
        container.delete((Object)this.origFilename);
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.delete((Object)this);
    }
}

