/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import java.io.File;

public class PersistentGet
extends FCPMessage {
    static final String name = "PersistentGet";
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final short priorityClass;
    final short returnType;
    final short persistenceType;
    final File targetFile;
    final File tempFile;
    final String clientToken;
    final boolean global;
    final boolean started;
    final int maxRetries;
    final boolean binaryBlob;
    final long maxSize;

    public PersistentGet(String identifier, FreenetURI uri, int verbosity, short priorityClass, short returnType, short persistenceType, File targetFile, File tempFile, String clientToken, boolean global, boolean started, int maxRetries, boolean binaryBlob, long maxSize) {
        this.identifier = identifier;
        this.uri = uri;
        this.verbosity = verbosity;
        this.priorityClass = priorityClass;
        this.returnType = returnType;
        this.persistenceType = persistenceType;
        this.targetFile = targetFile;
        this.tempFile = tempFile;
        this.clientToken = clientToken;
        this.global = global;
        this.started = started;
        this.maxRetries = maxRetries;
        this.binaryBlob = binaryBlob;
        this.maxSize = maxSize;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.put("Verbosity", this.verbosity);
        fs.putSingle("ReturnType", ClientGetMessage.returnTypeString(this.returnType));
        fs.putSingle("Persistence", ClientRequest.persistenceTypeString(this.persistenceType));
        fs.putSingle("PersistenceType", ClientRequest.persistenceTypeString(this.persistenceType));
        if (this.returnType == 2) {
            fs.putSingle("Filename", this.targetFile.getAbsolutePath());
            fs.putSingle("TempFilename", this.tempFile.getAbsolutePath());
        }
        fs.put("PriorityClass", this.priorityClass);
        if (this.clientToken != null) {
            fs.putSingle("ClientToken", this.clientToken);
        }
        fs.put("Global", this.global);
        fs.put("Started", this.started);
        fs.put("MaxRetries", this.maxRetries);
        fs.put("BinaryBlob", this.binaryBlob);
        fs.put("MaxSize", this.maxSize);
        return fs;
    }

    public String getName() {
        return name;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PersistentGet goes from server to client not the other way around", this.identifier, this.global);
    }

    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.activate((Object)this.targetFile, 5);
        container.delete((Object)this.targetFile);
        container.activate((Object)this.tempFile, 5);
        container.delete((Object)this.tempFile);
        container.delete((Object)this);
    }
}

