/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class PeerMessage
extends FCPMessage {
    static final String name = "Peer";
    final PeerNode pn;
    final boolean withMetadata;
    final boolean withVolatile;
    final String identifier;

    public PeerMessage(PeerNode pn, boolean withMetadata, boolean withVolatile, String identifier) {
        this.pn = pn;
        this.withMetadata = withMetadata;
        this.withVolatile = withVolatile;
        this.identifier = identifier;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet vol;
        SimpleFieldSet meta;
        SimpleFieldSet fs = this.pn.exportFieldSet();
        if (this.withMetadata && !(meta = this.pn.exportMetadataFieldSet()).isEmpty()) {
            fs.put("metadata", meta);
        }
        if (this.withVolatile && !(vol = this.pn.exportVolatileFieldSet()).isEmpty()) {
            fs.put("volatile", vol);
        }
        if (this.identifier != null) {
            fs.putSingle("Identifier", this.identifier);
        }
        return fs;
    }

    public String getName() {
        return name;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "Peer goes from server to client not the other way around", null, false);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

