/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;

public class NodeHelloMessage
extends FCPMessage {
    public static final String NAME = "NodeHello";
    private final Node node;
    private final String id;

    public NodeHelloMessage(Node node, String id) {
        this.node = node;
        this.id = id;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("FCPVersion", "2.0");
        sfs.putSingle("Node", "Fred");
        sfs.putSingle("Version", Version.getVersionString());
        sfs.put("Build", Version.buildNumber());
        sfs.putSingle("Revision", "build01217");
        sfs.put("ExtBuild", NodeStarter.extBuildNumber);
        sfs.putSingle("ExtRevision", NodeStarter.extRevisionNumber);
        sfs.putSingle("Testnet", Boolean.toString(this.node == null ? false : this.node.isTestnetEnabled()));
        sfs.putSingle("CompressionCodecs", Integer.toString(Compressor.COMPRESSOR_TYPE.values().length));
        sfs.putSingle("ConnectionIdentifier", this.id);
        sfs.putSingle("NodeLanguage", L10n.getSelectedLanguage().toString());
        return sfs;
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "NodeHello goes from server to client not the other way around", null, false);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

