/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ModifyPersistentRequest
extends FCPMessage {
    static final String NAME = "ModifyPersistentRequest";
    final String identifier;
    final boolean global;
    final short priorityClass;
    final String clientToken;

    ModifyPersistentRequest(SimpleFieldSet fs) throws MessageInvalidException {
        block5: {
            this.global = Fields.stringToBool(fs.get("Global"), false);
            this.identifier = fs.get("Identifier");
            this.clientToken = fs.get("ClientToken");
            if (this.identifier == null) {
                throw new MessageInvalidException(5, "Missing field: Identifier", null, this.global);
            }
            String prio = fs.get("PriorityClass");
            if (prio != null) {
                try {
                    this.priorityClass = Short.parseShort(prio);
                    if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                        throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new MessageInvalidException(6, "Could not parse PriorityClass: " + e.getMessage(), this.identifier, this.global);
                }
            }
            this.priorityClass = (short)-1;
        }
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("Global", Boolean.toString(this.global));
        fs.putSingle("PriorityClass", Short.toString(this.priorityClass));
        if (this.clientToken != null) {
            fs.putSingle("ClientToken", this.clientToken);
        }
        return fs;
    }

    public String getName() {
        return NAME;
    }

    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        ClientRequest req = handler.getRebootRequest(this.global, handler, this.identifier);
        if (req == null) {
            try {
                node.clientCore.clientContext.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        ClientRequest req = handler.getForeverRequest(ModifyPersistentRequest.this.global, handler, ModifyPersistentRequest.this.identifier, container);
                        container.activate((Object)req, 1);
                        if (req == null) {
                            Logger.error(this, "Huh ? the request is null!");
                            ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, ModifyPersistentRequest.this.identifier, ModifyPersistentRequest.this.global);
                            handler.outputHandler.queue(msg);
                            return false;
                        }
                        req.modifyRequest(ModifyPersistentRequest.this.clientToken, ModifyPersistentRequest.this.priorityClass, handler.server, container);
                        container.deactivate((Object)req, 1);
                        return true;
                    }
                }, 5, false);
            }
            catch (DatabaseDisabledException e) {
                ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, this.identifier, this.global);
                handler.outputHandler.queue(msg);
            }
        } else {
            req.modifyRequest(this.clientToken, this.priorityClass, node.clientCore.getFCPServer(), null);
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

