/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.config.Option;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.node.Node;
import freenet.node.fcp.ConfigData;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ModifyConfig
extends FCPMessage {
    static final String NAME = "ModifyConfig";
    final SimpleFieldSet fs;
    final String identifier;

    public ModifyConfig(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ModifyConfig requires full access", this.identifier, false);
        }
        PersistentConfig config = node.config;
        SubConfig[] sc = config.getConfigs();
        boolean logMINOR = Logger.shouldLog(4, this);
        for (int i = 0; i < sc.length; ++i) {
            Option<?>[] o = sc[i].getOptions();
            String prefix = sc[i].getPrefix();
            for (int j = 0; j < o.length; ++j) {
                String configName = o[j].getName();
                if (logMINOR) {
                    Logger.minor(this, "Setting " + prefix + '.' + configName);
                }
                if (this.fs.get(prefix + '.' + configName) == null || o[j].getValueString().equals(this.fs.get(prefix + '.' + configName))) continue;
                if (logMINOR) {
                    Logger.minor(this, "Setting " + prefix + '.' + configName + " to " + this.fs.get(prefix + '.' + configName));
                }
                try {
                    o[j].setValue(this.fs.get(prefix + '.' + configName));
                    continue;
                }
                catch (Exception e) {
                    Logger.error(this, "Caught " + e, e);
                }
            }
        }
        node.clientCore.storeConfig();
        handler.outputHandler.queue(new ConfigData(node, true, false, false, false, false, false, false, false, this.identifier));
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

