/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Node;
import freenet.node.fcp.EndListPersistentRequestsMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class ListPersistentRequestsMessage
extends FCPMessage {
    static final String NAME = "ListPersistentRequests";

    public ListPersistentRequestsMessage(SimpleFieldSet fs) {
    }

    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    public String getName() {
        return NAME;
    }

    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        FCPClient rebootClient = handler.getRebootClient();
        rebootClient.queuePendingMessagesOnConnectionRestart(handler.outputHandler, null);
        rebootClient.queuePendingMessagesFromRunningRequests(handler.outputHandler, null);
        if (handler.getRebootClient().watchGlobal) {
            FCPClient globalRebootClient = handler.server.globalRebootClient;
            globalRebootClient.queuePendingMessagesOnConnectionRestart(handler.outputHandler, null);
            globalRebootClient.queuePendingMessagesFromRunningRequests(handler.outputHandler, null);
        }
        try {
            node.clientCore.clientContext.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    FCPClient foreverClient = handler.getForeverClient(container);
                    container.activate((Object)foreverClient, 1);
                    foreverClient.queuePendingMessagesOnConnectionRestart(handler.outputHandler, container);
                    foreverClient.queuePendingMessagesFromRunningRequests(handler.outputHandler, container);
                    if (handler.getRebootClient().watchGlobal) {
                        FCPClient globalForeverClient = handler.server.globalForeverClient;
                        globalForeverClient.queuePendingMessagesOnConnectionRestart(handler.outputHandler, container);
                        globalForeverClient.queuePendingMessagesFromRunningRequests(handler.outputHandler, container);
                    }
                    handler.outputHandler.queue(new EndListPersistentRequestsMessage());
                    container.deactivate((Object)foreverClient, 1);
                    return false;
                }
            }, 6, false);
        }
        catch (DatabaseDisabledException e) {
            handler.outputHandler.queue(new EndListPersistentRequestsMessage());
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

