/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.fcp.EndListPeerNotesMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.PeerNote;
import freenet.node.fcp.UnknownNodeIdentifierMessage;
import freenet.support.SimpleFieldSet;

public class ListPeerNotesMessage
extends FCPMessage {
    static final String NAME = "ListPeerNotes";
    final SimpleFieldSet fs;
    final String identifier;

    public ListPeerNotesMessage(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ListPeerNotes requires full access", this.identifier, false);
        }
        String nodeIdentifier = this.fs.get("NodeIdentifier");
        if (nodeIdentifier == null) {
            throw new MessageInvalidException(5, "Error: NodeIdentifier field missing", this.identifier, false);
        }
        PeerNode pn = node.getPeerNode(nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(nodeIdentifier, this.identifier);
            handler.outputHandler.queue(msg);
            return;
        }
        if (!(pn instanceof DarknetPeerNode)) {
            throw new MessageInvalidException(31, "ModifyPeer only available for darknet peers", this.identifier, false);
        }
        DarknetPeerNode dpn = (DarknetPeerNode)pn;
        String noteText = dpn.getPrivateDarknetCommentNote();
        handler.outputHandler.queue(new PeerNote(nodeIdentifier, noteText, 1, this.identifier));
        handler.outputHandler.queue(new EndListPeerNotesMessage(nodeIdentifier, this.identifier));
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

