/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.Node;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.support.Fields;
import freenet.support.SimpleFieldSet;

public class GetRequestStatusMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final boolean onlyData;
    static final String NAME = "GetRequestStatus";

    public GetRequestStatusMessage(SimpleFieldSet fs) {
        this.identifier = fs.get("Identifier");
        this.global = Fields.stringToBool(fs.get("Global"), false);
        this.onlyData = Fields.stringToBool(fs.get("OnlyData"), false);
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        return fs;
    }

    public String getName() {
        return NAME;
    }

    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        ClientRequest req = handler.getRebootRequest(this.global, handler, this.identifier);
        if (req == null && !node.clientCore.killedDatabase()) {
            try {
                node.clientCore.clientContext.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        ClientRequest req = handler.getForeverRequest(GetRequestStatusMessage.this.global, handler, GetRequestStatusMessage.this.identifier, container);
                        container.activate((Object)req, 1);
                        if (req == null) {
                            ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, GetRequestStatusMessage.this.identifier, GetRequestStatusMessage.this.global);
                            handler.outputHandler.queue(msg);
                        } else {
                            req.sendPendingMessages(handler.outputHandler, true, true, GetRequestStatusMessage.this.onlyData, container);
                        }
                        container.deactivate((Object)req, 1);
                        return false;
                    }
                }, 5, false);
            }
            catch (DatabaseDisabledException e) {
                ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, this.identifier, this.global);
                handler.outputHandler.queue(msg);
            }
        } else {
            req.sendPendingMessages(handler.outputHandler, true, true, this.onlyData, null);
        }
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

