/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.FailureCodeTracker;
import freenet.client.FetchException;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.net.MalformedURLException;

public class GetFailedMessage
extends FCPMessage {
    final int code;
    final String codeDescription;
    final String shortCodeDescription;
    final String extraDescription;
    final FailureCodeTracker tracker;
    final boolean isFatal;
    final String identifier;
    final boolean global;
    final long expectedDataLength;
    final String expectedMimeType;
    final boolean finalizedExpected;
    final FreenetURI redirectURI;

    public GetFailedMessage(FetchException e, String identifier, boolean global) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Creating get failed from " + e + " for " + identifier, (Throwable)e);
        }
        this.tracker = e.errorCodes;
        this.code = e.mode;
        this.codeDescription = FetchException.getMessage(this.code);
        this.extraDescription = e.extraMessage;
        this.shortCodeDescription = FetchException.getShortMessage(this.code);
        this.isFatal = e.isFatal();
        this.identifier = identifier;
        this.global = global;
        this.expectedDataLength = e.expectedSize;
        this.expectedMimeType = e.getExpectedMimeType();
        this.finalizedExpected = e.finalizedSize();
        this.redirectURI = e.newURI;
    }

    public GetFailedMessage(SimpleFieldSet fs, boolean useVerboseFields) throws MalformedURLException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new NullPointerException();
        }
        this.code = Integer.parseInt(fs.get("Code"));
        if (useVerboseFields) {
            this.codeDescription = fs.get("CodeDescription");
            this.isFatal = Fields.stringToBool(fs.get("Fatal"), false);
            this.shortCodeDescription = fs.get("ShortCodeDescription");
        } else {
            this.codeDescription = FetchException.getMessage(this.code);
            this.isFatal = FetchException.isFatal(this.code);
            this.shortCodeDescription = FetchException.getShortMessage(this.code);
        }
        this.extraDescription = fs.get("ExtraDescription");
        SimpleFieldSet trackerSubset = fs.subset("Errors");
        this.tracker = trackerSubset != null ? new FailureCodeTracker(true, trackerSubset) : null;
        this.expectedMimeType = fs.get("ExpectedMimeType");
        this.finalizedExpected = Fields.stringToBool(fs.get("FinalizedExpected"), false);
        String s = fs.get("ExpectedDataLength");
        this.expectedDataLength = s != null ? Long.parseLong(s) : -1L;
        s = fs.get("RedirectURI");
        this.redirectURI = s != null ? new FreenetURI(s) : null;
        this.global = Fields.stringToBool(fs.get("Global"), false);
    }

    public SimpleFieldSet getFieldSet() {
        return this.getFieldSet(true);
    }

    public SimpleFieldSet getFieldSet(boolean verbose) {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("Code", Integer.toString(this.code));
        if (verbose) {
            sfs.putSingle("CodeDescription", this.codeDescription);
        }
        if (this.extraDescription != null) {
            sfs.putSingle("ExtraDescription", this.extraDescription);
        }
        if (verbose) {
            sfs.putSingle("Fatal", Boolean.toString(this.isFatal));
        }
        if (this.tracker != null) {
            sfs.tput("Errors", this.tracker.toFieldSet(verbose));
        }
        if (verbose) {
            sfs.putSingle("ShortCodeDescription", this.shortCodeDescription);
        }
        sfs.putSingle("Identifier", this.identifier);
        if (this.expectedDataLength > -1L) {
            sfs.putSingle("ExpectedDataLength", Long.toString(this.expectedDataLength));
        }
        if (this.expectedMimeType != null) {
            sfs.putSingle("ExpectedMetadata.ContentType", this.expectedMimeType);
        }
        if (this.finalizedExpected) {
            sfs.putSingle("FinalizedExpected", "true");
        }
        if (this.redirectURI != null) {
            sfs.putSingle("RedirectURI", this.redirectURI.toString(false, false));
        }
        return sfs;
    }

    public String getName() {
        return "GetFailed";
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "GetFailed goes from server to client not the other way around", this.identifier, this.global);
    }

    public void removeFrom(ObjectContainer container) {
        if (this.redirectURI != null) {
            container.activate((Object)this.redirectURI, 5);
            this.redirectURI.removeFrom(container);
        }
        if (this.tracker != null) {
            container.activate((Object)this.tracker, 5);
            this.tracker.removeFrom(container);
        }
        container.delete((Object)this);
    }
}

