/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.events.FinishedCompressionEvent;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class FinishedCompressionMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final int codec;
    final long origSize;
    final long compressedSize;

    public FinishedCompressionMessage(String identifier, boolean global, FinishedCompressionEvent event) {
        this.identifier = identifier;
        this.codec = event.codec;
        this.compressedSize = event.compressedSize;
        this.origSize = event.originalSize;
        this.global = global;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("Codec", Integer.toString(this.codec));
        fs.putSingle("OriginalSize", Long.toString(this.origSize));
        fs.putSingle("CompressedSize", Long.toString(this.compressedSize));
        if (this.global) {
            fs.putSingle("Global", "true");
        }
        return fs;
    }

    public String getName() {
        return "FinishedCompression";
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "FinishedCompression goes from server to client not the other way around", this.identifier, this.global);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

