/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchContext;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertContext;
import freenet.client.TempFetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.SSL;
import freenet.io.AllowedHosts;
import freenet.io.NetworkInterface;
import freenet.io.SSLNetworkInterface;
import freenet.keys.FreenetURI;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.CloseConnectionDuplicateClientNameMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPPersistentRoot;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.RequestCompletionCallback;
import freenet.support.Base64;
import freenet.support.Logger;
import freenet.support.MutableBoolean;
import freenet.support.OOMHandler;
import freenet.support.api.BooleanCallback;
import freenet.support.api.Bucket;
import freenet.support.api.IntCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import org.tanukisoftware.wrapper.WrapperManager;

public class FCPServer
implements Runnable {
    FCPPersistentRoot persistentRoot;
    private static boolean logMINOR;
    public static final int DEFAULT_FCP_PORT = 9481;
    NetworkInterface networkInterface;
    final NodeClientCore core;
    final Node node;
    final int port;
    private static boolean ssl;
    public final boolean enabled;
    String bindTo;
    private String allowedHosts;
    AllowedHosts allowedHostsFullAccess;
    final WeakHashMap<String, FCPClient> rebootClientsByName;
    final FCPClient globalRebootClient;
    FCPClient globalForeverClient;
    private boolean enablePersistentDownloads;
    private File persistentDownloadsFile;
    private File persistentDownloadsTempFile;
    private final Object persistenceSync = new Object();
    final FetchContext defaultFetchContext;
    public InsertContext defaultInsertContext;
    public static final int QUEUE_MAX_RETRIES = -1;
    public static final long QUEUE_MAX_DATA_SIZE = Long.MAX_VALUE;
    private boolean assumeDownloadDDAIsAllowed;
    private boolean assumeUploadDDAIsAllowed;
    private boolean hasFinishedStart;

    public FCPServer(String ipToBindTo, String allowedHosts, String allowedHostsFullAccess, int port, Node node, NodeClientCore core, boolean persistentDownloadsEnabled, String persistentDownloadsDir, boolean isEnabled, boolean assumeDDADownloadAllowed, boolean assumeDDAUploadAllowed, ObjectContainer container) throws IOException, InvalidConfigValueException {
        this.bindTo = ipToBindTo;
        this.allowedHosts = allowedHosts;
        this.allowedHostsFullAccess = new AllowedHosts(allowedHostsFullAccess);
        this.port = port;
        this.enabled = isEnabled;
        this.enablePersistentDownloads = persistentDownloadsEnabled;
        this.setPersistentDownloadsFile(new File(persistentDownloadsDir));
        this.node = node;
        this.core = core;
        this.assumeDownloadDDAIsAllowed = assumeDDADownloadAllowed;
        this.assumeUploadDDAIsAllowed = assumeDDAUploadAllowed;
        this.rebootClientsByName = new WeakHashMap();
        HighLevelSimpleClient client = core.makeClient((short)0);
        this.defaultFetchContext = client.getFetchContext();
        this.defaultInsertContext = client.getInsertContext(false);
        this.globalRebootClient = new FCPClient("Global Queue", null, true, null, 1, null, null);
        logMINOR = Logger.shouldLog(4, this);
    }

    public void load(ObjectContainer container) {
        this.persistentRoot = FCPPersistentRoot.create(this.node.nodeDBHandle, container);
        this.globalForeverClient = this.persistentRoot.globalForeverClient;
        if (this.enabled && this.enablePersistentDownloads) {
            Logger.error(this, "Persistent downloads enabled: attempting to migrate old persistent downloads to database...");
            Logger.error(this, "Note that we will not write to downloads.dat.gz, we will read from it and rename it if migration is successful.");
            this.loadPersistentRequests(container);
        } else {
            Logger.error(this, "Not loading persistent requests: enabled=" + this.enabled + " enable persistent downloads=" + this.enablePersistentDownloads);
        }
    }

    private void maybeGetNetworkInterface() {
        if (this.networkInterface != null) {
            return;
        }
        NetworkInterface tempNetworkInterface = null;
        try {
            tempNetworkInterface = ssl ? SSLNetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.node.executor, true) : NetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.node.executor, true);
        }
        catch (IOException be) {
            Logger.error(this, "Couldn't bind to FCP Port " + this.bindTo + ':' + this.port + ". FCP Server not started.", be);
            System.out.println("Couldn't bind to FCP Port " + this.bindTo + ':' + this.port + ". FCP Server not started.");
        }
        this.networkInterface = tempNetworkInterface;
    }

    public void maybeStart() {
        if (this.enabled) {
            this.maybeGetNetworkInterface();
            Logger.normal(this, "Starting FCP server on " + this.bindTo + ':' + this.port + '.');
            System.out.println("Starting FCP server on " + this.bindTo + ':' + this.port + '.');
            if (this.networkInterface != null) {
                Thread t = new Thread((Runnable)this, "FCP server");
                t.setDaemon(true);
                t.start();
            }
        } else {
            Logger.normal(this, "Not starting FCP server as it's disabled");
            System.out.println("Not starting FCP server as it's disabled");
            this.networkInterface = null;
        }
    }

    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                this.realRun();
            }
            catch (IOException e) {
                if (logMINOR) {
                    Logger.minor(this, "Caught " + e, (Throwable)e);
                }
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
            }
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void realRun() throws IOException {
        if (!this.node.isHasStarted()) {
            return;
        }
        Socket s = this.networkInterface.accept();
        FCPConnectionHandler ch = new FCPConnectionHandler(s, this);
        ch.start();
    }

    public static FCPServer maybeCreate(Node node, NodeClientCore core, Config config, ObjectContainer container) throws IOException, InvalidConfigValueException {
        FCPServer fcp;
        boolean persistentDownloadsEnabled;
        int sortOrder;
        SubConfig fcpConfig = new SubConfig("fcp", config);
        int n = sortOrder = 0;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("enabled", true, n, true, false, "FcpServer.isEnabled", "FcpServer.isEnabledLong", new FCPEnabledCallback(core));
        int n2 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("ssl", false, n2, true, true, "FcpServer.ssl", "FcpServer.sslLong", new FCPSSLCallback());
        fcpConfig.register("port", 9481, 2, true, true, "FcpServer.portNumber", "FcpServer.portNumberLong", (IntCallback)new FCPPortNumberCallback(core), false);
        int n3 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("bindTo", "127.0.0.1,0:0:0:0:0:0:0:1", n3, true, true, "FcpServer.bindTo", "FcpServer.bindToLong", new FCPBindtoCallback(core));
        int n4 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("allowedHosts", "127.0.0.1,0:0:0:0:0:0:0:1", n4, true, true, "FcpServer.allowedHosts", "FcpServer.allowedHostsLong", new FCPAllowedHostsCallback(core));
        int n5 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("allowedHostsFullAccess", "127.0.0.1,0:0:0:0:0:0:0:1", n5, true, true, "FcpServer.allowedHostsFullAccess", "FcpServer.allowedHostsFullAccessLong", new FCPAllowedHostsFullAccessCallback(core));
        PersistentDownloadsEnabledCallback enabledCB = new PersistentDownloadsEnabledCallback();
        int n6 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        fcpConfig.register("persistentDownloadsEnabled", true, n6, true, true, "FcpServer.enablePersistentDownload", "FcpServer.enablePersistentDownloadLong", enabledCB);
        int n7 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        PersistentDownloadsFileCallback cb2 = new PersistentDownloadsFileCallback();
        fcpConfig.register("persistentDownloadsFile", "downloads.dat", n7, true, false, "FcpServer.filenameToStorePData", "FcpServer.filenameToStorePDataLong", cb2);
        String persistentDownloadsDir = fcpConfig.getString("persistentDownloadsFile");
        enabledCB.enabled = persistentDownloadsEnabled = fcpConfig.getBoolean("persistentDownloadsEnabled");
        int n8 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        AssumeDDADownloadIsAllowedCallback cb4 = new AssumeDDADownloadIsAllowedCallback();
        fcpConfig.register("assumeDownloadDDAIsAllowed", false, n8, true, false, "FcpServer.assumeDownloadDDAIsAllowed", "FcpServer.assumeDownloadDDAIsAllowedLong", cb4);
        int n9 = sortOrder;
        sortOrder = (short)(sortOrder + 1);
        AssumeDDAUploadIsAllowedCallback cb5 = new AssumeDDAUploadIsAllowedCallback();
        fcpConfig.register("assumeUploadDDAIsAllowed", false, n9, true, false, "FcpServer.assumeUploadDDAIsAllowed", "FcpServer.assumeUploadDDAIsAllowedLong", cb5);
        if (SSL.available()) {
            ssl = fcpConfig.getBoolean("ssl");
        }
        if ((fcp = new FCPServer(fcpConfig.getString("bindTo"), fcpConfig.getString("allowedHosts"), fcpConfig.getString("allowedHostsFullAccess"), fcpConfig.getInt("port"), node, core, persistentDownloadsEnabled, persistentDownloadsDir, fcpConfig.getBoolean("enabled"), fcpConfig.getBoolean("assumeDownloadDDAIsAllowed"), fcpConfig.getBoolean("assumeUploadDDAIsAllowed"), container)) != null) {
            cb2.server = fcp;
            cb4.server = fcp;
            cb5.server = fcp;
        }
        fcpConfig.finishedInitialization();
        return fcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentDownloadsFile(File f) throws InvalidConfigValueException {
        Object object = this.persistenceSync;
        synchronized (object) {
            this.checkFile(f);
            File temp = new File(f.getPath() + ".tmp");
            this.checkFile(temp);
            this.persistentDownloadsFile = f;
            this.persistentDownloadsTempFile = temp;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFile(File f) throws InvalidConfigValueException {
        File parent;
        if (f.isDirectory()) {
            throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileIsDirectory"));
        }
        if (f.isFile()) {
            if (!f.canRead()) throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileUnreadable"));
            if (!f.canWrite()) {
                throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileUnreadable"));
            }
        }
        if ((parent = f.getParentFile()) != null && !parent.exists()) {
            throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileParentDoesNotExist"));
        }
        if (f.exists()) return;
        try {
            try {
                if (!f.createNewFile()) {
                    if (!f.exists()) throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileDoesNotExistCannotCreate"));
                    if (!f.canRead()) throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileExistsCannotReadOrWrite"));
                    if (!f.canWrite()) {
                        throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileExistsCannotReadOrWrite"));
                    }
                } else {
                    if (!f.canRead()) throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileCanCreateCannotReadOrWrite"));
                    if (!f.canWrite()) {
                        throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileCanCreateCannotReadOrWrite"));
                    }
                }
                Object var5_3 = null;
                f.delete();
                return;
            }
            catch (IOException e) {
                throw new InvalidConfigValueException(FCPServer.l10n("downloadsFileDoesNotExistCannotCreate") + " : " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            f.delete();
            throw throwable;
        }
    }

    private static String l10n(String key) {
        return L10n.getString("FcpServer." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return L10n.getString("FcpServer." + key, pattern, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCPClient registerRebootClient(String name, NodeClientCore core, FCPConnectionHandler handler) {
        FCPServer fCPServer = this;
        synchronized (fCPServer) {
            FCPClient oldClient = this.rebootClientsByName.get(name);
            if (oldClient == null) {
                FCPClient client = new FCPClient(name, handler, false, null, 1, null, null);
                this.rebootClientsByName.put(name, client);
                return client;
            }
            FCPConnectionHandler oldConn = oldClient.getConnection();
            if (oldConn == null) {
                oldClient.setConnection(handler);
                return oldClient;
            }
            oldConn.setKilledDupe();
            oldConn.outputHandler.queue(new CloseConnectionDuplicateClientNameMessage());
            oldConn.close();
            oldClient.setConnection(handler);
            return oldClient;
        }
    }

    public FCPClient registerForeverClient(String name, NodeClientCore core, FCPConnectionHandler handler, ObjectContainer container) {
        return this.persistentRoot.registerForeverClient(name, core, handler, this, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClient(FCPClient client, ObjectContainer container) {
        if (client.persistenceType == 1) {
            assert (container == null);
            FCPServer fCPServer = this;
            synchronized (fCPServer) {
                String name = client.name;
                this.rebootClientsByName.remove(name);
            }
        } else {
            this.persistentRoot.maybeUnregisterClient(client, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPersistentRequests(ObjectContainer container) {
        Logger.normal(this, "Loading persistent requests...");
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        GZIPInputStream gis = null;
        try {
            try {
                File file = new File(this.persistentDownloadsFile + ".gz");
                fis = new FileInputStream(file);
                gis = new GZIPInputStream(fis);
                bis = new BufferedInputStream(gis);
                Logger.normal(this, "Loading persistent requests from " + file);
                if (file.length() <= 0L) throw new IOException("File empty");
                this.loadPersistentRequests(bis, container);
                Object var9_7 = null;
            }
            catch (IOException e) {
                Logger.normal(this, "IOE : " + e.getMessage(), e);
                File file = new File(this.persistentDownloadsTempFile + ".gz");
                Logger.normal(this, "Let's try to load " + file + " then.");
                Closer.close(bis);
                Closer.close(gis);
                Closer.close(fis);
                try {
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    this.loadPersistentRequests(bis, container);
                }
                catch (IOException e1) {
                    Logger.normal(this, "It's corrupted too : Not reading any persistent requests from disk: " + e1);
                    Object var9_8 = null;
                    Closer.close(bis);
                    Closer.close(gis);
                    Closer.close(fis);
                    return;
                }
                Object var9_9 = null;
                Closer.close(bis);
                Closer.close(gis);
                Closer.close(fis);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Closer.close(bis);
            Closer.close(gis);
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(bis);
        Closer.close(gis);
        Closer.close(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPersistentRequests(InputStream is, ObjectContainer container) throws IOException {
        Object object = this.persistenceSync;
        synchronized (object) {
            InputStreamReader ris = new InputStreamReader(is, "UTF-8");
            BufferedReader br = new BufferedReader(ris);
            try {
                int count;
                String r = br.readLine();
                try {
                    count = Integer.parseInt(r);
                }
                catch (NumberFormatException e) {
                    Logger.error(this, "Corrupt persistent downloads file: cannot parse " + r + " as integer");
                    throw new IOException(e.toString());
                }
                for (int i = 0; i < count; ++i) {
                    WrapperManager.signalStarting((int)1200000);
                    System.out.println("Loading persistent request " + (i + 1) + " of " + count + "...");
                    ClientRequest.readAndRegister(br, this, container, this.core.clientContext);
                }
                Logger.normal(this, "Loaded " + count + " persistent requests");
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                Closer.close(br);
                Closer.close(ris);
                throw throwable;
            }
            Closer.close(br);
            Closer.close(ris);
        }
    }

    public ClientRequest[] getGlobalRequests(ObjectContainer container) throws DatabaseDisabledException {
        if (this.core.killedDatabase()) {
            throw new DatabaseDisabledException();
        }
        ArrayList<ClientRequest> v = new ArrayList<ClientRequest>();
        this.globalRebootClient.addPersistentRequests(v, false, null);
        if (!container.ext().isActive((Object)this.globalForeverClient)) {
            Logger.error(this, "Somebody deactivated the global queue!");
            container.activate((Object)this.globalForeverClient, 2);
        }
        this.globalForeverClient.addPersistentRequests(v, false, container);
        return v.toArray(new ClientRequest[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGlobalRequestBlocking(final String identifier) throws MessageInvalidException, DatabaseDisabledException {
        if (!this.globalRebootClient.removeByIdentifier(identifier, true, this, null, this.core.clientContext)) {
            final Object sync = new Object();
            final MutableBoolean done = new MutableBoolean();
            final MutableBoolean success = new MutableBoolean();
            done.value = false;
            this.core.clientContext.jobRunner.queue(new DBJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean run(ObjectContainer container, ClientContext context) {
                    Object object;
                    boolean succeeded = false;
                    try {
                        try {
                            succeeded = FCPServer.this.globalForeverClient.removeByIdentifier(identifier, true, FCPServer.this, container, FCPServer.this.core.clientContext);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught removing identifier " + identifier + ": " + t, t);
                            Object var6_5 = null;
                            Object object3 = sync;
                            synchronized (object3) {
                                success.value = succeeded;
                                done.value = true;
                                sync.notifyAll();
                                return true;
                            }
                        }
                        Object var6_4 = null;
                        object = sync;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        Object object2 = sync;
                        synchronized (object2) {
                            success.value = succeeded;
                            done.value = true;
                            sync.notifyAll();
                            throw throwable;
                        }
                    }
                    synchronized (object) {
                        success.value = succeeded;
                        done.value = true;
                        sync.notifyAll();
                        return true;
                    }
                }
            }, 7, false);
            Object object = sync;
            synchronized (object) {
                while (!done.value) {
                    try {
                        sync.wait();
                    }
                    catch (InterruptedException e) {}
                }
                return success.value;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllGlobalRequestsBlocking() throws DatabaseDisabledException {
        this.globalRebootClient.removeAll(null, this.core.clientContext);
        final Object sync = new Object();
        final MutableBoolean done = new MutableBoolean();
        final MutableBoolean success = new MutableBoolean();
        done.value = false;
        this.core.clientContext.jobRunner.queue(new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                Object object;
                boolean succeeded = false;
                try {
                    try {
                        FCPServer.this.globalForeverClient.removeAll(container, FCPServer.this.core.clientContext);
                        succeeded = true;
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught while processing panic: " + t, t);
                        System.err.println("PANIC INCOMPLETE: CAUGHT " + t);
                        t.printStackTrace();
                        System.err.println("Your requests have not been deleted!");
                        Object var6_5 = null;
                        Object object3 = sync;
                        synchronized (object3) {
                            success.value = succeeded;
                            done.value = true;
                            sync.notifyAll();
                            return true;
                        }
                    }
                    Object var6_4 = null;
                    object = sync;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    Object object2 = sync;
                    synchronized (object2) {
                        success.value = succeeded;
                        done.value = true;
                        sync.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (object) {
                    success.value = succeeded;
                    done.value = true;
                    sync.notifyAll();
                    return true;
                }
            }
        }, 7, false);
        Object object = sync;
        synchronized (object) {
            while (!done.value) {
                try {
                    sync.wait();
                }
                catch (InterruptedException e) {}
            }
            return success.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentGlobalRequestBlocking(final FreenetURI fetchURI, final String expectedMimeType, final String persistenceTypeString, final String returnTypeString) throws NotAllowedException, IOException, DatabaseDisabledException {
        class OutputWrapper {
            NotAllowedException ne;
            IOException ioe;
            boolean done;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                OutputWrapper outputWrapper;
                boolean bl;
                NotAllowedException ne = null;
                IOException ioe = null;
                try {
                    try {
                        FCPServer.this.makePersistentGlobalRequest(fetchURI, expectedMimeType, persistenceTypeString, returnTypeString, container);
                        bl = true;
                        Object var8_9 = null;
                        outputWrapper = ow;
                    }
                    catch (NotAllowedException e) {
                        ne = e;
                        boolean bl2 = false;
                        Object var8_10 = null;
                        OutputWrapper outputWrapper2 = ow;
                        synchronized (outputWrapper2) {
                            ow.ne = ne;
                            ow.ioe = ioe;
                            ow.done = true;
                            ow.notifyAll();
                            return bl2;
                        }
                    }
                    catch (IOException e) {
                        ioe = e;
                        boolean bl3 = false;
                        Object var8_11 = null;
                        OutputWrapper outputWrapper3 = ow;
                        synchronized (outputWrapper3) {
                            ow.ne = ne;
                            ow.ioe = ioe;
                            ow.done = true;
                            ow.notifyAll();
                            return bl3;
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Failed to make persistent request: " + t, t);
                        boolean bl4 = false;
                        Object var8_12 = null;
                        OutputWrapper outputWrapper4 = ow;
                        synchronized (outputWrapper4) {
                            ow.ne = ne;
                            ow.ioe = ioe;
                            ow.done = true;
                            ow.notifyAll();
                            return bl4;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    OutputWrapper outputWrapper5 = ow;
                    synchronized (outputWrapper5) {
                        ow.ne = ne;
                        ow.ioe = ioe;
                        ow.done = true;
                        ow.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (outputWrapper) {
                    ow.ne = ne;
                    ow.ioe = ioe;
                    ow.done = true;
                    ow.notifyAll();
                    return bl;
                }
            }
        }, 7, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (!ow.done) {
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
            if (ow.ioe != null) {
                throw ow.ioe;
            }
            if (ow.ne != null) {
                throw ow.ne;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyGlobalRequestBlocking(final String identifier, final String newToken, final short newPriority) throws DatabaseDisabledException {
        ClientRequest req = this.globalRebootClient.getRequest(identifier, null);
        if (req != null) {
            req.modifyRequest(newToken, newPriority, this, null);
            return true;
        }
        class OutputWrapper {
            boolean success;
            boolean done;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                OutputWrapper outputWrapper;
                boolean success = false;
                try {
                    ClientRequest req = FCPServer.this.globalForeverClient.getRequest(identifier, container);
                    container.activate((Object)req, 1);
                    if (req != null) {
                        req.modifyRequest(newToken, newPriority, FCPServer.this, container);
                    }
                    container.deactivate((Object)req, 1);
                    success = true;
                    Object var6_5 = null;
                    outputWrapper = ow;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OutputWrapper outputWrapper2 = ow;
                    synchronized (outputWrapper2) {
                        ow.success = success;
                        ow.done = true;
                        ow.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (outputWrapper) {
                    ow.success = success;
                    ow.done = true;
                    ow.notifyAll();
                }
                return true;
            }
        }, 7, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (!ow.done) {
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
            return ow.success;
        }
    }

    public void makePersistentGlobalRequest(FreenetURI fetchURI, String expectedMimeType, String persistenceTypeString, String returnTypeString, ObjectContainer container) throws NotAllowedException, IOException {
        boolean persistence = persistenceTypeString.equalsIgnoreCase("reboot");
        short returnType = ClientGetMessage.parseReturnType(returnTypeString);
        File returnFilename = null;
        File returnTempFilename = null;
        if (returnType == 2) {
            returnFilename = this.makeReturnFilename(fetchURI, expectedMimeType);
            returnTempFilename = this.makeTempReturnFilename(returnFilename);
        }
        try {
            this.innerMakePersistentGlobalRequest(fetchURI, persistence, returnType, "FProxy:" + fetchURI.getPreferredFilename(), returnFilename, returnTempFilename, container);
            return;
        }
        catch (IdentifierCollisionException ee) {
            try {
                this.innerMakePersistentGlobalRequest(fetchURI, persistence, returnType, "FProxy:" + fetchURI.getDocName(), returnFilename, returnTempFilename, container);
                return;
            }
            catch (IdentifierCollisionException e) {
                try {
                    this.innerMakePersistentGlobalRequest(fetchURI, persistence, returnType, "FProxy:" + fetchURI.toString(false, false), returnFilename, returnTempFilename, container);
                    return;
                }
                catch (IdentifierCollisionException e1) {
                    try {
                        this.innerMakePersistentGlobalRequest(fetchURI, persistence, returnType, "FProxy (" + System.currentTimeMillis() + ')', returnFilename, returnTempFilename, container);
                        return;
                    }
                    catch (IdentifierCollisionException e2) {
                        while (true) {
                            byte[] buf = new byte[8];
                            try {
                                this.core.random.nextBytes(buf);
                                String id = "FProxy:" + Base64.encode(buf);
                                this.innerMakePersistentGlobalRequest(fetchURI, persistence, returnType, id, returnFilename, returnTempFilename, container);
                                return;
                            }
                            catch (IdentifierCollisionException e3) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    private File makeTempReturnFilename(File returnFilename) {
        return new File(returnFilename.toString() + ".freenet-tmp");
    }

    private File makeReturnFilename(FreenetURI uri, String expectedMimeType) {
        String preferred;
        String ext = expectedMimeType != null && expectedMimeType.length() > 0 && !expectedMimeType.equals("application/octet-stream") ? DefaultMIMETypes.getExtension(expectedMimeType) : null;
        String extAdd = ext == null ? "" : '.' + ext;
        String preferredWithExt = preferred = uri.getPreferredFilename();
        if (ext == null || !preferredWithExt.endsWith(ext)) {
            preferredWithExt = preferredWithExt + extAdd;
        }
        File f = new File(this.core.getDownloadDir(), preferredWithExt);
        File f1 = new File(this.core.getDownloadDir(), preferredWithExt + ".freenet-tmp");
        int x = 0;
        StringBuilder sb = new StringBuilder();
        while (f.exists() || f1.exists()) {
            sb.append(preferred);
            sb.append('-');
            sb.append(x);
            sb.append(extAdd);
            f = new File(this.core.getDownloadDir(), sb.toString());
            f1 = new File(this.core.getDownloadDir(), sb.append(".freenet-tmp").toString());
            ++x;
            sb.setLength(0);
        }
        return f;
    }

    private void innerMakePersistentGlobalRequest(FreenetURI fetchURI, boolean persistRebootOnly, short returnType, String id, File returnFilename, File returnTempFilename, ObjectContainer container) throws IdentifierCollisionException, NotAllowedException, IOException {
        ClientGet cg = new ClientGet(persistRebootOnly ? this.globalRebootClient : this.globalForeverClient, fetchURI, this.defaultFetchContext.localRequestOnly, this.defaultFetchContext.ignoreStore, -1, -1, Long.MAX_VALUE, returnType, persistRebootOnly, id, Integer.MAX_VALUE, 4, returnFilename, returnTempFilename, this, container);
        cg.register(container, false, false);
        cg.start(container, this.core.clientContext);
    }

    public void finishStart() {
        if (this.enablePersistentDownloads) {
            File target;
            boolean movedMain = false;
            if (logMINOR) {
                Logger.minor(this, "Persistent downloads file should be " + this.persistentDownloadsFile);
                Logger.minor(this, "Persistent downloads temp file should be " + this.persistentDownloadsTempFile);
            }
            File from = new File(this.persistentDownloadsFile.getPath() + ".gz");
            File fromTemp = new File(this.persistentDownloadsTempFile.getPath() + ".gz");
            if (from.exists()) {
                target = new File(from.getPath() + ".old.pre-db4o");
                if (logMINOR) {
                    Logger.minor(this, "Trying to move " + this.persistentDownloadsFile + " to " + target);
                }
                if (from.renameTo(target)) {
                    Logger.error(this, "Successfully migrated persistent downloads and renamed " + from.getName() + " to " + target.getName());
                    movedMain = true;
                }
            }
            if (fromTemp.exists()) {
                target = new File(fromTemp.getPath() + ".old.pre-db4o");
                if (logMINOR) {
                    Logger.minor(this, "Trying to move " + fromTemp + " to " + target);
                }
                if (fromTemp.renameTo(target) && !movedMain) {
                    Logger.error(this, "Successfully migrated persistent downloads and renamed " + fromTemp.getName() + " to " + target.getName());
                }
            }
        }
        this.hasFinishedStart = true;
    }

    public FCPClient getGlobalForeverClient() {
        return this.globalForeverClient;
    }

    public ClientRequest getGlobalRequest(String identifier, ObjectContainer container) {
        ClientRequest req = this.globalRebootClient.getRequest(identifier, null);
        if (req == null) {
            req = this.globalForeverClient.getRequest(identifier, container);
        }
        return req;
    }

    protected boolean isDownloadDDAAlwaysAllowed() {
        return this.assumeDownloadDDAIsAllowed;
    }

    protected boolean isUploadDDAAlwaysAllowed() {
        return this.assumeUploadDDAIsAllowed;
    }

    public boolean hasFinishedStart() {
        return this.hasFinishedStart;
    }

    public void setCompletionCallback(RequestCompletionCallback cb) {
        if (this.globalForeverClient != null) {
            this.globalForeverClient.addRequestCompletionCallback(cb);
        }
        this.globalRebootClient.addRequestCompletionCallback(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking(final ClientRequest req, ObjectContainer container, ClientContext context) throws IdentifierCollisionException, DatabaseDisabledException {
        if (req.persistenceType == 1) {
            req.start(null, this.core.clientContext);
        } else if (container != null) {
            req.register(container, false, false);
            req.start(container, context);
            container.deactivate((Object)req, 1);
        } else {
            class OutputWrapper {
                boolean done;
                IdentifierCollisionException collided;

                OutputWrapper() {
                }
            }
            final OutputWrapper ow = new OutputWrapper();
            this.core.clientContext.jobRunner.queue(new DBJob(){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean run(ObjectContainer container, ClientContext context) {
                    block8: {
                        OutputWrapper outputWrapper;
                        try {
                            try {
                                req.register(container, false, false);
                                req.start(container, context);
                            }
                            catch (IdentifierCollisionException e) {
                                ow.collided = e;
                                Object var5_4 = null;
                                OutputWrapper outputWrapper3 = ow;
                                synchronized (outputWrapper3) {
                                    ow.done = true;
                                    ow.notifyAll();
                                    break block8;
                                }
                            }
                            Object var5_3 = null;
                            outputWrapper = ow;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            OutputWrapper outputWrapper2 = ow;
                            synchronized (outputWrapper2) {
                                ow.done = true;
                                ow.notifyAll();
                                throw throwable;
                            }
                        }
                        synchronized (outputWrapper) {
                            ow.done = true;
                            ow.notifyAll();
                        }
                    }
                    container.deactivate((Object)req, 1);
                    return true;
                }
            }, 7, false);
            OutputWrapper outputWrapper = ow;
            synchronized (outputWrapper) {
                while (!ow.done) {
                    try {
                        ow.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (ow.collided != null) {
                    throw ow.collided;
                }
                return;
            }
        }
    }

    public boolean restartBlocking(final String identifier) throws DatabaseDisabledException {
        ClientRequest req = this.globalRebootClient.getRequest(identifier, null);
        if (req != null) {
            req.restart(null, this.core.clientContext);
            return true;
        }
        class OutputWrapper {
            boolean done;
            boolean success;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                boolean success = false;
                try {
                    block8: {
                        try {
                            ClientRequest req = FCPServer.this.globalForeverClient.getRequest(identifier, container);
                            if (req == null) break block8;
                            req.restart(container, context);
                            success = true;
                        }
                        catch (DatabaseDisabledException e) {
                            success = false;
                            Object var6_7 = null;
                            OutputWrapper outputWrapper3 = ow;
                            synchronized (outputWrapper3) {
                                ow.success = success;
                                ow.done = true;
                                ow.notifyAll();
                                return true;
                            }
                        }
                    }
                    Object var6_6 = null;
                    OutputWrapper outputWrapper = ow;
                    synchronized (outputWrapper) {
                        ow.success = success;
                        ow.done = true;
                        ow.notifyAll();
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OutputWrapper outputWrapper2 = ow;
                    synchronized (outputWrapper2) {
                        ow.success = success;
                        ow.done = true;
                        ow.notifyAll();
                        throw throwable;
                    }
                }
            }
        }, 7, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (true) {
                if (ow.done) {
                    return ow.success;
                }
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public TempFetchResult getCompletedRequestBlocking(final FreenetURI key) throws DatabaseDisabledException {
        ClientGet get = this.globalRebootClient.getCompletedRequest(key, null);
        if (get != null) {
            return new TempFetchResult(new ClientMetadata(get.getMIMEType(null)), get.getBucket(null), false);
        }
        class OutputWrapper {
            TempFetchResult result;
            boolean done;

            OutputWrapper() {
            }
        }
        final OutputWrapper ow = new OutputWrapper();
        this.core.clientContext.jobRunner.queue(new DBJob(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean run(ObjectContainer container, ClientContext context) {
                OutputWrapper outputWrapper;
                TempFetchResult result = null;
                try {
                    ClientGet get = FCPServer.this.globalForeverClient.getCompletedRequest(key, container);
                    container.activate((Object)get, 1);
                    if (get != null) {
                        Bucket newData;
                        Bucket origData = get.getBucket(container);
                        container.activate((Object)origData, 5);
                        boolean copied = false;
                        try {
                            newData = origData.createShadow();
                        }
                        catch (IOException e) {
                            Logger.error(this, "Caught error " + e + " trying to create shallow copy, copying data...", e);
                            newData = null;
                        }
                        if (newData == null) {
                            try {
                                newData = FCPServer.this.core.tempBucketFactory.makeBucket(origData.size());
                                BucketTools.copy(origData, newData);
                            }
                            catch (IOException e) {
                                Logger.error(this, "Unable to copy data: " + e, e);
                                result = null;
                                boolean bl = false;
                                Object var11_11 = null;
                                OutputWrapper outputWrapper2 = ow;
                                synchronized (outputWrapper2) {
                                    ow.result = result;
                                    ow.done = true;
                                    ow.notifyAll();
                                    return bl;
                                }
                            }
                            copied = true;
                        }
                        result = new TempFetchResult(new ClientMetadata(get.getMIMEType(container)), newData, copied);
                    }
                    container.deactivate((Object)get, 1);
                    Object var11_12 = null;
                    outputWrapper = ow;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OutputWrapper outputWrapper3 = ow;
                    synchronized (outputWrapper3) {
                        ow.result = result;
                        ow.done = true;
                        ow.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (outputWrapper) {
                    ow.result = result;
                    ow.done = true;
                    ow.notifyAll();
                    return false;
                }
            }
        }, 7, false);
        OutputWrapper outputWrapper = ow;
        synchronized (outputWrapper) {
            while (true) {
                if (ow.done) {
                    return ow.result;
                }
                try {
                    ow.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing FCPServer in database", new Exception("error"));
        return false;
    }

    static {
        ssl = false;
    }

    static class AssumeDDAUploadIsAllowedCallback
    extends BooleanCallback {
        FCPServer server;

        AssumeDDAUploadIsAllowedCallback() {
        }

        public Boolean get() {
            return this.server.assumeUploadDDAIsAllowed;
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.server.assumeUploadDDAIsAllowed = val;
        }
    }

    static class AssumeDDADownloadIsAllowedCallback
    extends BooleanCallback {
        FCPServer server;

        AssumeDDADownloadIsAllowedCallback() {
        }

        public Boolean get() {
            return this.server.assumeDownloadDDAIsAllowed;
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.server.assumeDownloadDDAIsAllowed = val;
        }
    }

    static class PersistentDownloadsFileCallback
    extends StringCallback {
        FCPServer server;

        PersistentDownloadsFileCallback() {
        }

        public String get() {
            return this.server.persistentDownloadsFile.toString();
        }

        public void set(String val) throws InvalidConfigValueException {
            File f = new File(val);
            if (f.equals(this.server.persistentDownloadsFile)) {
                return;
            }
            this.server.setPersistentDownloadsFile(f);
        }
    }

    static class FCPAllowedHostsFullAccessCallback
    extends StringCallback {
        private final NodeClientCore node;

        public FCPAllowedHostsFullAccessCallback(NodeClientCore node) {
            this.node = node;
        }

        public String get() {
            return this.node.getFCPServer().allowedHostsFullAccess.getAllowedHosts();
        }

        public void set(String val) {
            if (!val.equals(this.get())) {
                this.node.getFCPServer().allowedHostsFullAccess.setAllowedHosts(val);
            }
        }
    }

    static class PersistentDownloadsEnabledCallback
    extends BooleanCallback {
        boolean enabled;

        PersistentDownloadsEnabledCallback() {
        }

        public Boolean get() {
            return this.enabled;
        }

        public void set(Boolean set) throws InvalidConfigValueException {
            if (set != this.enabled) {
                throw new InvalidConfigValueException("Cannot disable/enable persistent download loading support on the fly");
            }
        }
    }

    static class FCPAllowedHostsCallback
    extends StringCallback {
        private final NodeClientCore node;

        public FCPAllowedHostsCallback(NodeClientCore node) {
            this.node = node;
        }

        public String get() {
            FCPServer server = this.node.getFCPServer();
            if (server == null) {
                return "127.0.0.1,0:0:0:0:0:0:0:1";
            }
            NetworkInterface netIface = server.networkInterface;
            return netIface == null ? "127.0.0.1,0:0:0:0:0:0:0:1" : netIface.getAllowedHosts();
        }

        public void set(String val) {
            if (!val.equals(this.get())) {
                this.node.getFCPServer().networkInterface.setAllowedHosts(val);
            }
        }
    }

    static class FCPBindtoCallback
    extends StringCallback {
        final NodeClientCore node;

        FCPBindtoCallback(NodeClientCore node) {
            this.node = node;
        }

        public String get() {
            return this.node.getFCPServer().bindTo;
        }

        public void set(String val) throws InvalidConfigValueException {
            if (!val.equals(this.get())) {
                try {
                    this.node.getFCPServer().networkInterface.setBindTo(val, true);
                    this.node.getFCPServer().bindTo = val;
                }
                catch (IOException e) {
                    throw new InvalidConfigValueException(FCPServer.l10n("couldNotChangeBindTo", "error", e.getLocalizedMessage()));
                }
            }
        }
    }

    static class FCPSSLCallback
    extends BooleanCallback {
        FCPSSLCallback() {
        }

        public Boolean get() {
            return ssl;
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (!SSL.available()) {
                throw new InvalidConfigValueException("Enable SSL support before use ssl with FCP");
            }
            ssl = val;
            throw new InvalidConfigValueException("Cannot change SSL on the fly, please restart freenet");
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    static class FCPEnabledCallback
    extends BooleanCallback {
        final NodeClientCore node;

        FCPEnabledCallback(NodeClientCore node) {
            this.node = node;
        }

        public Boolean get() {
            return this.node.getFCPServer().enabled;
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (!this.get().equals(val)) {
                throw new InvalidConfigValueException(FCPServer.l10n("cannotStartOrStopOnTheFly"));
            }
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    static class FCPPortNumberCallback
    extends IntCallback {
        private final NodeClientCore node;

        FCPPortNumberCallback(NodeClientCore node) {
            this.node = node;
        }

        public Integer get() {
            return this.node.getFCPServer().port;
        }

        public void set(Integer val) throws InvalidConfigValueException {
            if (!this.get().equals(val)) {
                throw new InvalidConfigValueException("Cannot change FCP port number on the fly");
            }
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

