/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.DataCarryingMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.MessageInvalidException;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginTalker;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;

public class FCPPluginMessage
extends DataCarryingMessage {
    public static final String NAME = "FCPPluginMessage";
    public static final String PARAM_PREFIX = "Param";
    private final String identifier;
    private final String pluginname;
    private final long dataLength;
    private final SimpleFieldSet plugparams;

    FCPPluginMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "FCPPluginMessage must contain a Identifier field", null, false);
        }
        this.pluginname = fs.get("PluginName");
        if (this.pluginname == null) {
            throw new MessageInvalidException(5, "FCPPluginMessage must contain a PluginName field", this.identifier, false);
        }
        boolean havedata = "Data".equals(fs.getEndMarker());
        String dataLengthString = fs.get("DataLength");
        if (!havedata && dataLengthString != null) {
            throw new MessageInvalidException(8, "A nondata message can't have a DataLength field", this.identifier, false);
        }
        if (havedata) {
            if (dataLengthString == null) {
                throw new MessageInvalidException(5, "Need DataLength on a Datamessage", this.identifier, false);
            }
            try {
                this.dataLength = Long.parseLong(dataLengthString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing DataLength field: " + e.getMessage(), this.identifier, false);
            }
        } else {
            this.dataLength = -1L;
        }
        this.plugparams = fs.subset(PARAM_PREFIX);
    }

    String getIdentifier() {
        return this.identifier;
    }

    boolean isGlobal() {
        return false;
    }

    long dataLength() {
        return this.dataLength;
    }

    public SimpleFieldSet getFieldSet() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PluginTalker pt;
        Bucket data2 = this.bucket;
        try {
            pt = new PluginTalker(node, handler, this.pluginname, this.identifier, handler.hasFullAccess());
        }
        catch (PluginNotFoundException e) {
            throw new MessageInvalidException(32, this.pluginname + " not found or is not a FCPPlugin", this.identifier, false);
        }
        pt.send(this.plugparams, data2);
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }
}

