/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import freenet.node.NodeClientCore;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPServer;
import freenet.support.Logger;

public class FCPPersistentRoot {
    final long nodeDBHandle;
    final FCPClient globalForeverClient;

    public FCPPersistentRoot(long nodeDBHandle, ObjectContainer container) {
        this.nodeDBHandle = nodeDBHandle;
        this.globalForeverClient = new FCPClient("Global Queue", null, true, null, 2, this, container);
    }

    public static FCPPersistentRoot create(final long nodeDBHandle, ObjectContainer container) {
        ObjectSet set = container.query((Predicate)new Predicate<FCPPersistentRoot>(){

            public boolean match(FCPPersistentRoot root) {
                return root.nodeDBHandle == nodeDBHandle;
            }
        });
        System.err.println("Count of roots: " + set.size());
        if (set.hasNext()) {
            System.err.println("Loaded FCP persistent root.");
            FCPPersistentRoot root = (FCPPersistentRoot)set.next();
            container.activate((Object)root, 2);
            root.globalForeverClient.init(container);
            return root;
        }
        FCPPersistentRoot root = new FCPPersistentRoot(nodeDBHandle, container);
        container.store((Object)root);
        System.err.println("Created FCP persistent root.");
        return root;
    }

    public FCPClient registerForeverClient(String name, NodeClientCore core, FCPConnectionHandler handler, FCPServer server, ObjectContainer container) {
        FCPClient client;
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Registering forever-client for " + name);
        }
        Query query = container.query();
        query.constrain(FCPClient.class);
        Constraint con = query.descend("name").constrain((Object)name);
        con.and(query.descend("root").constrain((Object)this).identity());
        ObjectSet set = query.execute();
        while (set.hasNext()) {
            client = (FCPClient)set.next();
            container.activate((Object)client, 1);
            if (client.root != this) {
                container.deactivate((Object)client, 1);
                continue;
            }
            client.setConnection(handler);
            if (!name.equals(client.name)) {
                Logger.error(this, "Returning " + client + " for " + name);
            }
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Returning " + client + " for " + name);
            }
            client.init(container);
            return client;
        }
        client = new FCPClient(name, handler, false, null, 2, this, container);
        container.store((Object)client);
        return client;
    }

    public void maybeUnregisterClient(FCPClient client, ObjectContainer container) {
        if (!client.hasPersistentRequests(container)) {
            client.removeFromDatabase(container);
        }
    }
}

