/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.Node;
import freenet.node.fcp.AddPeer;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientHelloMessage;
import freenet.node.fcp.ClientPutComplexDirMessage;
import freenet.node.fcp.ClientPutDiskDirMessage;
import freenet.node.fcp.ClientPutMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPPluginMessage;
import freenet.node.fcp.GenerateSSKMessage;
import freenet.node.fcp.GetConfig;
import freenet.node.fcp.GetNode;
import freenet.node.fcp.GetPluginInfo;
import freenet.node.fcp.GetRequestStatusMessage;
import freenet.node.fcp.ListPeerMessage;
import freenet.node.fcp.ListPeerNotesMessage;
import freenet.node.fcp.ListPeersMessage;
import freenet.node.fcp.ListPersistentRequestsMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.ModifyConfig;
import freenet.node.fcp.ModifyPeer;
import freenet.node.fcp.ModifyPeerNote;
import freenet.node.fcp.ModifyPersistentRequest;
import freenet.node.fcp.RemovePeer;
import freenet.node.fcp.RemovePersistentRequest;
import freenet.node.fcp.ShutdownMessage;
import freenet.node.fcp.SubscribeUSKMessage;
import freenet.node.fcp.TestDDARequestMessage;
import freenet.node.fcp.TestDDAResponseMessage;
import freenet.node.fcp.UnsubscribeUSKMessage;
import freenet.node.fcp.WatchGlobal;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.io.PersistentTempBucketFactory;
import java.io.IOException;
import java.io.OutputStream;

public abstract class FCPMessage {
    public void send(OutputStream os) throws IOException {
        SimpleFieldSet sfs = this.getFieldSet();
        sfs.setEndMarker(this.getEndString());
        String msg = sfs.toString();
        os.write((this.getName() + '\n').getBytes("UTF-8"));
        os.write(msg.getBytes("UTF-8"));
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, "Outgoing FCP message:\n" + this.getName() + '\n' + sfs.toString());
            Logger.debug(this, "Being handled by " + this);
        }
    }

    String getEndString() {
        return "EndMessage";
    }

    public abstract SimpleFieldSet getFieldSet();

    public abstract String getName();

    public static FCPMessage create(String name, SimpleFieldSet fs, BucketFactory bfTemp, PersistentTempBucketFactory bfPersistent) throws MessageInvalidException {
        if (name.equals("AddPeer")) {
            return new AddPeer(fs);
        }
        if (name.equals("ClientGet")) {
            return new ClientGetMessage(fs);
        }
        if (name.equals("ClientHello")) {
            return new ClientHelloMessage(fs);
        }
        if (name.equals("ClientPutComplexDir")) {
            return new ClientPutComplexDirMessage(fs, bfTemp, bfPersistent);
        }
        if (name.equals("ClientPutDiskDir")) {
            return new ClientPutDiskDirMessage(fs);
        }
        if (name.equals("ClientPut")) {
            return new ClientPutMessage(fs);
        }
        if (name.equals("FCPPluginMessage")) {
            return new FCPPluginMessage(fs);
        }
        if (name.equals("GenerateSSK")) {
            return new GenerateSSKMessage(fs);
        }
        if (name.equals("GetConfig")) {
            return new GetConfig(fs);
        }
        if (name.equals("GetNode")) {
            return new GetNode(fs);
        }
        if (name.equals("GetPluginInfo")) {
            return new GetPluginInfo(fs);
        }
        if (name.equals("GetRequestStatus")) {
            return new GetRequestStatusMessage(fs);
        }
        if (name.equals("ListPeer")) {
            return new ListPeerMessage(fs);
        }
        if (name.equals("ListPeers")) {
            return new ListPeersMessage(fs);
        }
        if (name.equals("ListPeerNotes")) {
            return new ListPeerNotesMessage(fs);
        }
        if (name.equals("ListPersistentRequests")) {
            return new ListPersistentRequestsMessage(fs);
        }
        if (name.equals("ModifyConfig")) {
            return new ModifyConfig(fs);
        }
        if (name.equals("ModifyPeer")) {
            return new ModifyPeer(fs);
        }
        if (name.equals("ModifyPeerNote")) {
            return new ModifyPeerNote(fs);
        }
        if (name.equals("ModifyPersistentRequest")) {
            return new ModifyPersistentRequest(fs);
        }
        if (name.equals("RemovePeer")) {
            return new RemovePeer(fs);
        }
        if (name.equals("RemoveRequest") || name.equals("RemovePersistentRequest")) {
            return new RemovePersistentRequest(fs);
        }
        if (name.equals("Shutdown")) {
            return new ShutdownMessage();
        }
        if (name.equals("SubscribeUSK")) {
            return new SubscribeUSKMessage(fs);
        }
        if (name.equals("UnsubscribeUSK")) {
            return new UnsubscribeUSKMessage(fs);
        }
        if (name.equals("TestDDARequest")) {
            return new TestDDARequestMessage(fs);
        }
        if (name.equals("TestDDAResponse")) {
            return new TestDDAResponseMessage(fs);
        }
        if (name.equals("WatchGlobal")) {
            return new WatchGlobal(fs);
        }
        if (name.equals("Void")) {
            return null;
        }
        throw new MessageInvalidException(7, "Unknown message name " + name, null, false);
    }

    public static FCPMessage create(String name, SimpleFieldSet fs) throws MessageInvalidException {
        return FCPMessage.create(name, fs, null, null);
    }

    public abstract void run(FCPConnectionHandler var1, Node var2) throws MessageInvalidException;

    public abstract void removeFrom(ObjectContainer var1);
}

