/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public class FCPConnectionOutputHandler
implements Runnable {
    final FCPConnectionHandler handler;
    final LinkedList<FCPMessage> outQueue;

    public FCPConnectionOutputHandler(FCPConnectionHandler handler) {
        this.handler = handler;
        this.outQueue = new LinkedList();
    }

    void start() {
        this.handler.server.node.executor.execute(this, "FCP output handler for " + this.handler.sock.getRemoteSocketAddress() + ':' + this.handler.sock.getPort());
    }

    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (IOException e) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Caught " + e, (Throwable)e);
            }
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
        this.handler.close();
        this.handler.closedOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void realRun() throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(this.handler.sock.getOutputStream(), 4096);
        while (true) {
            boolean closed;
            FCPMessage msg;
            block8: {
                msg = null;
                while (true) {
                    closed = this.handler.isClosed();
                    LinkedList<FCPMessage> linkedList = this.outQueue;
                    // MONITORENTER : linkedList
                    if (!this.outQueue.isEmpty()) break;
                    if (closed) {
                        // MONITOREXIT : linkedList
                        break block8;
                    }
                    ((OutputStream)os).flush();
                    try {
                        this.outQueue.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                msg = this.outQueue.removeFirst();
                // MONITOREXIT : linkedList
            }
            if (msg == null) {
                if (!closed) continue;
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
                return;
            }
            msg.send(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(FCPMessage msg) {
        if (Logger.shouldLog(2, this)) {
            Logger.debug(this, "Queueing " + msg, new Exception("debug"));
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        LinkedList<FCPMessage> linkedList = this.outQueue;
        synchronized (linkedList) {
            this.outQueue.add(msg);
            this.outQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed() {
        LinkedList<FCPMessage> linkedList = this.outQueue;
        synchronized (linkedList) {
            this.outQueue.notifyAll();
        }
        while (!this.outQueue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        throw new UnsupportedOperationException("FCPConnectionOutputHandler storage in database not supported");
    }
}

