/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPPersistentRoot;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.RequestCompletionCallback;
import freenet.support.Logger;
import freenet.support.NullObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCPClient {
    final FCPPersistentRoot root;
    final String name;
    private transient FCPConnectionHandler currentConnection;
    private final List<ClientRequest> runningPersistentRequests;
    private final List<ClientRequest> completedUnackedRequests;
    private final Map<String, ClientRequest> clientRequestsByIdentifier;
    public final boolean isGlobalQueue;
    boolean watchGlobal;
    int watchGlobalVerbosityMask;
    private transient LinkedList<FCPClient> clientsWatching;
    private final NullObject clientsWatchingLock = new NullObject();
    final RequestClient lowLevelClient;
    private transient List<RequestCompletionCallback> completionCallbacks;
    final short persistenceType;

    public FCPClient(String name2, FCPConnectionHandler handler, boolean isGlobalQueue, RequestCompletionCallback cb, short persistenceType, FCPPersistentRoot root, ObjectContainer container) {
        this.name = name2;
        if (this.name == null) {
            throw new NullPointerException();
        }
        this.currentConnection = handler;
        final boolean forever = persistenceType == 2;
        this.runningPersistentRequests = new ArrayList<ClientRequest>();
        this.completedUnackedRequests = new ArrayList<ClientRequest>();
        this.clientRequestsByIdentifier = new HashMap<String, ClientRequest>();
        this.isGlobalQueue = isGlobalQueue;
        this.persistenceType = persistenceType;
        assert (persistenceType == 2 || persistenceType == 1);
        this.watchGlobalVerbosityMask = Integer.MAX_VALUE;
        this.lowLevelClient = new RequestClient(){

            public boolean persistent() {
                return forever;
            }

            public void removeFrom(ObjectContainer container) {
                if (!forever) {
                    throw new UnsupportedOperationException();
                }
                container.delete((Object)this);
            }
        };
        this.completionCallbacks = new ArrayList<RequestCompletionCallback>();
        if (cb != null) {
            this.completionCallbacks.add(cb);
        }
        if (persistenceType == 2) {
            assert (root != null);
            this.root = root;
        } else {
            this.root = null;
        }
    }

    public synchronized FCPConnectionHandler getConnection() {
        return this.currentConnection;
    }

    public synchronized void setConnection(FCPConnectionHandler handler) {
        this.currentConnection = handler;
    }

    public synchronized void onLostConnection(FCPConnectionHandler handler) {
        handler.freeDDAJobs();
        if (this.currentConnection == handler) {
            this.currentConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedClientRequest(ClientRequest get, ObjectContainer container) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Finished client request", (Throwable)new Exception("debug"));
        }
        assert (this.persistenceType == 2 == (container != null));
        assert (get.persistenceType == this.persistenceType);
        if (container != null) {
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.completedUnackedRequests, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            if (this.runningPersistentRequests.remove(get)) {
                this.completedUnackedRequests.add(get);
                if (container != null) {
                    container.store((Object)get);
                    container.ext().store(this.runningPersistentRequests, 2);
                    container.ext().store(this.completedUnackedRequests, 2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePendingMessagesOnConnectionRestart(FCPConnectionOutputHandler outputHandler, ObjectContainer container) {
        Object[] reqs;
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            reqs = this.completedUnackedRequests.toArray();
        }
        for (int i = 0; i < reqs.length; ++i) {
            ClientRequest req = (ClientRequest)reqs[i];
            if (this.persistenceType == 2) {
                container.activate((Object)req, 1);
            }
            ((ClientRequest)reqs[i]).sendPendingMessages(outputHandler, true, false, false, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePendingMessagesFromRunningRequests(FCPConnectionOutputHandler outputHandler, ObjectContainer container) {
        Object[] reqs;
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.runningPersistentRequests, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            reqs = this.runningPersistentRequests.toArray();
        }
        for (int i = 0; i < reqs.length; ++i) {
            ClientRequest req = (ClientRequest)reqs[i];
            if (this.persistenceType == 2) {
                container.activate((Object)req, 1);
            }
            req.sendPendingMessages(outputHandler, true, false, false, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ClientRequest cg, boolean startLater, ObjectContainer container) throws IdentifierCollisionException {
        assert (cg.persistenceType == this.persistenceType);
        assert (this.persistenceType == 2 == (container != null));
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Registering " + cg.getIdentifier() + (startLater ? " to start later" : ""));
        }
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            String ident = cg.getIdentifier();
            ClientRequest old = this.clientRequestsByIdentifier.get(ident);
            if (old != null && old != cg) {
                throw new IdentifierCollisionException();
            }
            if (cg.hasFinished()) {
                this.completedUnackedRequests.add(cg);
                if (container != null) {
                    container.store((Object)cg);
                    container.ext().store(this.completedUnackedRequests, 2);
                }
            } else {
                this.runningPersistentRequests.add(cg);
                if (container != null) {
                    cg.storeTo(container);
                    container.ext().store(this.runningPersistentRequests, 2);
                }
            }
            this.clientRequestsByIdentifier.put(ident, cg);
            if (container != null) {
                container.ext().store(this.clientRequestsByIdentifier, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeByIdentifier(String identifier, boolean kill, FCPServer server, ObjectContainer container, ClientContext context) {
        ClientRequest req;
        assert (this.persistenceType == 2 == (container != null));
        boolean logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "removeByIdentifier(" + identifier + ',' + kill + ')');
        }
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            req = this.clientRequestsByIdentifier.get(identifier);
            boolean removedFromRunning = false;
            if (req == null) {
                for (ClientRequest r : this.completedUnackedRequests) {
                    container.activate((Object)r, 1);
                    if (r.getIdentifier().equals(identifier)) {
                        req = r;
                        this.completedUnackedRequests.remove(r);
                        Logger.error(this, "Found completed unacked request " + r + " for identifier " + r.getIdentifier() + " but not in clientRequestsByIdentifier!!");
                        break;
                    }
                    container.deactivate((Object)r, 1);
                }
                if (req == null) {
                    for (ClientRequest r : this.runningPersistentRequests) {
                        container.activate((Object)r, 1);
                        if (r.getIdentifier().equals(identifier)) {
                            req = r;
                            this.runningPersistentRequests.remove(r);
                            removedFromRunning = true;
                            Logger.error(this, "Found running request " + r + " for identifier " + r.getIdentifier() + " but not in clientRequestsByIdentifier!!");
                            break;
                        }
                        container.deactivate((Object)r, 1);
                    }
                }
                if (req == null) {
                    return false;
                }
            } else {
                removedFromRunning = this.runningPersistentRequests.remove(req);
                if (!removedFromRunning && !this.completedUnackedRequests.remove(req)) {
                    Logger.error(this, "Removing " + identifier + ": in clientRequestsByIdentifier but not in running/completed maps!");
                    return false;
                }
            }
            this.clientRequestsByIdentifier.remove(identifier);
            if (container != null) {
                if (removedFromRunning) {
                    container.ext().store(this.runningPersistentRequests, 2);
                } else {
                    container.ext().store(this.completedUnackedRequests, 2);
                }
                container.ext().store(this.clientRequestsByIdentifier, 2);
            }
        }
        if (container != null) {
            container.activate((Object)req, 1);
        }
        if (kill) {
            if (logMINOR) {
                Logger.minor(this, "Killing request " + req);
            }
            req.cancel(container, context);
        }
        req.requestWasRemoved(container, context);
        RequestCompletionCallback[] callbacks = null;
        FCPClient removedFromRunning = this;
        synchronized (removedFromRunning) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (RequestCompletionCallback cb : callbacks) {
                cb.onRemove(req, container);
            }
        }
        return true;
    }

    public boolean hasPersistentRequests(ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (this.runningPersistentRequests == null) {
            if (!container.ext().isActive((Object)this)) {
                Logger.error(this, "FCPCLIENT NOT ACTIVE!!!");
            }
            throw new NullPointerException();
        }
        if (this.completedUnackedRequests == null) {
            if (!container.ext().isActive((Object)this)) {
                Logger.error(this, "FCPCLIENT NOT ACTIVE!!!");
            }
            throw new NullPointerException();
        }
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
        }
        return !this.runningPersistentRequests.isEmpty() || !this.completedUnackedRequests.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentRequests(List<ClientRequest> v, boolean onlyForever, ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            for (ClientRequest req : this.runningPersistentRequests) {
                if (container != null) {
                    container.activate((Object)req, 1);
                }
                if (!req.isPersistentForever() && onlyForever) continue;
                v.add(req);
            }
            if (container != null) {
                for (ClientRequest req : this.completedUnackedRequests) {
                    container.activate((Object)req, 1);
                }
            }
            v.addAll(this.completedUnackedRequests);
        }
    }

    public void setWatchGlobal(boolean enabled, int verbosityMask, FCPServer server, ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (this.isGlobalQueue) {
            Logger.error(this, "Set watch global on global queue!: " + this, new Exception("debug"));
            return;
        }
        if (this.watchGlobal && !enabled) {
            server.globalRebootClient.unwatch(this);
            server.globalForeverClient.unwatch(this);
            this.watchGlobal = false;
        } else if (enabled && !this.watchGlobal) {
            server.globalRebootClient.watch(this);
            server.globalForeverClient.watch(this);
            FCPConnectionHandler connHandler = this.getConnection();
            if (connHandler != null) {
                if (this.persistenceType == 1) {
                    server.globalRebootClient.queuePendingMessagesOnConnectionRestart(connHandler.outputHandler, container);
                } else {
                    server.globalForeverClient.queuePendingMessagesOnConnectionRestart(connHandler.outputHandler, container);
                }
            }
            this.watchGlobal = true;
        }
        this.watchGlobalVerbosityMask = verbosityMask;
    }

    public void queueClientRequestMessage(FCPMessage msg, int verbosityLevel, ObjectContainer container) {
        this.queueClientRequestMessage(msg, verbosityLevel, false, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueClientRequestMessage(FCPMessage msg, int verbosityLevel, boolean useGlobalMask, ObjectContainer container) {
        if (useGlobalMask && (verbosityLevel & this.watchGlobalVerbosityMask) != verbosityLevel) {
            return;
        }
        FCPConnectionHandler conn = this.getConnection();
        if (conn != null) {
            conn.outputHandler.queue(msg);
        }
        if (this.isGlobalQueue) {
            FCPClient[] clients;
            NullObject nullObject = this.clientsWatchingLock;
            synchronized (nullObject) {
                clients = this.clientsWatching != null ? this.clientsWatching.toArray(new FCPClient[this.clientsWatching.size()]) : null;
            }
            if (clients != null) {
                for (int i = 0; i < clients.length; ++i) {
                    if (this.persistenceType == 2) {
                        container.activate((Object)clients[i], 1);
                    }
                    if (clients[i].persistenceType != this.persistenceType) continue;
                    clients[i].queueClientRequestMessage(msg, verbosityLevel, true, container);
                    if (this.persistenceType != 2) continue;
                    container.deactivate((Object)clients[i], 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwatch(FCPClient client) {
        if (!this.isGlobalQueue) {
            return;
        }
        NullObject nullObject = this.clientsWatchingLock;
        synchronized (nullObject) {
            if (this.clientsWatching != null) {
                this.clientsWatching.remove(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(FCPClient client) {
        if (!this.isGlobalQueue) {
            return;
        }
        NullObject nullObject = this.clientsWatchingLock;
        synchronized (nullObject) {
            if (this.clientsWatching == null) {
                this.clientsWatching = new LinkedList();
            }
            this.clientsWatching.add(client);
        }
    }

    public synchronized ClientRequest getRequest(String identifier, ObjectContainer container) {
        assert (this.persistenceType == 2 == (container != null));
        if (container != null) {
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        ClientRequest req = this.clientRequestsByIdentifier.get(identifier);
        if (this.persistenceType == 2) {
            container.activate((Object)req, 1);
        }
        return req;
    }

    public String toString() {
        return super.toString() + ':' + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuccess(ClientRequest req, ObjectContainer container) {
        assert (req.persistenceType == this.persistenceType);
        RequestCompletionCallback[] callbacks = null;
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (RequestCompletionCallback cb : callbacks) {
                cb.notifySuccess(req, container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFailure(ClientRequest req, ObjectContainer container) {
        assert (req.persistenceType == this.persistenceType);
        RequestCompletionCallback[] callbacks = null;
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            if (this.completionCallbacks != null) {
                callbacks = this.completionCallbacks.toArray(new RequestCompletionCallback[this.completionCallbacks.size()]);
            }
        }
        if (callbacks != null) {
            for (RequestCompletionCallback cb : callbacks) {
                cb.notifyFailure(req, container);
            }
        }
    }

    public synchronized void addRequestCompletionCallback(RequestCompletionCallback cb) {
        if (this.completionCallbacks == null) {
            this.completionCallbacks = new ArrayList<RequestCompletionCallback>();
        }
        this.completionCallbacks.add(cb);
    }

    public void removeFromDatabase(ObjectContainer container) {
        container.activate(this.runningPersistentRequests, 2);
        container.delete(this.runningPersistentRequests);
        container.activate(this.completedUnackedRequests, 2);
        container.delete(this.completedUnackedRequests);
        container.activate(this.clientRequestsByIdentifier, 2);
        container.delete(this.clientRequestsByIdentifier);
        container.activate((Object)this.lowLevelClient, 2);
        this.lowLevelClient.removeFrom(container);
        container.delete((Object)this);
        container.delete((Object)this.clientsWatchingLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ObjectContainer container, ClientContext context) {
        HashSet<ClientRequest> toKill = new HashSet<ClientRequest>();
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
            container.activate(this.runningPersistentRequests, 2);
            container.activate(this.clientRequestsByIdentifier, 2);
        }
        FCPClient fCPClient = this;
        synchronized (fCPClient) {
            for (ClientRequest req : this.runningPersistentRequests) {
                toKill.add(req);
            }
            this.runningPersistentRequests.clear();
            for (ClientRequest req : this.completedUnackedRequests) {
                if (this.persistenceType == 2) {
                    container.activate((Object)req, 1);
                }
                toKill.add(req);
            }
            this.completedUnackedRequests.clear();
            for (ClientRequest req : this.clientRequestsByIdentifier.values()) {
                if (this.persistenceType == 2) {
                    container.activate((Object)req, 1);
                }
                toKill.add(req);
            }
            this.clientRequestsByIdentifier.clear();
            if (this.persistenceType == 2) {
                container.ext().store(this.clientRequestsByIdentifier, 2);
            }
        }
    }

    public ClientGet getCompletedRequest(FreenetURI key, ObjectContainer container) {
        if (container != null) {
            container.activate(this.completedUnackedRequests, 2);
        }
        for (int i = 0; i < this.completedUnackedRequests.size(); ++i) {
            ClientRequest req = this.completedUnackedRequests.get(i);
            if (!(req instanceof ClientGet)) continue;
            ClientGet getter = (ClientGet)req;
            if (this.persistenceType == 2) {
                container.activate((Object)getter, 1);
            }
            if (getter.getURI(container).equals(key)) {
                return getter;
            }
            if (this.persistenceType != 2) continue;
            container.deactivate((Object)getter, 1);
        }
        return null;
    }

    public void init(ObjectContainer container) {
        container.activate(this.runningPersistentRequests, 2);
        container.activate(this.completedUnackedRequests, 2);
        container.activate(this.clientRequestsByIdentifier, 2);
        container.activate((Object)this.lowLevelClient, 2);
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.persistenceType != 2) {
            Logger.error(this, "Not storing non-persistent request in database", new Exception("error"));
            return false;
        }
        return true;
    }
}

