/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.DefaultMIMETypes;
import freenet.node.fcp.DirPutFile;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import java.io.File;

public class DiskDirPutFile
extends DirPutFile {
    final File file;

    public DiskDirPutFile(SimpleFieldSet subset, String identifier, boolean global) throws MessageInvalidException {
        super(subset, identifier, global);
        String s = subset.get("Filename");
        if (s == null) {
            throw new MessageInvalidException(5, "Missing field: Filename on " + this.name, identifier, global);
        }
        this.file = new File(s);
    }

    protected String guessMIME() {
        String mime = super.guessMIME();
        if (mime == null) {
            mime = DefaultMIMETypes.guessMIMEType(this.file.getName(), false);
        }
        return mime;
    }

    public Bucket getData() {
        return new FileBucket(this.file, true, false, false, false, false);
    }

    public File getFile() {
        return this.file;
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this.file);
        container.delete((Object)this);
    }
}

