/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.node.fcp.DirPutFile;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.NullBucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirectDirPutFile
extends DirPutFile {
    private final Bucket data;
    private final long length;

    public DirectDirPutFile(SimpleFieldSet subset, String identifier, boolean global, BucketFactory bf) throws MessageInvalidException {
        super(subset, identifier, global);
        String s = subset.get("DataLength");
        if (s == null) {
            throw new MessageInvalidException(5, "UploadFrom=direct requires a DataLength for " + this.name, identifier, global);
        }
        try {
            this.length = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new MessageInvalidException(6, "Could not parse DataLength: " + e.toString(), identifier, global);
        }
        try {
            this.data = this.length == 0L ? new NullBucket() : bf.makeBucket(this.length);
        }
        catch (IOException e) {
            throw new MessageInvalidException(17, "Internal error: could not allocate temp bucket: " + e.toString(), identifier, global);
        }
    }

    public long bytesToRead() {
        return this.length;
    }

    public void read(InputStream is) throws IOException {
        BucketTools.copyFrom(this.data, is, this.length);
    }

    public void write(OutputStream os) throws IOException {
        BucketTools.copyTo(this.data, os, this.length);
    }

    public Bucket getData() {
        return this.data;
    }

    public void removeFrom(ObjectContainer container) {
        this.data.free();
        this.data.removeFrom(container);
        container.delete((Object)this);
    }
}

