/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.async.ManifestElement;
import freenet.node.fcp.DirectDirPutFile;
import freenet.node.fcp.DiskDirPutFile;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.RedirectDirPutFile;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;

abstract class DirPutFile {
    final String name;
    ClientMetadata meta;

    public DirPutFile(SimpleFieldSet subset, String identifier, boolean global) throws MessageInvalidException {
        this.name = subset.get("Name");
        if (this.name == null) {
            throw new MessageInvalidException(5, "Missing field Name", identifier, global);
        }
        String contentTypeOverride = subset.get("Metadata.ContentType");
        this.meta = contentTypeOverride != null ? new ClientMetadata(contentTypeOverride) : new ClientMetadata(this.guessMIME());
    }

    protected String guessMIME() {
        return DefaultMIMETypes.guessMIMEType(this.name, false);
    }

    public static DirPutFile create(SimpleFieldSet subset, String identifier, boolean global, BucketFactory bf) throws MessageInvalidException {
        String type = subset.get("UploadFrom");
        if (type == null || type.equalsIgnoreCase("direct")) {
            return new DirectDirPutFile(subset, identifier, global, bf);
        }
        if (type.equalsIgnoreCase("disk")) {
            return new DiskDirPutFile(subset, identifier, global);
        }
        if (type.equalsIgnoreCase("redirect")) {
            return new RedirectDirPutFile(subset, identifier, global);
        }
        throw new MessageInvalidException(8, "Unsupported or unknown UploadFrom: " + type, identifier, global);
    }

    public String getName() {
        return this.name;
    }

    public String getMIMEType() {
        return this.meta.getMIMEType();
    }

    public abstract Bucket getData();

    public ManifestElement getElement() {
        String n = this.name;
        int idx = n.lastIndexOf(47);
        if (idx != -1) {
            n = n.substring(idx + 1);
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Element name: " + this.name + " -> " + n);
        }
        return new ManifestElement(n, this.getData(), this.getMIMEType(), this.getData().size());
    }

    public abstract void removeFrom(ObjectContainer var1);
}

