/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.FetchResult;
import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;

public class DataFoundMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final String mimeType;
    final long dataLength;

    public DataFoundMessage(FetchResult fr, String identifier, boolean global) {
        this.identifier = identifier;
        this.global = global;
        this.mimeType = fr.getMimeType();
        this.dataLength = fr.size();
    }

    public DataFoundMessage(long foundDataLength, String foundDataMimeType, String identifier, boolean global) {
        this.mimeType = foundDataMimeType;
        this.identifier = identifier;
        this.global = global;
        this.dataLength = foundDataLength;
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        if (this.global) {
            fs.putSingle("Global", "true");
        }
        fs.putSingle("Metadata.ContentType", this.mimeType);
        fs.putSingle("DataLength", Long.toString(this.dataLength));
        return fs;
    }

    public String getName() {
        return "DataFound";
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "DataFound goes from server to client not the other way around", this.identifier, this.global);
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

