/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.keys.FreenetURI;
import freenet.node.PrioRunnable;
import freenet.node.RequestClient;
import freenet.node.fcp.ClientGet;
import freenet.node.fcp.ClientPut;
import freenet.node.fcp.ClientPutDir;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.PersistenceParseException;
import freenet.node.fcp.PersistentRequestModifiedMessage;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.SerializableToFieldSetBucket;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;

public abstract class ClientRequest {
    protected FreenetURI uri;
    protected final String identifier;
    protected final int verbosity;
    protected final transient FCPConnectionHandler origHandler;
    protected final FCPClient client;
    protected short priorityClass;
    protected final short persistenceType;
    protected boolean finished;
    protected String clientToken;
    protected final boolean global;
    protected final long startupTime;
    protected long completionTime;
    protected final RequestClient lowLevelClient;
    private final int hashCode;
    private static volatile boolean logMINOR;
    public static final short PERSIST_CONNECTION = 0;
    public static final short PERSIST_REBOOT = 1;
    public static final short PERSIST_FOREVER = 2;
    protected boolean started;

    public int hashCode() {
        return this.hashCode;
    }

    public ClientRequest(FreenetURI uri2, String identifier2, int verbosity2, FCPConnectionHandler handler, FCPClient client, short priorityClass2, short persistenceType2, String clientToken2, boolean global, ObjectContainer container) {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.uri = uri2;
        this.identifier = identifier2;
        this.verbosity = global ? Integer.MAX_VALUE : verbosity2;
        this.finished = false;
        this.priorityClass = priorityClass2;
        this.persistenceType = persistenceType2;
        this.clientToken = clientToken2;
        this.global = global;
        if (this.persistenceType == 0) {
            this.origHandler = handler;
            this.lowLevelClient = new RequestClient(){

                public boolean persistent() {
                    return false;
                }

                public void removeFrom(ObjectContainer container) {
                    throw new UnsupportedOperationException();
                }
            };
            this.client = null;
        } else {
            this.origHandler = null;
            if (this.persistenceType == 2) {
                container.activate((Object)client, 1);
                client.init(container);
            }
            this.client = client;
            if (client != null) assert (client.persistenceType == this.persistenceType);
            this.lowLevelClient = client.lowLevelClient;
        }
        this.startupTime = System.currentTimeMillis();
    }

    public ClientRequest(FreenetURI uri2, String identifier2, int verbosity2, FCPConnectionHandler handler, short priorityClass2, short persistenceType2, String clientToken2, boolean global, ObjectContainer container) {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.uri = uri2;
        this.identifier = identifier2;
        this.verbosity = global ? Integer.MAX_VALUE : verbosity2;
        this.finished = false;
        this.priorityClass = priorityClass2;
        this.persistenceType = persistenceType2;
        this.clientToken = clientToken2;
        this.global = global;
        if (this.persistenceType == 0) {
            this.origHandler = handler;
            this.client = null;
            this.lowLevelClient = new RequestClient(){

                public boolean persistent() {
                    return false;
                }

                public void removeFrom(ObjectContainer container) {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            this.origHandler = null;
            if (global) {
                this.client = this.persistenceType == 2 ? handler.server.globalForeverClient : handler.server.globalRebootClient;
            } else {
                FCPClient fCPClient = this.client = this.persistenceType == 2 ? handler.getForeverClient(container) : handler.getRebootClient();
            }
            if (this.persistenceType == 2) {
                container.activate((Object)this.client, 1);
                this.client.init(container);
            }
            this.lowLevelClient = this.client.lowLevelClient;
            if (this.lowLevelClient == null) {
                throw new NullPointerException("No lowLevelClient from client: " + this.client + " global = " + global + " persistence = " + this.persistenceType);
            }
        }
        if (this.lowLevelClient.persistent() != (this.persistenceType == 2)) {
            throw new IllegalStateException("Low level client.persistent=" + this.lowLevelClient.persistent() + " but persistence type = " + this.persistenceType);
        }
        if (this.client != null) assert (this.client.persistenceType == this.persistenceType);
        this.startupTime = System.currentTimeMillis();
    }

    public ClientRequest(SimpleFieldSet fs, FCPClient client2) throws MalformedURLException {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.priorityClass = Short.parseShort(fs.get("PriorityClass"));
        this.uri = new FreenetURI(fs.get("URI"));
        this.identifier = fs.get("Identifier");
        this.verbosity = Integer.parseInt(fs.get("Verbosity"));
        this.persistenceType = ClientRequest.parsePersistence(fs.get("Persistence"));
        if (this.persistenceType == 0) {
            throw new IllegalArgumentException("Reading persistent get with type CONNECTION !!");
        }
        if (this.persistenceType != 2 && this.persistenceType != 1) {
            throw new IllegalArgumentException("Unknown persistence type " + ClientRequest.persistenceTypeString(this.persistenceType));
        }
        this.client = client2;
        this.origHandler = null;
        this.clientToken = fs.get("ClientToken");
        this.finished = Fields.stringToBool(fs.get("Finished"), false);
        this.global = Fields.stringToBool(fs.get("Global"), false);
        String stime = fs.get("StartupTime");
        this.startupTime = stime == null ? System.currentTimeMillis() : Fields.parseLong(stime);
        this.completionTime = fs.getLong("CompletionTime", 0L);
        if (this.finished) {
            this.started = true;
        }
        assert (this.client.persistenceType == this.persistenceType);
        this.lowLevelClient = this.client.lowLevelClient;
    }

    public abstract void onLostConnection(ObjectContainer var1, ClientContext var2);

    public abstract void sendPendingMessages(FCPConnectionOutputHandler var1, boolean var2, boolean var3, boolean var4, ObjectContainer var5);

    public static String persistenceTypeString(short type) {
        switch (type) {
            case 0: {
                return "connection";
            }
            case 1: {
                return "reboot";
            }
            case 2: {
                return "forever";
            }
        }
        return Short.toString(type);
    }

    public static short parsePersistence(String string) {
        if (string == null || string.equalsIgnoreCase("connection")) {
            return 0;
        }
        if (string.equalsIgnoreCase("reboot")) {
            return 1;
        }
        if (string.equalsIgnoreCase("forever")) {
            return 2;
        }
        return Short.parseShort(string);
    }

    public static ClientRequest readAndRegister(BufferedReader br, FCPServer server, ObjectContainer container, ClientContext context) throws IOException {
        Runtime rt = Runtime.getRuntime();
        if (logMINOR) {
            Logger.minor(ClientRequest.class, rt.maxMemory() - rt.freeMemory() + " in use before loading request");
        }
        SimpleFieldSet fs = new SimpleFieldSet(br, false, false);
        String clientName = fs.get("ClientName");
        boolean isGlobal = Fields.stringToBool(fs.get("Global"), false);
        if (clientName == null && !isGlobal) {
            Logger.error(ClientRequest.class, "Discarding old request with no ClientName: " + fs);
            System.err.println("Discarding old request with no ClientName (see logs)");
            return null;
        }
        FCPClient client = !isGlobal ? server.registerForeverClient(clientName, server.core, null, container) : server.globalForeverClient;
        if (logMINOR) {
            Logger.minor(ClientRequest.class, rt.maxMemory() - rt.freeMemory() + " in use loading request " + clientName + " " + fs.get("Identifier"));
        }
        try {
            String type = fs.get("Type");
            if (type.equals("GET")) {
                ClientGet cg = new ClientGet(fs, client, server);
                cg.register(container, false, true);
                cg.start(container, context);
                return cg;
            }
            if (type.equals("PUT")) {
                final ClientPut cp = new ClientPut(fs, client, server, container);
                client.register(cp, false, container);
                DBJob start = new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        cp.start(container, context);
                        try {
                            context.jobRunner.removeRestartJob(this, 7, container);
                            return true;
                        }
                        catch (DatabaseDisabledException e) {
                            return false;
                        }
                    }
                };
                context.jobRunner.queueRestartJob(start, 7, container, false);
                context.jobRunner.queue(start, 7, false);
                return cp;
            }
            if (type.equals("PUTDIR")) {
                final ClientPutDir cp = new ClientPutDir(fs, client, server, container);
                client.register(cp, false, container);
                DBJob start = new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        cp.start(container, context);
                        try {
                            context.jobRunner.removeRestartJob(this, 7, container);
                            return true;
                        }
                        catch (DatabaseDisabledException e) {
                            return false;
                        }
                    }
                };
                context.jobRunner.queueRestartJob(start, 7, container, false);
                context.jobRunner.queue(start, 7, false);
                return cp;
            }
            Logger.error(ClientRequest.class, "Unrecognized type: " + type);
            return null;
        }
        catch (PersistenceParseException e) {
            Logger.error(ClientRequest.class, "Failed to parse request: " + e, e);
            return null;
        }
        catch (Throwable t) {
            Logger.error(ClientRequest.class, "Failed to parse: " + t, t);
            return null;
        }
    }

    abstract void register(ObjectContainer var1, boolean var2, boolean var3) throws IdentifierCollisionException;

    public void cancel(ObjectContainer container, ClientContext context) {
        ClientRequester cr = this.getClientRequest();
        if (this.persistenceType == 2) {
            container.activate((Object)cr, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + cr + " for " + this + " persistenceType = " + this.persistenceType);
        }
        if (cr != null) {
            cr.cancel(container, context);
        }
        this.freeData(container);
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    public boolean isPersistentForever() {
        return this.persistenceType == 2;
    }

    public boolean isPersistent() {
        return this.persistenceType != 0;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected abstract ClientRequester getClientRequest();

    public void dropped(ObjectContainer container, ClientContext context) {
        this.cancel(container, context);
        this.freeData(container);
    }

    public short getPriority() {
        return this.priorityClass;
    }

    protected abstract void freeData(ObjectContainer var1);

    protected void finish(ObjectContainer container) {
        this.completionTime = System.currentTimeMillis();
        if (this.persistenceType == 0) {
            this.origHandler.finishedClientRequest(this);
        } else {
            this.client.finishedClientRequest(this, container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    public abstract SimpleFieldSet getFieldSet() throws IOException;

    public abstract double getSuccessFraction(ObjectContainer var1);

    public abstract double getTotalBlocks(ObjectContainer var1);

    public abstract double getMinBlocks(ObjectContainer var1);

    public abstract double getFetchedBlocks(ObjectContainer var1);

    public abstract double getFailedBlocks(ObjectContainer var1);

    public abstract double getFatalyFailedBlocks(ObjectContainer var1);

    public abstract String getFailureReason(ObjectContainer var1);

    public abstract boolean isTotalFinalized(ObjectContainer var1);

    public void onMajorProgress(ObjectContainer container) {
    }

    public abstract void start(ObjectContainer var1, ClientContext var2);

    public boolean isStarted() {
        return this.started;
    }

    public abstract boolean hasSucceeded();

    public abstract boolean canRestart();

    public abstract boolean restart(ObjectContainer var1, ClientContext var2) throws DatabaseDisabledException;

    protected abstract FCPMessage persistentTagMessage(ObjectContainer var1);

    public void modifyRequest(String newClientToken, short newPriorityClass, FCPServer server, ObjectContainer container) {
        PersistentRequestModifiedMessage modifiedMsg;
        boolean clientTokenChanged = false;
        boolean priorityClassChanged = false;
        if (newClientToken != null) {
            if (this.clientToken != null) {
                if (!newClientToken.equals(this.clientToken)) {
                    this.clientToken = newClientToken;
                    clientTokenChanged = true;
                }
            } else {
                this.clientToken = newClientToken;
                clientTokenChanged = true;
            }
        }
        if (newPriorityClass >= 0 && newPriorityClass != this.priorityClass) {
            this.priorityClass = newPriorityClass;
            ClientRequester r = this.getClientRequest();
            container.activate((Object)r, 1);
            r.setPriorityClass(this.priorityClass, server.core.clientContext, container);
            container.deactivate((Object)r, 1);
            priorityClassChanged = true;
        }
        if (!clientTokenChanged && !priorityClassChanged) {
            return;
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
            container.commit();
            if (logMINOR) {
                Logger.minor(this, "COMMITTED");
            }
        }
        if (clientTokenChanged && priorityClassChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.priorityClass, this.clientToken);
        } else if (priorityClassChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.priorityClass);
        } else if (clientTokenChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.clientToken);
        } else {
            return;
        }
        this.client.queueClientRequestMessage(modifiedMsg, 0, container);
    }

    protected void bucketToFS(SimpleFieldSet fs, String name, boolean includeSize, Bucket data) {
        SerializableToFieldSetBucket bucket = (SerializableToFieldSetBucket)data;
        fs.put(name, bucket.toFieldSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartAsync(final FCPServer server) throws DatabaseDisabledException {
        ClientRequest clientRequest = this;
        synchronized (clientRequest) {
            this.started = false;
        }
        if (this.persistenceType == 2) {
            server.core.clientContext.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    container.activate((Object)ClientRequest.this, 1);
                    try {
                        ClientRequest.this.restart(container, context);
                    }
                    catch (DatabaseDisabledException databaseDisabledException) {
                        // empty catch block
                    }
                    container.deactivate((Object)ClientRequest.this, 1);
                    return true;
                }
            }, 7, false);
        } else {
            server.core.getExecutor().execute(new PrioRunnable(){

                public int getPriority() {
                    return 5;
                }

                public void run() {
                    try {
                        ClientRequest.this.restart(null, server.core.clientContext);
                    }
                    catch (DatabaseDisabledException databaseDisabledException) {
                        // empty catch block
                    }
                }
            }, "Restart request");
        }
    }

    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (this.persistenceType != 2) {
            return;
        }
        if (this.uri != null) {
            this.uri.removeFrom(container);
        }
        container.delete((Object)this);
    }

    protected boolean isGlobalQueue() {
        if (this.client == null) {
            return false;
        }
        return this.client.isGlobalQueue;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to update with hash 0 => already deleted!", new Exception("error"));
            return false;
        }
        return true;
    }

    public boolean objectCanNew(ObjectContainer container) {
        if (this.persistenceType != 2) {
            Logger.error(this, "Not storing non-persistent request in database", new Exception("error"));
            return false;
        }
        if (this.hashCode == 0) {
            Logger.error(this, "Trying to write with hash 0 => already deleted!", new Exception("error"));
            return false;
        }
        return true;
    }

    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

