/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.DataCarryingMessage;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Fields;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class ClientPutMessage
extends DataCarryingMessage {
    public static final String NAME = "ClientPut";
    final FreenetURI uri;
    final String contentType;
    final long dataLength;
    final String identifier;
    final int verbosity;
    final int maxRetries;
    final boolean getCHKOnly;
    final short priorityClass;
    final short persistenceType;
    final short uploadFromType;
    final String fileHash;
    final boolean dontCompress;
    final String clientToken;
    final File origFilename;
    final boolean global;
    final FreenetURI redirectTarget;
    final String targetFilename;
    final boolean earlyEncode;
    final boolean binaryBlob;
    public static final short UPLOAD_FROM_DIRECT = 0;
    public static final short UPLOAD_FROM_DISK = 1;
    public static final short UPLOAD_FROM_REDIRECT = 2;

    public ClientPutMessage(SimpleFieldSet fs) throws MessageInvalidException {
        Object f;
        Object fnam = null;
        this.identifier = fs.get("Identifier");
        this.binaryBlob = fs.getBoolean("BinaryBlob", false);
        this.global = Fields.stringToBool(fs.get("Global"), false);
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            if (this.binaryBlob) {
                this.uri = new FreenetURI("CHK@");
            } else {
                String u = fs.get("URI");
                if (u == null) {
                    throw new MessageInvalidException(5, "No URI", this.identifier, this.global);
                }
                FreenetURI uu = new FreenetURI(fs.get("URI"));
                String[] metas = uu.getAllMetaStrings();
                if (metas != null && metas.length == 1) {
                    fnam = metas[0];
                    uu = uu.setMetaString(null);
                }
                this.uri = uu;
            }
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.contentType = fs.get("Metadata.ContentType");
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.getCHKOnly = Fields.stringToBool(fs.get("GetCHKOnly"), false);
        String priorityString = fs.get("PriorityClass");
        if (priorityString == null) {
            this.priorityClass = (short)2;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString, 10);
                if (this.priorityClass < 0 || this.priorityClass > 6) {
                    throw new MessageInvalidException(8, "Valid priorities are from 0 to 6", this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.fileHash = fs.get("FileHash");
        String uploadFrom = fs.get("UploadFrom");
        if (uploadFrom == null || uploadFrom.equalsIgnoreCase("direct")) {
            this.uploadFromType = 0;
            String dataLengthString = fs.get("DataLength");
            if (dataLengthString == null) {
                throw new MessageInvalidException(5, "Need DataLength on a ClientPut", this.identifier, this.global);
            }
            try {
                this.dataLength = Long.parseLong(dataLengthString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing DataLength field: " + e.getMessage(), this.identifier, this.global);
            }
            this.origFilename = null;
            this.redirectTarget = null;
        } else if (uploadFrom.equalsIgnoreCase("disk")) {
            this.uploadFromType = 1;
            String filename = fs.get("Filename");
            if (filename == null) {
                throw new MessageInvalidException(5, "Missing field Filename", this.identifier, this.global);
            }
            f = new File(filename);
            if (!(((File)f).exists() && ((File)f).isFile() && ((File)f).canRead())) {
                throw new MessageInvalidException(9, null, this.identifier, this.global);
            }
            this.dataLength = ((File)f).length();
            FileBucket fileBucket = new FileBucket((File)f, true, false, false, false, false);
            this.bucket = fileBucket;
            this.origFilename = f;
            this.redirectTarget = null;
            if (fnam == null) {
                fnam = this.origFilename.getName();
            }
        } else if (uploadFrom.equalsIgnoreCase("redirect")) {
            this.uploadFromType = (short)2;
            String target = fs.get("TargetURI");
            if (target == null) {
                throw new MessageInvalidException(5, "TargetURI missing but UploadFrom=redirect", this.identifier, this.global);
            }
            try {
                this.redirectTarget = new FreenetURI(target);
            }
            catch (MalformedURLException e) {
                throw new MessageInvalidException(8, "Invalid TargetURI: " + e, this.identifier, this.global);
            }
            this.dataLength = 0L;
            this.origFilename = null;
            this.bucket = null;
        } else {
            throw new MessageInvalidException(8, "UploadFrom invalid or unrecognized: " + uploadFrom, this.identifier, this.global);
        }
        this.dontCompress = Fields.stringToBool(fs.get("DontCompress"), false);
        String persistenceString = fs.get("Persistence");
        if (persistenceString == null || persistenceString.equalsIgnoreCase("connection")) {
            this.persistenceType = 0;
        } else if (persistenceString.equalsIgnoreCase("reboot")) {
            this.persistenceType = 1;
        } else if (persistenceString.equalsIgnoreCase("forever")) {
            this.persistenceType = (short)2;
        } else {
            throw new MessageInvalidException(6, "Error parsing Persistence field: " + persistenceString, this.identifier, this.global);
        }
        this.clientToken = fs.get("ClientToken");
        f = fs.get("TargetFilename");
        if (f != null) {
            fnam = f;
        }
        if (fnam != null && ((String)fnam).indexOf(47) > -1) {
            throw new MessageInvalidException(8, "TargetFilename must not contain slashes", this.identifier, this.global);
        }
        if (fnam != null && ((String)fnam).length() == 0) {
            fnam = null;
        }
        this.targetFilename = this.uri.getKeyType().equals("CHK") ? fnam : null;
        this.earlyEncode = Fields.stringToBool(fs.get("EarlyEncode"), false);
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("URI", this.uri.toString());
        sfs.putSingle("Identifier", this.identifier);
        sfs.putSingle("Verbosity", Integer.toString(this.verbosity));
        sfs.putSingle("MaxRetries", Integer.toString(this.maxRetries));
        sfs.putSingle("Metadata.ContentType", this.contentType);
        sfs.putSingle("ClientToken", this.clientToken);
        if (this.uploadFromType == 0) {
            sfs.putSingle("UploadFrom", "direct");
            sfs.putSingle("DataLength", Long.toString(this.dataLength));
        } else if (this.uploadFromType == 1) {
            sfs.putSingle("UploadFrom", "disk");
            sfs.putSingle("Filename", this.origFilename.getAbsolutePath());
            sfs.putSingle("DataLength", Long.toString(this.dataLength));
        } else if (this.uploadFromType == 2) {
            sfs.putSingle("UploadFrom", "redirect");
            sfs.putSingle("TargetURI", this.redirectTarget.toString());
        }
        sfs.putSingle("GetCHKOnly", Boolean.toString(this.getCHKOnly));
        sfs.putSingle("PriorityClass", Short.toString(this.priorityClass));
        sfs.putSingle("PersistenceType", ClientRequest.persistenceTypeString(this.persistenceType));
        sfs.putSingle("DontCompress", Boolean.toString(this.dontCompress));
        sfs.putSingle("Global", Boolean.toString(this.global));
        sfs.put("BinaryBlob", this.binaryBlob);
        return sfs;
    }

    public String getName() {
        return NAME;
    }

    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        handler.startClientPut(this);
    }

    long dataLength() {
        if (this.uploadFromType == 0) {
            return this.dataLength;
        }
        return -1L;
    }

    String getIdentifier() {
        return this.identifier;
    }

    Bucket createBucket(BucketFactory bf, long length, FCPServer server) throws IOException {
        if (this.persistenceType == 2) {
            return server.core.persistentTempBucketFactory.makeBucket(length);
        }
        return super.createBucket(bf, length, server);
    }

    public static String uploadFromString(short uploadFrom) {
        switch (uploadFrom) {
            case 0: {
                return "direct";
            }
            case 1: {
                return "disk";
            }
            case 2: {
                return "redirect";
            }
        }
        throw new IllegalArgumentException();
    }

    boolean isGlobal() {
        return this.global;
    }

    public void removeFrom(ObjectContainer container) {
        this.uri.removeFrom(container);
        container.delete((Object)this.origFilename);
        if (this.redirectTarget != null) {
            this.redirectTarget.removeFrom(container);
        }
    }

    public void freeData(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.bucket, 5);
        }
        this.bucket.free();
        if (this.persistenceType == 2) {
            this.bucket.removeFrom(container);
        }
    }
}

