/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import freenet.keys.FreenetURI;
import freenet.node.fcp.BaseDataCarryingMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Fields;
import freenet.support.SimpleFieldSet;
import java.net.MalformedURLException;

public abstract class ClientPutDirMessage
extends BaseDataCarryingMessage {
    final String identifier;
    final FreenetURI uri;
    final int verbosity;
    final int maxRetries;
    final boolean getCHKOnly;
    final short priorityClass;
    final short persistenceType;
    final boolean dontCompress;
    final String clientToken;
    final boolean global;
    final String defaultName;
    final boolean earlyEncode;

    public ClientPutDirMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        this.global = Fields.stringToBool(fs.get("Global"), false);
        this.defaultName = fs.get("DefaultName");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier", null, this.global);
        }
        try {
            String u = fs.get("URI");
            if (u == null) {
                throw new MessageInvalidException(5, "No URI", this.identifier, this.global);
            }
            FreenetURI uu = new FreenetURI(fs.get("URI"));
            String[] meta = uu.getAllMetaStrings();
            if (meta != null && meta.length == 1 && meta[0].length() == 0) {
                uu = uu.setMetaString(null);
            }
            this.uri = uu;
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, this.global);
        }
        String verbosityString = fs.get("Verbosity");
        if (verbosityString == null) {
            this.verbosity = 0;
        } else {
            try {
                this.verbosity = Integer.parseInt(verbosityString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing Verbosity field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        String maxRetriesString = fs.get("MaxRetries");
        if (maxRetriesString == null) {
            this.maxRetries = 0;
        } else {
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing MaxSize field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.getCHKOnly = Fields.stringToBool(fs.get("GetCHKOnly"), false);
        String priorityString = fs.get("PriorityClass");
        if (priorityString == null) {
            this.priorityClass = (short)2;
        } else {
            try {
                this.priorityClass = Short.parseShort(priorityString, 10);
                if (this.priorityClass < 0 || this.priorityClass > 6) {
                    throw new MessageInvalidException(8, "Valid priorities are from 0 to 6", this.identifier, this.global);
                }
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing PriorityClass field: " + e.getMessage(), this.identifier, this.global);
            }
        }
        this.dontCompress = Fields.stringToBool(fs.get("DontCompress"), false);
        String persistenceString = fs.get("Persistence");
        if (persistenceString == null || persistenceString.equalsIgnoreCase("connection")) {
            this.persistenceType = 0;
        } else if (persistenceString.equalsIgnoreCase("reboot")) {
            this.persistenceType = 1;
        } else if (persistenceString.equalsIgnoreCase("forever")) {
            this.persistenceType = (short)2;
        } else {
            throw new MessageInvalidException(6, "Error parsing Persistence field: " + persistenceString, this.identifier, this.global);
        }
        this.clientToken = fs.get("ClientToken");
        this.earlyEncode = Fields.stringToBool(fs.get("EarlyEncode"), false);
    }

    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("URI", this.uri.toString());
        sfs.putSingle("Identifier", this.identifier);
        sfs.putSingle("Verbosity", Integer.toString(this.verbosity));
        sfs.putSingle("MaxRetries", Integer.toString(this.maxRetries));
        sfs.putSingle("ClientToken", this.clientToken);
        sfs.putSingle("GetCHKOnly", Boolean.toString(this.getCHKOnly));
        sfs.putSingle("PriorityClass", Short.toString(this.priorityClass));
        sfs.putSingle("PersistenceType", ClientRequest.persistenceTypeString(this.persistenceType));
        sfs.putSingle("DontCompress", Boolean.toString(this.dontCompress));
        sfs.putSingle("Global", Boolean.toString(this.global));
        sfs.putSingle("DefaultName", this.defaultName);
        return sfs;
    }
}

