/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.ManifestElement;
import freenet.client.async.SimpleManifestPutter;
import freenet.keys.FreenetURI;
import freenet.node.fcp.ClientPutBase;
import freenet.node.fcp.ClientPutDirMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.PersistenceParseException;
import freenet.node.fcp.PersistentPutDir;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.FileBucket;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.SerializableToFieldSetBucketUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPutDir
extends ClientPutBase {
    private HashMap<String, Object> manifestElements;
    private SimpleManifestPutter putter;
    private final String defaultName;
    private final long totalSize;
    private final int numberOfFiles;
    private final boolean wasDiskPut;
    private static volatile boolean logMINOR;

    public ClientPutDir(FCPConnectionHandler handler, ClientPutDirMessage message, HashMap<String, Object> manifestElements, boolean wasDiskPut, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MalformedURLException {
        super(message.uri, message.identifier, message.verbosity, handler, message.priorityClass, message.persistenceType, message.clientToken, message.global, message.getCHKOnly, message.dontCompress, message.maxRetries, message.earlyEncode, server, container);
        logMINOR = Logger.shouldLog(4, this);
        this.wasDiskPut = wasDiskPut;
        this.manifestElements = new HashMap();
        this.manifestElements.putAll(manifestElements);
        this.defaultName = message.defaultName;
        this.makePutter();
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting dir " + this.identifier + " : " + this.priorityClass);
        }
    }

    public ClientPutDir(FCPClient client, FreenetURI uri, String identifier, int verbosity, short priorityClass, short persistenceType, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, File dir, String defaultName, boolean allowUnreadableFiles, boolean global, boolean earlyEncode, FCPServer server, ObjectContainer container) throws FileNotFoundException, IdentifierCollisionException, MalformedURLException {
        super(uri, identifier, verbosity, null, client, priorityClass, persistenceType, clientToken, global, getCHKOnly, dontCompress, maxRetries, earlyEncode, server, container);
        this.wasDiskPut = true;
        logMINOR = Logger.shouldLog(4, this);
        this.manifestElements = this.makeDiskDirManifest(dir, "", allowUnreadableFiles);
        this.defaultName = defaultName;
        this.makePutter();
        if (this.putter != null) {
            this.numberOfFiles = this.putter.countFiles();
            this.totalSize = this.putter.totalSize();
        } else {
            this.numberOfFiles = -1;
            this.totalSize = -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "Putting dir " + identifier + " : " + priorityClass);
        }
    }

    @Override
    void register(ObjectContainer container, boolean lazyResume, boolean noTags) throws IdentifierCollisionException {
        if (this.persistenceType != 0) {
            this.client.register(this, false, container);
        }
        if (this.persistenceType != 0 && !noTags) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    private HashMap<String, Object> makeDiskDirManifest(File dir, String prefix, boolean allowUnreadableFiles) throws FileNotFoundException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("No such directory");
        }
        for (File f : files) {
            if (f.exists() && f.canRead()) {
                if (f.isFile()) {
                    FileBucket bucket = new FileBucket(f, true, false, false, false, false);
                    if (logMINOR) {
                        Logger.minor(this, "Add file : " + f.getAbsolutePath());
                    }
                    map.put(f.getName(), new ManifestElement(f.getName(), prefix + f.getName(), bucket, DefaultMIMETypes.guessMIMEType(f.getName(), true), f.length()));
                    continue;
                }
                if (f.isDirectory()) {
                    if (logMINOR) {
                        Logger.minor(this, "Add dir : " + f.getAbsolutePath());
                    }
                    map.put(f.getName(), this.makeDiskDirManifest(f, prefix + f.getName() + "/", allowUnreadableFiles));
                    continue;
                }
                if (allowUnreadableFiles) continue;
                throw new FileNotFoundException("Not a file and not a directory : " + f);
            }
            if (allowUnreadableFiles) continue;
            throw new FileNotFoundException("The file does not exist or is unreadable : " + f);
        }
        return map;
    }

    private void makePutter() {
        SimpleManifestPutter p;
        this.putter = p = new SimpleManifestPutter(this, this.manifestElements, this.priorityClass, this.uri, this.defaultName, this.ctx, this.getCHKOnly, this.lowLevelClient, this.earlyEncode);
    }

    public ClientPutDir(SimpleFieldSet fs, FCPClient client, FCPServer server, ObjectContainer container) throws PersistenceParseException, IOException {
        super(fs, client, server);
        String num;
        SimpleFieldSet subset;
        logMINOR = Logger.shouldLog(4, this);
        SimpleFieldSet files = fs.subset("Files");
        this.defaultName = fs.get("DefaultName");
        String type = fs.get("PutDirType");
        this.wasDiskPut = type.equals("disk");
        int fileCount = 0;
        long size = 0L;
        Vector<ManifestElement> v = new Vector<ManifestElement>();
        int i = 0;
        while ((subset = files.subset(num = Integer.toString(i))) != null) {
            ManifestElement me;
            String name = subset.get("Name");
            if (name == null) {
                throw new PersistenceParseException("No Name on " + i);
            }
            String contentTypeOverride = subset.get("Metadata.ContentType");
            String uploadFrom = subset.get("UploadFrom");
            Bucket data = null;
            if (logMINOR) {
                Logger.minor(this, "Parsing " + i);
            }
            if (logMINOR) {
                Logger.minor(this, "UploadFrom=" + uploadFrom);
            }
            if (uploadFrom == null || uploadFrom.equalsIgnoreCase("direct")) {
                long sz = Long.parseLong(subset.get("DataLength"));
                if (!this.finished) {
                    try {
                        data = SerializableToFieldSetBucketUtil.create(fs.subset("ReturnBucket"), server.core.random, server.core.persistentTempBucketFactory);
                    }
                    catch (CannotCreateFromFieldSetException e) {
                        throw new PersistenceParseException("Could not read old bucket for " + this.identifier + " : " + e, e);
                    }
                } else {
                    data = null;
                }
                me = new ManifestElement(name, data, contentTypeOverride, sz);
                ++fileCount;
            } else if (uploadFrom.equalsIgnoreCase("disk")) {
                long sz = Long.parseLong(subset.get("DataLength"));
                String f = subset.get("Filename");
                if (f == null) {
                    throw new PersistenceParseException("UploadFrom=disk but no name on " + i);
                }
                File ff = new File(f);
                if (!ff.exists() || !ff.canRead()) {
                    Logger.error(this, "File no longer exists, cancelling upload: " + ff);
                    throw new IOException("File no longer exists, cancelling upload: " + ff);
                }
                data = new FileBucket(ff, true, false, false, false, false);
                me = new ManifestElement(name, data, contentTypeOverride, sz);
                ++fileCount;
            } else if (uploadFrom.equalsIgnoreCase("redirect")) {
                FreenetURI targetURI = new FreenetURI(subset.get("TargetURI"));
                me = new ManifestElement(name, targetURI, contentTypeOverride);
            } else {
                throw new PersistenceParseException("Don't know UploadFrom=" + uploadFrom);
            }
            v.add(me);
            if (data != null && data.size() > 0L) {
                size += data.size();
            }
            ++i;
        }
        this.manifestElements = SimpleManifestPutter.unflatten(v);
        SimpleManifestPutter p = null;
        if (!this.finished) {
            p = new SimpleManifestPutter(this, this.manifestElements, this.priorityClass, this.uri, this.defaultName, this.ctx, this.getCHKOnly, this.lowLevelClient, this.earlyEncode);
        }
        this.putter = p;
        this.numberOfFiles = fileCount;
        this.totalSize = size;
        if (this.persistenceType != 0) {
            FCPMessage msg = this.persistentTagMessage(container);
            client.queueClientRequestMessage(msg, 0, container);
        }
    }

    @Override
    public void start(ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return;
        }
        if (this.started) {
            return;
        }
        try {
            if (this.putter != null) {
                this.putter.start(container, context);
            }
            this.started = true;
            if (logMINOR) {
                Logger.minor(this, "Started " + this.putter + " for " + this + " persistence=" + this.persistenceType);
            }
            if (this.persistenceType != 0 && !this.finished) {
                FCPMessage msg = this.persistentTagMessage(container);
                this.client.queueClientRequestMessage(msg, 0, container);
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
        }
        catch (InsertException e) {
            this.started = true;
            this.onFailure(e, null, container);
        }
    }

    @Override
    public void onLostConnection(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 0) {
            this.cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "freeData() on " + this + " persistence type = " + this.persistenceType);
        }
        ClientPutDir clientPutDir = this;
        synchronized (clientPutDir) {
            if (this.manifestElements == null) {
                if (logMINOR) {
                    Logger.minor(this, "manifestElements = " + this.manifestElements + (this.persistenceType != 2 ? "" : " dir.active=" + container.ext().isActive((Object)this)), (Throwable)new Exception("error"));
                }
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "freeData() more on " + this + " persistence type = " + this.persistenceType);
        }
        if (this.persistenceType == 2) {
            container.deactivate(this.manifestElements, 1);
            container.activate(this.manifestElements, Integer.MAX_VALUE);
        }
        this.freeData(this.manifestElements, container);
        this.manifestElements = null;
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    private void freeData(HashMap<String, Object> manifestElements, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "freeData() inner on " + this + " persistence type = " + this.persistenceType + " size = " + manifestElements.size());
        }
        for (Object o : manifestElements.values()) {
            if (o instanceof HashMap) {
                this.freeData((HashMap)o, container);
                continue;
            }
            ManifestElement e = (ManifestElement)o;
            if (logMINOR) {
                Logger.minor(this, "Freeing " + e);
            }
            e.freeData(container, this.persistenceType == 2);
        }
        if (this.persistenceType == 2) {
            container.delete(manifestElements);
        }
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.putter;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        SimpleFieldSet files = new SimpleFieldSet(false);
        ManifestElement[] elements = SimpleManifestPutter.flatten(this.manifestElements);
        fs.putSingle("DefaultName", this.defaultName);
        fs.putSingle("PutDirType", this.wasDiskPut ? "disk" : "complex");
        for (int i = 0; i < elements.length; ++i) {
            FreenetURI target;
            String num = Integer.toString(i);
            ManifestElement e = elements[i];
            String name = e.getName();
            String mimeOverride = e.getMimeTypeOverride();
            SimpleFieldSet subset = new SimpleFieldSet(false);
            subset.putSingle("Name", name);
            if (mimeOverride != null) {
                subset.putSingle("Metadata.ContentType", mimeOverride);
            }
            if ((target = e.getTargetURI()) != null) {
                subset.putSingle("UploadFrom", "redirect");
                subset.putSingle("TargetURI", target.toString());
            } else {
                Bucket data = e.getData();
                subset.putSingle("DataLength", Long.toString(e.getSize()));
                if (data instanceof FileBucket) {
                    subset.putSingle("UploadFrom", "disk");
                    subset.putSingle("Filename", ((FileBucket)data).getFile().getPath());
                } else if (this.finished) {
                    subset.putSingle("UploadFrom", "direct");
                } else if (data instanceof PaddedEphemerallyEncryptedBucket) {
                    subset.putSingle("UploadFrom", "direct");
                    this.bucketToFS(fs, "TempBucket", false, data);
                } else {
                    throw new IllegalStateException("Don't know what to do with bucket: " + data);
                }
            }
            files.put(num, subset);
        }
        fs.put("Files", files);
        return fs;
    }

    @Override
    protected FCPMessage persistentTagMessage(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.publicURI, 5);
            container.activate((Object)this.ctx, 1);
            container.activate(this.manifestElements, 5);
        }
        return new PersistentPutDir(this.identifier, this.publicURI, this.verbosity, this.priorityClass, this.persistenceType, this.global, this.defaultName, this.manifestElements, this.clientToken, this.started, this.ctx.maxInsertRetries, this.wasDiskPut, container);
    }

    @Override
    protected String getTypeName() {
        return "PUTDIR";
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public FreenetURI getFinalURI(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.generatedURI, 5);
        }
        return this.generatedURI;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public long getTotalDataSize() {
        return this.totalSize;
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return true;
    }

    @Override
    public boolean restart(ObjectContainer container, ClientContext context) {
        if (!this.canRestart()) {
            return false;
        }
        this.setVarsRestart(container);
        this.makePutter();
        this.start(container, context);
        return true;
    }

    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
    }

    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
    }

    @Override
    public void onSuccess(BaseClientPutter state, ObjectContainer container) {
        super.onSuccess(state, container);
    }

    @Override
    public void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
        super.onFailure(e, state, container);
    }

    @Override
    public void onRemoveEventProducer(ObjectContainer container) {
    }

    @Override
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.putter, 1);
            this.putter.removeFrom(container, context);
            this.putter = null;
        }
        super.requestWasRemoved(container, context);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

