/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.async.ManifestElement;
import freenet.node.Node;
import freenet.node.fcp.ClientPutDirMessage;
import freenet.node.fcp.DirPutFile;
import freenet.node.fcp.DirectDirPutFile;
import freenet.node.fcp.DiskDirPutFile;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.MessageInvalidException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.io.PersistentTempBucketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPutComplexDirMessage
extends ClientPutDirMessage {
    private final HashMap<String, Object> filesByName = new HashMap();
    private final LinkedList<DirPutFile> filesToRead = new LinkedList();
    private final long attachedBytes;
    static final String NAME = "ClientPutComplexDir";

    public ClientPutComplexDirMessage(SimpleFieldSet fs, BucketFactory bfTemp, PersistentTempBucketFactory bfPersistent) throws MessageInvalidException {
        super(fs);
        SimpleFieldSet subset;
        long totalBytes = 0L;
        SimpleFieldSet files = fs.subset("Files");
        if (files == null) {
            throw new MessageInvalidException(5, "Missing Files section", this.identifier, this.global);
        }
        boolean logMINOR = Logger.shouldLog(4, this);
        int i = 0;
        while ((subset = files.subset(Integer.toString(i))) != null) {
            DirPutFile f = DirPutFile.create(subset, this.identifier, this.global, this.persistenceType == 2 ? bfPersistent : bfTemp);
            this.addFile(f);
            if (logMINOR) {
                Logger.minor(this, "Adding " + f);
            }
            if (f instanceof DirectDirPutFile) {
                totalBytes += ((DirectDirPutFile)f).bytesToRead();
                this.filesToRead.addLast(f);
                if (logMINOR) {
                    Logger.minor(this, "totalBytes now " + totalBytes);
                }
            }
            ++i;
        }
        this.attachedBytes = totalBytes;
    }

    private void addFile(DirPutFile f) throws MessageInvalidException {
        this.addFile(this.filesByName, f.getName(), f);
    }

    private void addFile(HashMap<String, Object> byName, String name, DirPutFile f) throws MessageInvalidException {
        int idx = name.indexOf(47);
        if (idx == -1) {
            byName.put(name, f);
        } else {
            String before = name.substring(0, idx);
            String after = name.substring(idx + 1);
            HashMap<String, Object> o = byName.get(before);
            if (o != null) {
                if (o instanceof HashMap) {
                    this.addFile(o, after, f);
                    return;
                }
                throw new MessageInvalidException(7, "Cannot be both a file and a directory: " + before, this.identifier, this.global);
            }
            o = new HashMap<String, Object>();
            byName.put(before, o);
            this.addFile(o, after, f);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    long dataLength() {
        return this.attachedBytes;
    }

    String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void readFrom(InputStream is, BucketFactory bf, FCPServer server) throws IOException, MessageInvalidException {
        for (DirectDirPutFile directDirPutFile : this.filesToRead) {
            directDirPutFile.read(is);
        }
    }

    @Override
    protected void writeData(OutputStream os) throws IOException {
        for (DirectDirPutFile directDirPutFile : this.filesToRead) {
            directDirPutFile.write(os);
        }
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        HashMap<String, Object> manifestElements = new HashMap<String, Object>();
        this.convertFilesByNameToManifestElements(this.filesByName, manifestElements, node);
        handler.startClientPutDir(this, manifestElements, false);
    }

    private void convertFilesByNameToManifestElements(HashMap<String, Object> filesByName, HashMap<String, Object> manifestElements, Node node) throws MessageInvalidException {
        for (Map.Entry<String, Object> entry : filesByName.entrySet()) {
            String tempName = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof HashMap) {
                HashMap h = (HashMap)val;
                HashMap<String, Object> manifests = new HashMap<String, Object>();
                manifestElements.put(tempName, manifests);
                this.convertFilesByNameToManifestElements(h, manifests, node);
                continue;
            }
            DirPutFile f = (DirPutFile)val;
            if (f instanceof DiskDirPutFile && !node.clientCore.allowUploadFrom(((DiskDirPutFile)f).getFile())) {
                throw new MessageInvalidException(24, "Not allowed to upload " + ((DiskDirPutFile)f).getFile(), this.identifier, this.global);
            }
            ManifestElement e = f.getElement();
            manifestElements.put(tempName, e);
        }
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        this.filesToRead.clear();
        container.activate(this.filesByName, Integer.MAX_VALUE);
        this.removeFrom(container, this.filesByName);
        container.delete((Object)this);
    }

    private void removeFrom(ObjectContainer container, HashMap filesByName) {
        for (Object val : filesByName.values()) {
            if (val instanceof HashMap) {
                this.removeFrom(container, (HashMap)val);
                continue;
            }
            ((DirPutFile)val).removeFrom(container);
        }
        container.delete((Object)filesByName);
    }
}

