/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.FinishedCompressionEvent;
import freenet.client.events.SimpleEventProducer;
import freenet.client.events.SplitfileProgressEvent;
import freenet.client.events.StartedCompressionEvent;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.FinishedCompressionMessage;
import freenet.node.fcp.PersistentRequestRemovedMessage;
import freenet.node.fcp.PutFailedMessage;
import freenet.node.fcp.PutFetchableMessage;
import freenet.node.fcp.PutSuccessfulMessage;
import freenet.node.fcp.SimpleProgressMessage;
import freenet.node.fcp.StartedCompressionMessage;
import freenet.node.fcp.URIGeneratedMessage;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.net.MalformedURLException;

public abstract class ClientPutBase
extends ClientRequest
implements ClientPutCallback,
ClientEventListener {
    final InsertContext ctx;
    final boolean getCHKOnly;
    private static final int VERBOSITY_SPLITFILE_PROGRESS = 1;
    private static final int VERBOSITY_PUT_FETCHABLE = 256;
    private static final int VERBOSITY_COMPRESSION_START_END = 512;
    protected boolean succeeded;
    private PutFailedMessage putFailedMessage;
    protected FreenetURI generatedURI;
    private FCPMessage progressMessage;
    protected final boolean earlyEncode;
    protected final FreenetURI publicURI;
    public static final String SALT = "Salt";
    public static final String FILE_HASH = "FileHash";

    public ClientPutBase(FreenetURI uri, String identifier, int verbosity, FCPConnectionHandler handler, short priorityClass, short persistenceType, String clientToken, boolean global, boolean getCHKOnly, boolean dontCompress, int maxRetries, boolean earlyEncode, FCPServer server, ObjectContainer container) throws MalformedURLException {
        super(uri, identifier, verbosity, handler, priorityClass, persistenceType, clientToken, global, container);
        this.getCHKOnly = getCHKOnly;
        this.ctx = new InsertContext(server.defaultInsertContext, new SimpleEventProducer());
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        this.earlyEncode = earlyEncode;
        this.publicURI = this.getPublicURI(uri);
    }

    public ClientPutBase(FreenetURI uri, String identifier, int verbosity, FCPConnectionHandler handler, FCPClient client, short priorityClass, short persistenceType, String clientToken, boolean global, boolean getCHKOnly, boolean dontCompress, int maxRetries, boolean earlyEncode, FCPServer server, ObjectContainer container) throws MalformedURLException {
        super(uri, identifier, verbosity, handler, client, priorityClass, persistenceType, clientToken, global, container);
        this.getCHKOnly = getCHKOnly;
        this.ctx = new InsertContext(server.defaultInsertContext, new SimpleEventProducer());
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        this.earlyEncode = earlyEncode;
        this.publicURI = this.getPublicURI(uri);
    }

    public ClientPutBase(SimpleFieldSet fs, FCPClient client2, FCPServer server) throws MalformedURLException {
        super(fs, client2);
        this.publicURI = this.getPublicURI(this.uri);
        this.getCHKOnly = Fields.stringToBool(fs.get("CHKOnly"), false);
        boolean dontCompress = Fields.stringToBool(fs.get("DontCompress"), false);
        int maxRetries = Integer.parseInt(fs.get("MaxRetries"));
        this.clientToken = fs.get("ClientToken");
        this.finished = Fields.stringToBool(fs.get("Finished"), false);
        this.succeeded = Fields.stringToBool(fs.get("Succeeded"), false);
        this.ctx = new InsertContext(server.defaultInsertContext, new SimpleEventProducer());
        this.ctx.dontCompress = dontCompress;
        this.ctx.eventProducer.addEventListener(this);
        this.ctx.maxInsertRetries = maxRetries;
        String genURI = fs.get("GeneratedURI");
        if (genURI != null) {
            this.generatedURI = new FreenetURI(genURI);
        }
        if (this.finished) {
            String ctime = fs.get("CompletionTime");
            if (ctime != null) {
                this.completionTime = Long.parseLong(ctime);
            }
            if (!this.succeeded) {
                this.putFailedMessage = new PutFailedMessage(fs.subset("PutFailed"), false);
            }
        }
        this.earlyEncode = Fields.stringToBool(fs.get("EarlyEncode"), false);
    }

    private FreenetURI getPublicURI(FreenetURI uri) throws MalformedURLException {
        String type = uri.getKeyType();
        if (type.equalsIgnoreCase("CHK")) {
            return uri;
        }
        if (type.equalsIgnoreCase("SSK") || type.equalsIgnoreCase("USK")) {
            if (type.equalsIgnoreCase("USK")) {
                uri = uri.setKeyType("SSK");
            }
            InsertableClientSSK issk = InsertableClientSSK.create(uri);
            uri = uri.setRoutingKey(issk.getURI().getRoutingKey());
            uri = uri.setKeyType(type);
            return uri;
        }
        if (type.equalsIgnoreCase("KSK")) {
            return uri;
        }
        throw new IllegalArgumentException();
    }

    public void onLostConnection(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 0) {
            this.cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(BaseClientPutter state, ObjectContainer container) {
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.succeeded = true;
            this.finished = true;
            if (this.generatedURI == null) {
                Logger.error(this, "No generated URI in onSuccess() for " + this + " from " + state);
            }
        }
        this.finish(container);
        this.trySendFinalMessage(null, container);
        if (this.client != null) {
            this.client.notifySuccess(this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(InsertException e, BaseClientPutter state, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.finished = true;
            this.putFailedMessage = new PutFailedMessage(e, this.identifier, this.global);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
        this.finish(container);
        this.trySendFinalMessage(null, container);
        if (this.client != null) {
            this.client.notifyFailure(this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGeneratedURI(FreenetURI uri, BaseClientPutter state, ObjectContainer container) {
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            if (this.generatedURI != null) {
                if (!uri.equals(this.generatedURI)) {
                    Logger.error(this, "onGeneratedURI(" + uri + ',' + state + ") but already set generatedURI to " + this.generatedURI);
                } else if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "onGeneratedURI() twice with same value: " + this.generatedURI + " -> " + uri);
                }
            } else {
                this.generatedURI = uri;
            }
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
        this.trySendGeneratedURIMessage(null, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (!this.finished) {
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                this.finished = true;
                InsertException cancelled = new InsertException(10);
                this.putFailedMessage = new PutFailedMessage(cancelled, this.identifier, this.global);
            }
            this.trySendFinalMessage(null, container);
        }
        PersistentRequestRemovedMessage msg = new PersistentRequestRemovedMessage(this.getIdentifier(), this.global);
        if (this.persistenceType == 0) {
            this.origHandler.outputHandler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
        this.freeData(container);
        if (this.persistenceType == 2) {
            FCPMessage progress;
            FreenetURI pubURI;
            FreenetURI uri;
            PutFailedMessage pfm;
            container.activate((Object)this.ctx, 2);
            this.ctx.removeFrom(container);
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                pfm = this.putFailedMessage;
                this.putFailedMessage = null;
                uri = this.generatedURI;
                this.generatedURI = null;
                pubURI = this.publicURI;
                progress = this.progressMessage;
                this.progressMessage = null;
            }
            if (pfm != null) {
                container.activate((Object)pfm, 5);
                pfm.removeFrom(container);
            }
            if (uri != null) {
                container.activate((Object)uri, 5);
                uri.removeFrom(container);
            }
            if (progress != null) {
                container.activate((Object)progress, 1);
                progress.removeFrom(container);
            }
            if (pubURI != null) {
                container.activate((Object)pubURI, 5);
                pubURI.removeFrom(container);
            }
        }
        super.requestWasRemoved(container, context);
    }

    public void receive(final ClientEvent ce, ObjectContainer container, ClientContext context) {
        if (this.finished) {
            return;
        }
        if (this.persistenceType == 2 && container == null) {
            try {
                context.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        container.activate((Object)ClientPutBase.this, 1);
                        ClientPutBase.this.receive(ce, container, context);
                        container.deactivate((Object)ClientPutBase.this, 1);
                        return false;
                    }
                }, 5, false);
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
            return;
        }
        if (ce instanceof SplitfileProgressEvent) {
            if ((this.verbosity & 1) == 1) {
                SimpleProgressMessage progress = new SimpleProgressMessage(this.identifier, this.global, (SplitfileProgressEvent)ce);
                this.trySendProgressMessage(progress, 1, null, container, context);
            }
        } else if (ce instanceof StartedCompressionEvent) {
            if ((this.verbosity & 0x200) == 512) {
                StartedCompressionMessage msg = new StartedCompressionMessage(this.identifier, this.global, ((StartedCompressionEvent)ce).codec);
                this.trySendProgressMessage(msg, 512, null, container, context);
            }
        } else if (ce instanceof FinishedCompressionEvent && (this.verbosity & 0x200) == 512) {
            FinishedCompressionMessage msg = new FinishedCompressionMessage(this.identifier, this.global, (FinishedCompressionEvent)ce);
            this.trySendProgressMessage(msg, 512, null, container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchable(BaseClientPutter putter, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        if ((this.verbosity & 0x100) == 256) {
            FreenetURI temp;
            ClientPutBase clientPutBase = this;
            synchronized (clientPutBase) {
                temp = this.generatedURI;
            }
            PutFetchableMessage msg = new PutFetchableMessage(this.identifier, this.global, temp);
            this.trySendProgressMessage(msg, 256, null, container, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendFinalMessage(FCPConnectionOutputHandler handler, ObjectContainer container) {
        FCPMessage msg;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            FreenetURI uri = this.generatedURI;
            if (this.persistenceType == 2 && uri != null) {
                container.activate((Object)uri, 5);
                uri = uri.clone();
            }
            msg = this.succeeded ? new PutSuccessfulMessage(this.identifier, this.global, uri, this.startupTime, this.completionTime) : this.putFailedMessage;
        }
        if (msg == null) {
            Logger.error(this, "Trying to send null message on " + this, new Exception("error"));
        } else {
            if (this.persistenceType == 0 && handler == null) {
                handler = this.origHandler.outputHandler;
            }
            if (handler != null) {
                handler.queue(msg);
            } else {
                this.client.queueClientRequestMessage(msg, 0, container);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendGeneratedURIMessage(FCPConnectionOutputHandler handler, ObjectContainer container) {
        URIGeneratedMessage msg;
        if (this.persistenceType == 2) {
            container.activate((Object)this.client, 1);
            container.activate((Object)this.generatedURI, 5);
        }
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            msg = new URIGeneratedMessage(this.generatedURI, this.identifier, this.isGlobalQueue());
        }
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void trySendProgressMessage(final FCPMessage msg, final int verbosity, FCPConnectionOutputHandler handler, ObjectContainer container, ClientContext context) {
        block14: {
            if (this.persistenceType == 2) {
                if (container != null) {
                    FCPMessage oldProgress = null;
                    ClientPutBase clientPutBase = this;
                    // MONITORENTER : clientPutBase
                    if (this.persistenceType != 0) {
                        oldProgress = this.progressMessage;
                        this.progressMessage = msg;
                    }
                    // MONITOREXIT : clientPutBase
                    if (oldProgress != null) {
                        container.activate((Object)oldProgress, 1);
                        oldProgress.removeFrom(container);
                    }
                    container.store((Object)this);
                    break block14;
                } else {
                    final FCPConnectionOutputHandler h = handler;
                    try {
                        context.jobRunner.queue(new DBJob(){

                            public boolean run(ObjectContainer container, ClientContext context) {
                                container.activate((Object)ClientPutBase.this, 1);
                                ClientPutBase.this.trySendProgressMessage(msg, verbosity, h, container, context);
                                container.deactivate((Object)ClientPutBase.this, 1);
                                return false;
                            }
                        }, 5, false);
                        return;
                    }
                    catch (DatabaseDisabledException e) {
                        // empty catch block
                    }
                    return;
                }
            }
            ClientPutBase clientPutBase = this;
            // MONITORENTER : clientPutBase
            if (this.persistenceType != 0) {
                this.progressMessage = msg;
            }
            // MONITOREXIT : clientPutBase
        }
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
            return;
        }
        this.client.queueClientRequestMessage(msg, verbosity, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPendingMessages(FCPConnectionOutputHandler handler, boolean includePersistentRequest, boolean includeData, boolean onlyData, ObjectContainer container) {
        if (this.persistenceType == 0) {
            Logger.error(this, "WTF? persistenceType=" + this.persistenceType, new Exception("error"));
            return;
        }
        if (includePersistentRequest) {
            FCPMessage msg = this.persistentTagMessage(container);
            handler.queue(msg);
        }
        boolean generated = false;
        FCPMessage msg = null;
        boolean fin = false;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            generated = this.generatedURI != null;
            msg = this.progressMessage;
            fin = this.finished;
        }
        if (this.persistenceType == 2 && msg != null) {
            container.activate((Object)msg, 5);
        }
        if (generated) {
            this.trySendGeneratedURIMessage(handler, container);
        }
        if (msg != null) {
            handler.queue(msg);
        }
        if (fin) {
            this.trySendFinalMessage(handler, container);
        }
    }

    public synchronized SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Type", this.getTypeName());
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("Verbosity", Integer.toString(this.verbosity));
        fs.putSingle("PriorityClass", Short.toString(this.priorityClass));
        fs.putSingle("Persistence", ClientRequest.persistenceTypeString(this.persistenceType));
        fs.putSingle("ClientName", this.client.name);
        fs.putSingle("ClientToken", this.clientToken);
        fs.putSingle("DontCompress", Boolean.toString(this.ctx.dontCompress));
        fs.putSingle("MaxRetries", Integer.toString(this.ctx.maxInsertRetries));
        fs.putSingle("Finished", Boolean.toString(this.finished));
        fs.putSingle("Succeeded", Boolean.toString(this.succeeded));
        fs.putSingle("GetCHKOnly", Boolean.toString(this.getCHKOnly));
        if (this.generatedURI != null) {
            fs.putSingle("GeneratedURI", this.generatedURI.toString(false, false));
        }
        if (this.finished && !this.succeeded) {
            fs.put("PutFailed", this.putFailedMessage.getFieldSet(false));
        }
        fs.putSingle("Global", Boolean.toString(this.client.isGlobalQueue));
        fs.put("StartupTime", this.startupTime);
        if (this.finished) {
            fs.put("CompletionTime", this.completionTime);
        }
        return fs;
    }

    protected abstract String getTypeName();

    public synchronized double getSuccessFraction(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFraction();
            }
            return 0.0;
        }
        return -1.0;
    }

    public synchronized double getTotalBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getTotalBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    public synchronized double getMinBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getMinBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    public synchronized double getFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFailedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    public synchronized double getFatalyFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFatalyFailedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    public synchronized double getFetchedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressMessage != null) {
            container.activate((Object)this.progressMessage, 2);
        }
        if (this.progressMessage != null) {
            if (this.progressMessage instanceof SimpleProgressMessage) {
                return ((SimpleProgressMessage)this.progressMessage).getFetchedBlocks();
            }
            return 0.0;
        }
        return -1.0;
    }

    public synchronized boolean isTotalFinalized(ObjectContainer container) {
        if (!(this.progressMessage instanceof SimpleProgressMessage)) {
            return false;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.progressMessage, 5);
        }
        return ((SimpleProgressMessage)this.progressMessage).isTotalFinalized();
    }

    public synchronized String getFailureReason(ObjectContainer container) {
        if (this.putFailedMessage == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.putFailedMessage, 5);
        }
        String s = this.putFailedMessage.shortCodeDescription;
        if (this.putFailedMessage.extraDescription != null) {
            s = s + ": " + this.putFailedMessage.extraDescription;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVarsRestart(ObjectContainer container) {
        FCPMessage progress;
        PutFailedMessage pfm;
        ClientPutBase clientPutBase = this;
        synchronized (clientPutBase) {
            this.finished = false;
            pfm = this.putFailedMessage;
            progress = this.progressMessage;
            this.putFailedMessage = null;
            this.progressMessage = null;
            this.started = false;
        }
        if (pfm != null) {
            container.activate((Object)pfm, 1);
            pfm.removeFrom(container);
        }
        if (progress != null) {
            container.activate((Object)progress, 1);
            progress.removeFrom(container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }
}

