/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequester;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.node.fcp.ClientPutBase;
import freenet.node.fcp.ClientPutMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.PersistenceParseException;
import freenet.node.fcp.PersistentPut;
import freenet.support.Base64;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.SimpleReadOnlyArrayBucket;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.FileBucket;
import freenet.support.io.SerializableToFieldSetBucketUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Arrays;

public class ClientPut
extends ClientPutBase {
    ClientPutter putter;
    private final short uploadFrom;
    private final File origFilename;
    private final FreenetURI targetURI;
    private Bucket data;
    private final ClientMetadata clientMetadata;
    private long finishedSize;
    private final String targetFilename;
    private boolean logMINOR;
    private final boolean binaryBlob;

    public ClientPut(FCPClient globalClient, FreenetURI uri, String identifier, int verbosity, short priorityClass, short persistenceType, String clientToken, boolean getCHKOnly, boolean dontCompress, int maxRetries, short uploadFromType, File origFilename, String contentType, Bucket data, FreenetURI redirectTarget, String targetFilename, boolean earlyEncode, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, NotAllowedException, FileNotFoundException, MalformedURLException, MetadataUnresolvedException {
        super(uri, identifier, verbosity, null, globalClient, priorityClass, persistenceType, null, true, getCHKOnly, dontCompress, maxRetries, earlyEncode, server, container);
        if (uploadFromType == 1) {
            if (!server.core.allowUploadFrom(origFilename)) {
                throw new NotAllowedException();
            }
            if (!origFilename.exists() || !origFilename.canRead()) {
                throw new FileNotFoundException();
            }
        }
        this.logMINOR = Logger.shouldLog(4, this);
        this.binaryBlob = false;
        this.targetFilename = targetFilename;
        this.uploadFrom = uploadFromType;
        this.origFilename = origFilename;
        String mimeType = contentType;
        this.clientToken = clientToken;
        Bucket tempData = data;
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        this.logMINOR = Logger.shouldLog(4, this);
        if (this.logMINOR) {
            Logger.minor(this, "data = " + tempData + ", uploadFrom = " + ClientPutMessage.uploadFromString(this.uploadFrom));
        }
        if (this.uploadFrom == 2) {
            this.targetURI = redirectTarget;
            Metadata m = new Metadata(0, null, null, this.targetURI, cm);
            byte[] d = m.writeToByteArray();
            tempData = new SimpleReadOnlyArrayBucket(d);
            isMetadata = true;
        } else {
            this.targetURI = null;
        }
        this.data = tempData;
        this.clientMetadata = cm;
        this.putter = new ClientPutter(this, data, uri, cm, this.ctx, priorityClass, getCHKOnly, isMetadata, this.lowLevelClient, null, targetFilename, this.binaryBlob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientPut(FCPConnectionHandler handler, ClientPutMessage message, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MessageInvalidException, MalformedURLException {
        super(message.uri, message.identifier, message.verbosity, handler, message.priorityClass, message.persistenceType, message.clientToken, message.global, message.getCHKOnly, message.dontCompress, message.maxRetries, message.earlyEncode, server, container);
        String salt = null;
        byte[] saltedHash = null;
        this.binaryBlob = message.binaryBlob;
        if (message.uploadFromType == 1) {
            if (!handler.server.core.allowUploadFrom(message.origFilename)) {
                throw new MessageInvalidException(24, "Not allowed to upload from " + message.origFilename, this.identifier, this.global);
            }
            if (message.fileHash != null) {
                try {
                    salt = handler.connectionIdentifier + '-' + message.identifier + '-';
                    saltedHash = Base64.decode(message.fileHash);
                }
                catch (IllegalBase64Exception e) {
                    throw new MessageInvalidException(8, "Can't base64 decode FileHash", this.identifier, this.global);
                }
            } else if (!handler.allowDDAFrom(message.origFilename, false)) {
                throw new MessageInvalidException(25, "Not allowed to upload from " + message.origFilename + ". Have you done a testDDA previously ?", this.identifier, this.global);
            }
        }
        this.targetFilename = message.targetFilename;
        this.logMINOR = Logger.shouldLog(4, this);
        this.uploadFrom = message.uploadFromType;
        this.origFilename = message.origFilename;
        String mimeType = message.contentType;
        if (this.binaryBlob && mimeType != null && !mimeType.equals("application/x-freenet-binary-blob")) {
            throw new MessageInvalidException(8, "No MIME type allowed when inserting a binary blob", this.identifier, this.global);
        }
        if (mimeType == null && this.origFilename != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.origFilename.getName(), true);
        }
        if (mimeType == null && this.targetFilename != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.targetFilename, true);
        }
        if (mimeType == null) {
            mimeType = DefaultMIMETypes.guessMIMEType(this.identifier, true);
        }
        this.clientToken = message.clientToken;
        Bucket tempData = message.bucket;
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        if (this.logMINOR) {
            Logger.minor(this, "data = " + tempData + ", uploadFrom = " + ClientPutMessage.uploadFromString(this.uploadFrom));
        }
        if (this.uploadFrom == 2) {
            byte[] d;
            this.targetURI = message.redirectTarget;
            Metadata m = new Metadata(0, null, null, this.targetURI, cm);
            try {
                d = m.writeToByteArray();
            }
            catch (MetadataUnresolvedException e) {
                Logger.error(this, "Impossible: " + e, e);
                this.data = null;
                this.clientMetadata = cm;
                this.putter = null;
                throw new MessageInvalidException(17, "Impossible: metadata unresolved: " + e, this.identifier, this.global);
            }
            tempData = new SimpleReadOnlyArrayBucket(d);
            isMetadata = true;
        } else {
            this.targetURI = null;
        }
        this.data = tempData;
        this.clientMetadata = cm;
        if (salt != null) {
            byte[] foundHash;
            MessageDigest md = SHA256.getMessageDigest();
            try {
                try {
                    md.update(salt.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                try {
                    InputStream is = this.data.getInputStream();
                    SHA256.hash(is, md);
                    is.close();
                }
                catch (IOException e) {
                    SHA256.returnMessageDigest(md);
                    Logger.error(this, "Got IOE: " + e.getMessage(), e);
                    throw new MessageInvalidException(26, "Unable to access file: " + e, this.identifier, this.global);
                }
                foundHash = md.digest();
                Object var15_18 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                SHA256.returnMessageDigest(md);
                throw throwable;
            }
            SHA256.returnMessageDigest(md);
            if (this.logMINOR) {
                Logger.minor(this, "FileHash result : we found " + Base64.encode(foundHash) + " and were given " + Base64.encode(saltedHash) + '.');
            }
            if (!Arrays.equals(saltedHash, foundHash)) {
                throw new MessageInvalidException(25, "The hash doesn't match! (salt used : \"" + salt + "\")", this.identifier, this.global);
            }
        }
        if (this.logMINOR) {
            Logger.minor(this, "data = " + this.data + ", uploadFrom = " + ClientPutMessage.uploadFromString(this.uploadFrom));
        }
        this.putter = new ClientPutter(this, this.data, this.uri, cm, this.ctx, this.priorityClass, this.getCHKOnly, isMetadata, this.lowLevelClient, null, this.targetFilename, this.binaryBlob);
    }

    public ClientPut(SimpleFieldSet fs, FCPClient client2, FCPServer server, ObjectContainer container) throws PersistenceParseException, IOException, InsertException {
        super(fs, client2, server);
        this.logMINOR = Logger.shouldLog(4, this);
        String mimeType = fs.get("Metadata.ContentType");
        String from = fs.get("UploadFrom");
        if (from.equals("direct")) {
            this.uploadFrom = 0;
        } else if (from.equals("disk")) {
            this.uploadFrom = 1;
        } else if (from.equals("redirect")) {
            this.uploadFrom = (short)2;
        } else {
            throw new PersistenceParseException("Unknown UploadFrom: " + from);
        }
        ClientMetadata cm = new ClientMetadata(mimeType);
        boolean isMetadata = false;
        this.binaryBlob = fs.getBoolean("BinaryBlob", false);
        this.targetFilename = fs.get("TargetFilename");
        if (this.uploadFrom == 1) {
            this.origFilename = new File(fs.get("Filename"));
            if (this.logMINOR) {
                Logger.minor(this, "Uploading from disk: " + this.origFilename + " for " + this);
            }
            this.data = new FileBucket(this.origFilename, true, false, false, false, false);
            this.targetURI = null;
        } else if (this.uploadFrom == 0) {
            this.origFilename = null;
            if (this.logMINOR) {
                Logger.minor(this, "Uploading from direct for " + this);
            }
            if (!this.finished) {
                try {
                    this.data = SerializableToFieldSetBucketUtil.create(fs.subset("TempBucket"), server.core.random, server.core.persistentTempBucketFactory);
                }
                catch (CannotCreateFromFieldSetException e) {
                    throw new PersistenceParseException("Could not read old bucket for " + this.identifier + " : " + e, e);
                }
            } else {
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Finished already so not reading bucket for " + this);
                }
                this.data = null;
            }
            this.targetURI = null;
        } else if (this.uploadFrom == 2) {
            byte[] d;
            String target = fs.get("TargetURI");
            this.targetURI = new FreenetURI(target);
            if (this.logMINOR) {
                Logger.minor(this, "Uploading from redirect for " + this + " : " + this.targetURI);
            }
            Metadata m = new Metadata(0, null, null, this.targetURI, cm);
            try {
                d = m.writeToByteArray();
            }
            catch (MetadataUnresolvedException e) {
                Logger.error(this, "Impossible: " + e, e);
                this.data = null;
                this.clientMetadata = cm;
                this.origFilename = null;
                this.putter = null;
                throw new InsertException(3, "Impossible: " + e + " in ClientPut", null);
            }
            this.data = new SimpleReadOnlyArrayBucket(d);
            this.origFilename = null;
            isMetadata = true;
        } else {
            throw new PersistenceParseException("shouldn't happen");
        }
        if (this.logMINOR) {
            Logger.minor(this, "data = " + this.data);
        }
        this.clientMetadata = cm;
        SimpleFieldSet oldProgress = fs.subset("progress");
        if (this.finished) {
            oldProgress = null;
        }
        this.putter = new ClientPutter(this, this.data, this.uri, cm, this.ctx, this.priorityClass, this.getCHKOnly, isMetadata, this.lowLevelClient, oldProgress, this.targetFilename, this.binaryBlob);
        if (this.persistenceType != 0) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    void register(ObjectContainer container, boolean lazyResume, boolean noTags) throws IdentifierCollisionException {
        if (this.persistenceType != 0) {
            this.client.register(this, false, container);
        }
        if (this.persistenceType != 0 && !noTags) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ObjectContainer container, ClientContext context) {
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Starting " + this + " : " + this.identifier);
        }
        ClientPut clientPut = this;
        synchronized (clientPut) {
            if (this.finished) {
                return;
            }
        }
        try {
            Object msg;
            this.putter.start(this.earlyEncode, false, container, context);
            if (this.persistenceType != 0 && !this.finished) {
                msg = this.persistentTagMessage(container);
                this.client.queueClientRequestMessage((FCPMessage)msg, 0, container);
            }
            msg = this;
            synchronized (msg) {
                this.started = true;
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
        }
        catch (InsertException e) {
            ClientPut clientPut2 = this;
            synchronized (clientPut2) {
                this.started = true;
            }
            this.onFailure(e, null, container);
        }
        catch (Throwable t) {
            ClientPut clientPut3 = this;
            synchronized (clientPut3) {
                this.started = true;
            }
            this.onFailure(new InsertException(3, t, null), null, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeData(ObjectContainer container) {
        Bucket d;
        ClientPut clientPut = this;
        synchronized (clientPut) {
            d = this.data;
            this.data = null;
            if (d == null) {
                return;
            }
            if (this.persistenceType == 2) {
                container.activate((Object)d, 5);
            }
            this.finishedSize = d.size();
        }
        d.free();
        if (this.persistenceType == 2) {
            d.removeFrom(container);
        }
    }

    protected ClientRequester getClientRequest() {
        return this.putter;
    }

    protected FCPMessage persistentTagMessage(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.publicURI, 5);
            container.activate((Object)this.clientMetadata, 5);
            container.activate((Object)this.origFilename, 5);
        }
        return new PersistentPut(this.identifier, this.publicURI, this.verbosity, this.priorityClass, this.uploadFrom, this.targetURI, this.persistenceType, this.origFilename, this.clientMetadata.getMIMEType(), this.client.isGlobalQueue, this.getDataSize(container), this.clientToken, this.started, this.ctx.maxInsertRetries, this.targetFilename, this.binaryBlob);
    }

    protected String getTypeName() {
        return "PUT";
    }

    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public FreenetURI getFinalURI(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.generatedURI, 5);
        }
        return this.generatedURI;
    }

    public boolean isDirect() {
        return this.uploadFrom == 0;
    }

    public File getOrigFilename(ObjectContainer container) {
        if (this.uploadFrom != 1) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.origFilename, 5);
        }
        return this.origFilename;
    }

    public long getDataSize(ObjectContainer container) {
        if (this.data == null) {
            return this.finishedSize;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.data, 1);
        }
        return this.data.size();
    }

    public String getMIMEType() {
        return this.clientMetadata.getMIMEType();
    }

    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return this.putter.canRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart(ObjectContainer container, ClientContext context) {
        if (!this.canRestart()) {
            return false;
        }
        this.setVarsRestart(container);
        try {
            if (this.putter.restart(this.earlyEncode, container, context)) {
                ClientPut clientPut = this;
                synchronized (clientPut) {
                    this.generatedURI = null;
                    this.started = true;
                }
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
            return true;
        }
        catch (InsertException e) {
            this.onFailure(e, null, container);
            return false;
        }
    }

    public void onRemoveEventProducer(ObjectContainer container) {
    }

    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.putter, 1);
            this.putter.removeFrom(container, context);
            this.putter = null;
            if (this.origFilename != null) {
                container.activate((Object)this.origFilename, 5);
                container.delete((Object)this.origFilename);
            }
            if (this.targetURI != null) {
                container.activate((Object)this.targetURI, 5);
                this.targetURI.removeFrom(container);
            }
        }
        super.requestWasRemoved(container, context);
    }
}

