/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.FreenetURI;
import freenet.node.fcp.AllDataMessage;
import freenet.node.fcp.ClientGetMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.DataFoundMessage;
import freenet.node.fcp.FCPClient;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.node.fcp.FCPConnectionOutputHandler;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.GetFailedMessage;
import freenet.node.fcp.IdentifierCollisionException;
import freenet.node.fcp.MessageInvalidException;
import freenet.node.fcp.NotAllowedException;
import freenet.node.fcp.PersistentGet;
import freenet.node.fcp.PersistentRequestRemovedMessage;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.node.fcp.SendingToNetworkMessage;
import freenet.node.fcp.SimpleProgressMessage;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.CannotCreateFromFieldSetException;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.NullBucket;
import freenet.support.io.SerializableToFieldSetBucketUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class ClientGet
extends ClientRequest
implements ClientGetCallback,
ClientEventListener {
    private final FetchContext fctx;
    private final ClientGetter getter;
    private final short returnType;
    private final File targetFile;
    private final File tempFile;
    private Bucket returnBucket;
    private final boolean binaryBlob;
    private static final int VERBOSITY_SPLITFILE_PROGRESS = 1;
    private static final int VERBOSITY_SENT_TO_NETWORK = 2;
    private boolean succeeded;
    private long foundDataLength;
    private String foundDataMimeType;
    private GetFailedMessage getFailedMessage;
    private ProtocolErrorMessage postFetchProtocolErrorMessage;
    private AllDataMessage allDataPending;
    private SimpleProgressMessage progressPending;
    private boolean sentToNetwork;

    public ClientGet(FCPClient globalClient, FreenetURI uri, boolean dsOnly, boolean ignoreDS, int maxSplitfileRetries, int maxNonSplitfileRetries, long maxOutputLength, short returnType, boolean persistRebootOnly, String identifier, int verbosity, short prioClass, File returnFilename, File returnTempFilename, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, NotAllowedException, IOException {
        super(uri, identifier, verbosity, null, globalClient, prioClass, persistRebootOnly ? (short)1 : 2, null, true, container);
        this.foundDataLength = -1L;
        this.fctx = new FetchContext(server.defaultFetchContext, 0, false, null);
        this.fctx.eventProducer.addEventListener(this);
        this.fctx.localRequestOnly = dsOnly;
        this.fctx.ignoreStore = ignoreDS;
        this.fctx.maxNonSplitfileRetries = maxNonSplitfileRetries;
        this.fctx.maxSplitfileBlockRetries = maxSplitfileRetries;
        this.fctx.maxOutputLength = maxOutputLength;
        this.fctx.maxTempLength = maxOutputLength;
        Bucket ret = null;
        this.returnType = returnType;
        this.binaryBlob = false;
        if (returnType == 2) {
            this.targetFile = returnFilename;
            this.tempFile = returnTempFilename;
            if (!server.core.allowDownloadTo(returnTempFilename) || !server.core.allowDownloadTo(returnFilename)) {
                throw new NotAllowedException();
            }
            ret = new FileBucket(returnTempFilename, false, true, false, false, false);
        } else if (returnType == 1) {
            this.targetFile = null;
            this.tempFile = null;
            ret = new NullBucket();
        } else {
            this.targetFile = null;
            this.tempFile = null;
            ret = this.persistenceType == 2 ? server.core.persistentTempBucketFactory.makeBucket(maxOutputLength) : server.core.tempBucketFactory.makeBucket(maxOutputLength);
        }
        this.returnBucket = ret;
        this.getter = new ClientGetter(this, uri, this.fctx, this.priorityClass, this.lowLevelClient, this.returnBucket, null);
    }

    public ClientGet(FCPConnectionHandler handler, ClientGetMessage message, FCPServer server, ObjectContainer container) throws IdentifierCollisionException, MessageInvalidException {
        super(message.uri, message.identifier, message.verbosity, handler, message.priorityClass, message.persistenceType, message.clientToken, message.global, container);
        this.foundDataLength = -1L;
        this.fctx = new FetchContext(server.defaultFetchContext, 0, false, null);
        this.fctx.eventProducer.addEventListener(this);
        this.fctx.localRequestOnly = message.dsOnly;
        this.fctx.ignoreStore = message.ignoreDS;
        this.fctx.maxNonSplitfileRetries = message.maxRetries;
        this.fctx.maxSplitfileBlockRetries = message.maxRetries;
        this.fctx.maxOutputLength = message.maxSize;
        this.fctx.maxTempLength = message.maxTempSize;
        if (message.allowedMIMETypes != null) {
            this.fctx.allowedMIMETypes = new HashSet();
            for (String mime : message.allowedMIMETypes) {
                this.fctx.allowedMIMETypes.add(mime);
            }
        }
        this.returnType = message.returnType;
        this.binaryBlob = message.binaryBlob;
        Bucket ret = null;
        if (this.returnType == 2) {
            this.targetFile = message.diskFile;
            this.tempFile = message.tempFile;
            if (!server.core.allowDownloadTo(this.tempFile) || !server.core.allowDownloadTo(this.targetFile)) {
                throw new MessageInvalidException(24, "Not allowed to download to " + this.tempFile + " or " + this.targetFile, this.identifier, this.global);
            }
            if (!handler.allowDDAFrom(this.tempFile, true) || !handler.allowDDAFrom(this.targetFile, true)) {
                throw new MessageInvalidException(25, "Not allowed to download to " + this.tempFile + " or " + this.targetFile + ". You might need to do a " + "TestDDARequest" + " first.", this.identifier, this.global);
            }
            ret = new FileBucket(message.tempFile, false, true, false, false, false);
        } else if (this.returnType == 1) {
            this.targetFile = null;
            this.tempFile = null;
            ret = new NullBucket();
        } else {
            this.targetFile = null;
            this.tempFile = null;
            try {
                ret = this.persistenceType == 2 ? server.core.persistentTempBucketFactory.makeBucket(this.fctx.maxOutputLength) : server.core.tempBucketFactory.makeBucket(this.fctx.maxOutputLength);
            }
            catch (IOException e) {
                Logger.error(this, "Cannot create bucket for temp storage: " + e, e);
                this.getter = null;
                this.returnBucket = null;
                throw new MessageInvalidException(17, "Cannot create bucket for temporary storage (out of disk space???): " + e, this.identifier, this.global);
            }
        }
        if (ret == null) {
            Logger.error(this, "Impossible: ret = null in FCP constructor for " + this, new Exception("debug"));
        }
        this.returnBucket = ret;
        this.getter = new ClientGetter(this, this.uri, this.fctx, this.priorityClass, this.lowLevelClient, this.binaryBlob ? new NullBucket() : this.returnBucket, this.binaryBlob ? this.returnBucket : null);
    }

    public ClientGet(SimpleFieldSet fs, FCPClient client2, FCPServer server) throws IOException, FetchException {
        Bucket ret;
        block19: {
            super(fs, client2);
            this.foundDataLength = -1L;
            this.returnType = ClientGetMessage.parseValidReturnType(fs.get("ReturnType"));
            String f = fs.get("Filename");
            this.targetFile = f != null ? new File(f) : null;
            f = fs.get("TempFilename");
            this.tempFile = f != null ? new File(f) : null;
            boolean ignoreDS = Fields.stringToBool(fs.get("IgnoreDS"), false);
            boolean dsOnly = Fields.stringToBool(fs.get("DSOnly"), false);
            int maxRetries = Integer.parseInt(fs.get("MaxRetries"));
            this.fctx = new FetchContext(server.defaultFetchContext, 0, false, null);
            this.fctx.eventProducer.addEventListener(this);
            this.fctx.localRequestOnly = dsOnly;
            this.fctx.ignoreStore = ignoreDS;
            this.fctx.maxNonSplitfileRetries = maxRetries;
            this.fctx.maxSplitfileBlockRetries = maxRetries;
            this.binaryBlob = Fields.stringToBool(fs.get("BinaryBlob"), false);
            this.succeeded = Fields.stringToBool(fs.get("Succeeded"), false);
            if (this.finished) {
                if (this.succeeded) {
                    this.foundDataLength = Long.parseLong(fs.get("FoundDataLength"));
                    this.foundDataMimeType = fs.get("FoundDataMimeType");
                    SimpleFieldSet fs1 = fs.subset("PostFetchProtocolError");
                    if (fs1 != null) {
                        this.postFetchProtocolErrorMessage = new ProtocolErrorMessage(fs1);
                    }
                } else {
                    this.getFailedMessage = new GetFailedMessage(fs.subset("GetFailed"), false);
                }
            }
            ret = null;
            if (this.returnType == 2) {
                ret = this.succeeded ? new FileBucket(this.targetFile, false, true, false, false, false) : new FileBucket(this.tempFile, false, true, false, false, false);
            } else if (this.returnType == 1) {
                ret = new NullBucket();
            } else {
                if (this.returnType == 0) {
                    try {
                        ret = SerializableToFieldSetBucketUtil.create(fs.subset("ReturnBucket"), server.core.random, server.core.persistentTempBucketFactory);
                        if (ret == null) {
                            throw new CannotCreateFromFieldSetException("ret == null");
                        }
                        break block19;
                    }
                    catch (CannotCreateFromFieldSetException e) {
                        Logger.error(this, "Cannot read: " + this + " : " + e, e);
                        try {
                            ret = this.persistenceType == 2 ? server.core.persistentTempBucketFactory.makeBucket(this.fctx.maxOutputLength) : server.core.tempBucketFactory.makeBucket(this.fctx.maxOutputLength);
                            break block19;
                        }
                        catch (IOException e1) {
                            Logger.error(this, "Cannot create bucket for temp storage: " + e, e);
                            this.getter = null;
                            this.returnBucket = null;
                            throw new FetchException(12, (Throwable)e);
                        }
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        if (this.succeeded && this.foundDataLength < ret.size()) {
            Logger.error(this, "Failing " + this.identifier + " because lost data");
            this.succeeded = false;
        }
        if (ret == null) {
            Logger.error(this, "Impossible: ret = null in SFS constructor for " + this, new Exception("debug"));
        }
        this.returnBucket = ret;
        String[] allowed = fs.getAll("AllowedMIMETypes");
        if (allowed != null) {
            this.fctx.allowedMIMETypes = new HashSet();
            for (String a : allowed) {
                this.fctx.allowedMIMETypes.add(a);
            }
        }
        this.getter = new ClientGetter(this, this.uri, this.fctx, this.priorityClass, this.lowLevelClient, this.binaryBlob ? new NullBucket() : this.returnBucket, this.binaryBlob ? this.returnBucket : null);
        if (this.finished && this.succeeded) {
            this.allDataPending = new AllDataMessage(this.returnBucket, this.identifier, this.global, this.startupTime, this.completionTime, this.foundDataMimeType);
        }
    }

    void register(ObjectContainer container, boolean lazyResume, boolean noTags) throws IdentifierCollisionException {
        if (this.client != null) assert (this.persistenceType == this.client.persistenceType);
        if (this.persistenceType != 0) {
            try {
                this.client.register(this, lazyResume, container);
            }
            catch (IdentifierCollisionException e) {
                this.returnBucket.free();
                if (this.persistenceType == 2) {
                    this.returnBucket.removeFrom(container);
                }
                throw e;
            }
        }
        if (this.persistenceType != 0 && !noTags) {
            FCPMessage msg = this.persistentTagMessage(container);
            this.client.queueClientRequestMessage(msg, 0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ObjectContainer container, ClientContext context) {
        try {
            Object msg;
            ClientGet clientGet = this;
            synchronized (clientGet) {
                if (this.finished) {
                    return;
                }
            }
            this.getter.start(container, context);
            if (this.persistenceType != 0 && !this.finished) {
                msg = this.persistentTagMessage(container);
                this.client.queueClientRequestMessage((FCPMessage)msg, 0, container);
            }
            msg = this;
            synchronized (msg) {
                this.started = true;
            }
        }
        catch (FetchException e) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.started = true;
            }
            this.onFailure(e, null, container);
        }
        catch (Throwable t) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.started = true;
            }
            this.onFailure(new FetchException(17, t), null, container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    public void onLostConnection(ObjectContainer container, ClientContext context) {
        if (this.persistenceType == 0) {
            this.cancel(container, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        Logger.minor(this, "Succeeded: " + this.identifier);
        Bucket data = result.asBucket();
        if (this.persistenceType == 2) {
            if (data != null) {
                container.activate((Object)data, 5);
            }
            if (this.returnBucket != null) {
                container.activate((Object)this.returnBucket, 5);
            }
            container.activate((Object)this.client, 1);
            if (this.tempFile != null) {
                container.activate((Object)this.tempFile, 5);
            }
            if (this.targetFile != null) {
                container.activate((Object)this.targetFile, 5);
            }
        }
        if (this.returnBucket != data && !this.binaryBlob) {
            boolean failed = true;
            ClientGet clientGet = this;
            synchronized (clientGet) {
                if (this.finished) {
                    Logger.error(this, "Already finished but onSuccess() for " + this + " data = " + data, new Exception("debug"));
                    data.free();
                    if (this.persistenceType == 2) {
                        data.removeFrom(container);
                    }
                    return;
                }
                if (this.returnType == 0 && this.returnBucket == null) {
                    this.returnBucket = data;
                    failed = false;
                }
            }
            if (failed && this.persistenceType == 2 && container.ext().getID((Object)this.returnBucket) == container.ext().getID((Object)data)) {
                Logger.error(this, "DB4O BUG DETECTED WITHOUT ARRAY HANDLING! EVIL HORRIBLE BUG! UID(returnBucket)=" + container.ext().getID((Object)this.returnBucket) + " for " + this.returnBucket + " active=" + container.ext().isActive((Object)this.returnBucket) + " stored = " + container.ext().isStored((Object)this.returnBucket) + " but UID(data)=" + container.ext().getID((Object)data) + " for " + data + " active = " + container.ext().isActive((Object)data) + " stored = " + container.ext().isStored((Object)data));
                this.returnBucket = data;
                failed = false;
            }
            if (failed) {
                Logger.error(this, "returnBucket = " + this.returnBucket + " but onSuccess() data = " + data, new Exception("debug"));
                this.onFailure(new FetchException(17, "Data != returnBucket"), null, container);
                return;
            }
        }
        boolean dontFree = false;
        AllDataMessage adm = null;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (this.succeeded) {
                Logger.error(this, "onSuccess called twice for " + this + " (" + this.identifier + ')');
                return;
            }
            this.started = true;
            this.foundDataMimeType = !this.binaryBlob ? result.getMimeType() : "application/x-freenet-binary-blob";
            if (this.returnType == 0) {
                adm = new AllDataMessage(this.returnBucket, this.identifier, this.global, this.startupTime, System.currentTimeMillis(), this.foundDataMimeType);
                if (this.persistenceType == 0) {
                    adm.setFreeOnSent();
                }
                dontFree = true;
            } else if (this.returnType == 2) {
                if (!FileUtil.renameTo(this.tempFile, this.targetFile)) {
                    this.postFetchProtocolErrorMessage = new ProtocolErrorMessage(14, false, null, this.identifier, this.global);
                }
                this.returnBucket = new FileBucket(this.targetFile, false, true, false, false, false);
            }
            if (this.persistenceType == 2 && this.progressPending != null) {
                container.activate((Object)this.progressPending, 1);
                this.progressPending.removeFrom(container);
            }
            this.progressPending = null;
            this.foundDataLength = this.returnBucket.size();
            this.succeeded = true;
            this.finished = true;
        }
        this.trySendDataFoundOrGetFailed(null, container);
        if (adm != null) {
            this.trySendAllDataMessage(adm, null, container);
        }
        if (!dontFree) {
            data.free();
        }
        if (this.persistenceType == 2) {
            this.returnBucket.storeTo(container);
            container.store((Object)this);
        }
        this.finish(container);
        if (this.client != null) {
            this.client.notifySuccess(this, container);
        }
    }

    private void trySendDataFoundOrGetFailed(FCPConnectionOutputHandler handler, ObjectContainer container) {
        FCPMessage msg;
        if (this.succeeded) {
            msg = new DataFoundMessage(this.foundDataLength, this.foundDataMimeType, this.identifier, this.global);
        } else {
            msg = this.getFailedMessage;
            if (this.persistenceType == 2) {
                container.activate((Object)msg, 5);
            }
        }
        if (handler == null && this.persistenceType == 0) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 0, container);
        }
        if (this.postFetchProtocolErrorMessage != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.postFetchProtocolErrorMessage, 5);
            }
            if (handler != null) {
                handler.queue(this.postFetchProtocolErrorMessage);
            } else {
                if (this.persistenceType == 2) {
                    container.activate((Object)this.client, 1);
                }
                this.client.queueClientRequestMessage(this.postFetchProtocolErrorMessage, 0, container);
            }
        }
    }

    private void trySendAllDataMessage(AllDataMessage msg, FCPConnectionOutputHandler handler, ObjectContainer container) {
        if (this.persistenceType != 0) {
            this.allDataPending = msg;
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
            return;
        }
        if (handler == null) {
            handler = this.origHandler.outputHandler;
        }
        handler.queue(msg);
    }

    private void trySendProgress(FCPMessage msg, FCPConnectionOutputHandler handler, ObjectContainer container) {
        if (this.persistenceType != 0) {
            SimpleProgressMessage oldProgress = null;
            if (msg instanceof SimpleProgressMessage) {
                oldProgress = this.progressPending;
                this.progressPending = (SimpleProgressMessage)msg;
            } else if (msg instanceof SendingToNetworkMessage) {
                this.sentToNetwork = true;
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
                if (oldProgress != null) {
                    container.activate((Object)oldProgress, 1);
                    ((FCPMessage)oldProgress).removeFrom(container);
                }
            }
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.client, 1);
        }
        if (this.persistenceType == 0 && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, 1, container);
        }
        if (this.persistenceType == 2 && !this.client.isGlobalQueue) {
            container.deactivate((Object)this.client, 1);
        }
    }

    public void sendPendingMessages(FCPConnectionOutputHandler handler, boolean includePersistentRequest, boolean includeData, boolean onlyData, ObjectContainer container) {
        if (this.persistenceType == 0) {
            Logger.error(this, "WTF? persistenceType=" + this.persistenceType, new Exception("error"));
            return;
        }
        if (!onlyData) {
            if (includePersistentRequest) {
                FCPMessage msg = this.persistentTagMessage(container);
                handler.queue(msg);
            }
            if (this.progressPending != null) {
                if (this.persistenceType == 2) {
                    container.activate((Object)this.progressPending, 5);
                }
                handler.queue(this.progressPending);
            }
            if (this.sentToNetwork) {
                handler.queue(new SendingToNetworkMessage(this.identifier, this.global));
            }
            if (this.finished) {
                this.trySendDataFoundOrGetFailed(handler, container);
            }
        }
        if (onlyData && this.allDataPending == null) {
            Logger.error(this, "No data pending !");
        }
        if (includeData && this.allDataPending != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.allDataPending, 5);
            }
            handler.queue(this.allDataPending);
        }
    }

    protected FCPMessage persistentTagMessage(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.uri, 5);
            container.activate((Object)this.fctx, 1);
            container.activate((Object)this.client, 1);
            container.activate((Object)this.targetFile, 5);
            container.activate((Object)this.tempFile, 5);
        }
        return new PersistentGet(this.identifier, this.uri, this.verbosity, this.priorityClass, this.returnType, this.persistenceType, this.targetFile, this.tempFile, this.clientToken, this.client.isGlobalQueue, this.started, this.fctx.maxNonSplitfileRetries, this.binaryBlob, this.fctx.maxOutputLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        if (this.finished) {
            return;
        }
        ClientGet clientGet = this;
        synchronized (clientGet) {
            this.succeeded = false;
            this.getFailedMessage = new GetFailedMessage(e, this.identifier, this.global);
            this.finished = true;
            this.started = true;
        }
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Caught " + e, (Throwable)e);
        }
        this.trySendDataFoundOrGetFailed(null, container);
        if (this.persistenceType == 2) {
            container.activate((Object)this.client, 1);
        }
        this.finish(container);
        if (this.client != null) {
            this.client.notifyFailure(this, container);
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWasRemoved(ObjectContainer container, ClientContext context) {
        if (!this.finished) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.succeeded = false;
                this.finished = true;
                FetchException cancelled = new FetchException(25);
                this.getFailedMessage = new GetFailedMessage(cancelled, this.identifier, this.global);
            }
            this.trySendDataFoundOrGetFailed(null, container);
        }
        PersistentRequestRemovedMessage msg = new PersistentRequestRemovedMessage(this.getIdentifier(), this.global);
        if (this.persistenceType != 0) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.client, 1);
            }
            this.client.queueClientRequestMessage(msg, 0, container);
        }
        this.freeData(container);
        if (this.persistenceType == 2) {
            container.activate((Object)this.fctx, 1);
            if (this.fctx.allowedMIMETypes != null) {
                container.activate((Object)this.fctx.allowedMIMETypes, 5);
                container.delete((Object)this.fctx.allowedMIMETypes);
            }
            this.fctx.removeFrom(container);
            this.getter.removeFrom(container, context);
            if (this.targetFile != null) {
                container.delete((Object)this.targetFile);
            }
            if (this.tempFile != null) {
                container.delete((Object)this.tempFile);
            }
            if (this.getFailedMessage != null) {
                container.activate((Object)this.getFailedMessage, 5);
                this.getFailedMessage.removeFrom(container);
            }
            if (this.postFetchProtocolErrorMessage != null) {
                container.activate((Object)this.postFetchProtocolErrorMessage, 5);
                this.postFetchProtocolErrorMessage.removeFrom(container);
            }
            if (this.allDataPending != null) {
                container.activate((Object)this.allDataPending, 5);
                this.allDataPending.removeFrom(container);
            }
            if (this.progressPending != null) {
                container.activate((Object)this.progressPending, 5);
                this.progressPending.removeFrom(container);
            }
        }
        super.requestWasRemoved(container, context);
    }

    public void receive(ClientEvent ce, ObjectContainer container, ClientContext context) {
        FCPMessage progress;
        if (this.finished) {
            return;
        }
        if (ce instanceof SplitfileProgressEvent) {
            if ((this.verbosity & 1) != 1) {
                return;
            }
            progress = new SimpleProgressMessage(this.identifier, this.global, (SplitfileProgressEvent)ce);
        } else if (ce instanceof SendingToNetworkEvent) {
            if ((this.verbosity & 2) != 2) {
                return;
            }
            progress = new SendingToNetworkMessage(this.identifier, this.global);
        } else {
            return;
        }
        if (this.persistenceType == 2 && container == null) {
            try {
                context.jobRunner.queue(new DBJob(){

                    public boolean run(ObjectContainer container, ClientContext context) {
                        ClientGet.this.trySendProgress(progress, null, container);
                        return false;
                    }
                }, 7, false);
            }
            catch (DatabaseDisabledException e) {}
        } else {
            this.trySendProgress(progress, null, container);
        }
    }

    public synchronized SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Type", "GET");
        fs.putSingle("URI", this.uri.toString(false, false));
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("Verbosity", Integer.toString(this.verbosity));
        fs.putSingle("PriorityClass", Short.toString(this.priorityClass));
        fs.putSingle("ReturnType", ClientGetMessage.returnTypeString(this.returnType));
        fs.putSingle("Persistence", ClientGet.persistenceTypeString(this.persistenceType));
        fs.putSingle("ClientName", this.client.name);
        if (this.targetFile != null) {
            fs.putSingle("Filename", this.targetFile.getPath());
        }
        if (this.tempFile != null) {
            fs.putSingle("TempFilename", this.tempFile.getPath());
        }
        if (this.clientToken != null) {
            fs.putSingle("ClientToken", this.clientToken);
        }
        fs.putSingle("IgnoreDS", Boolean.toString(this.fctx.ignoreStore));
        fs.putSingle("DSOnly", Boolean.toString(this.fctx.localRequestOnly));
        fs.putSingle("MaxRetries", Integer.toString(this.fctx.maxNonSplitfileRetries));
        fs.putSingle("Finished", Boolean.toString(this.finished));
        fs.putSingle("Succeeded", Boolean.toString(this.succeeded));
        if (this.fctx.allowedMIMETypes != null) {
            fs.putOverwrite("AllowedMIMETypes", this.fctx.allowedMIMETypes.toArray(new String[this.fctx.allowedMIMETypes.size()]));
        }
        if (this.finished) {
            if (this.succeeded) {
                fs.putSingle("FoundDataLength", Long.toString(this.foundDataLength));
                fs.putSingle("FoundDataMimeType", this.foundDataMimeType);
                if (this.postFetchProtocolErrorMessage != null) {
                    fs.put("PostFetchProtocolError", this.postFetchProtocolErrorMessage.getFieldSet());
                }
            } else if (this.getFailedMessage != null) {
                fs.put("GetFailed", this.getFailedMessage.getFieldSet(false));
            }
        }
        if (this.returnType == 0 && (this.succeeded || this.returnBucket != null)) {
            this.bucketToFS(fs, "ReturnBucket", false, this.returnBucket);
        }
        fs.putSingle("Global", Boolean.toString(this.client.isGlobalQueue));
        fs.put("BinaryBlob", this.binaryBlob);
        fs.put("StartupTime", this.startupTime);
        if (this.finished) {
            fs.put("CompletionTime", this.completionTime);
        }
        return fs;
    }

    protected ClientRequester getClientRequest() {
        return this.getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeData(ObjectContainer container) {
        Bucket data;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            data = this.returnBucket;
            this.returnBucket = null;
        }
        if (data != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)data, 5);
            }
            data.free();
            if (this.persistenceType == 2) {
                data.removeFrom(container);
            }
            if (this.persistenceType == 2) {
                container.store((Object)this);
            }
        }
    }

    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public boolean isDirect() {
        return this.returnType == 0;
    }

    public boolean isToDisk() {
        return this.returnType == 2;
    }

    public FreenetURI getURI(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.uri, 5);
        }
        return this.uri;
    }

    public long getDataSize(ObjectContainer container) {
        if (this.foundDataLength > 0L) {
            return this.foundDataLength;
        }
        if (this.getter != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            return this.getter.expectedSize();
        }
        return -1L;
    }

    public String getMIMEType(ObjectContainer container) {
        if (this.foundDataMimeType != null) {
            return this.foundDataMimeType;
        }
        if (this.getter != null) {
            if (this.persistenceType == 2) {
                container.activate((Object)this.getter, 1);
            }
            return this.getter.expectedMIME();
        }
        return null;
    }

    public File getDestFilename(ObjectContainer container) {
        if (this.persistenceType == 2) {
            container.activate((Object)this.targetFile, 5);
        }
        return this.targetFile;
    }

    public double getSuccessFraction(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFraction();
        }
        return -1.0;
    }

    public double getTotalBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getTotalBlocks();
        }
        return 1.0;
    }

    public double getMinBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getMinBlocks();
        }
        return 1.0;
    }

    public double getFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFailedBlocks();
        }
        return 0.0;
    }

    public double getFatalyFailedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFatalyFailedBlocks();
        }
        return 0.0;
    }

    public double getFetchedBlocks(ObjectContainer container) {
        if (this.persistenceType == 2 && this.progressPending != null) {
            container.activate((Object)this.progressPending, 2);
        }
        if (this.progressPending != null) {
            return this.progressPending.getFetchedBlocks();
        }
        return 0.0;
    }

    public String getFailureReason(ObjectContainer container) {
        if (this.getFailedMessage == null) {
            return null;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.getFailedMessage, 5);
        }
        String s = this.getFailedMessage.shortCodeDescription;
        if (this.getFailedMessage.extraDescription != null) {
            s = s + ": " + this.getFailedMessage.extraDescription;
        }
        return s;
    }

    public boolean isTotalFinalized(ObjectContainer container) {
        if (this.finished && this.succeeded) {
            return true;
        }
        if (this.progressPending == null) {
            return false;
        }
        if (this.persistenceType == 2) {
            container.activate((Object)this.progressPending, 1);
        }
        return this.progressPending.isTotalFinalized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getBucket(ObjectContainer container) {
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (this.targetFile != null) {
                if (this.succeeded || this.tempFile == null) {
                    if (this.persistenceType == 2) {
                        container.activate((Object)this.targetFile, 5);
                    }
                    return new FileBucket(this.targetFile, false, true, false, false, false);
                }
                if (this.persistenceType == 2) {
                    container.activate((Object)this.tempFile, 5);
                }
                return new FileBucket(this.tempFile, false, true, false, false, false);
            }
            return this.returnBucket;
        }
    }

    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return this.getter.canRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart(ObjectContainer container, ClientContext context) {
        FreenetURI redirect;
        if (!this.canRestart()) {
            return false;
        }
        ClientGet clientGet = this;
        synchronized (clientGet) {
            this.finished = false;
            FreenetURI freenetURI = redirect = this.getFailedMessage == null ? null : this.getFailedMessage.redirectURI;
            if (this.persistenceType == 2 && this.getFailedMessage != null) {
                this.getFailedMessage.removeFrom(container);
            }
            this.getFailedMessage = null;
            if (this.persistenceType == 2 && this.allDataPending != null) {
                this.allDataPending.removeFrom(container);
            }
            this.allDataPending = null;
            if (this.persistenceType == 2 && this.postFetchProtocolErrorMessage != null) {
                this.postFetchProtocolErrorMessage.removeFrom(container);
            }
            this.postFetchProtocolErrorMessage = null;
            if (this.persistenceType == 2 && this.progressPending != null) {
                this.progressPending.removeFrom(container);
            }
            this.progressPending = null;
            this.started = false;
        }
        if (this.persistenceType == 2) {
            container.store((Object)this);
        }
        try {
            if (this.getter.restart(redirect, container, context)) {
                clientGet = this;
                synchronized (clientGet) {
                    if (redirect != null) {
                        if (this.persistenceType == 2) {
                            this.uri.removeFrom(container);
                        }
                        this.uri = redirect;
                    }
                    this.started = true;
                }
                if (this.persistenceType == 2) {
                    container.store((Object)this);
                }
            }
            return true;
        }
        catch (FetchException e) {
            this.onFailure(e, null, container);
            return false;
        }
    }

    public synchronized boolean hasPermRedirect() {
        return this.getFailedMessage != null && this.getFailedMessage.redirectURI != null;
    }

    public void onRemoveEventProducer(ObjectContainer container) {
    }
}

