/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Ticker;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;

public class UptimeEstimator
implements Runnable {
    static final int PERIOD = 300000;
    Ticker ticker;
    private boolean[] wasOnline = new boolean[576];
    private int slot;
    private File logFile;
    private File prevFile;
    private long timeOffset;

    public UptimeEstimator(File nodeDir, Ticker ticker, byte[] bs) {
        this.ticker = ticker;
        this.logFile = new File(nodeDir, "uptime.dat");
        this.prevFile = new File(nodeDir, "uptime.old.dat");
        this.timeOffset = (int)((double)Math.abs(Fields.hashCode(bs, bs.length / 2, bs.length - bs.length / 2)) / 2.147483647E9 * 300000.0);
    }

    public void start() {
        long now = System.currentTimeMillis();
        int fiveMinutesSinceEpoch = (int)(now / 300000L);
        int base = fiveMinutesSinceEpoch - this.wasOnline.length;
        this.readData(this.prevFile, base);
        this.readData(this.logFile, base);
        this.schedule(System.currentTimeMillis());
        System.out.println("Created uptime estimator, time offset is " + this.timeOffset + " uptime at startup is " + new DecimalFormat("0.00").format(this.getUptime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readData(File file, int base) {
        FileInputStream fis;
        block12: {
            DataInputStream dis;
            fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    dis = new DataInputStream(fis);
                    try {
                        try {}
                        catch (EOFException e) {
                            Object var8_10 = null;
                            Closer.close(dis);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        Closer.close(dis);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Logger.error(this, "Unable to read old uptime file: " + file + " - we will assume we weren't online during that period");
                    Object var10_14 = null;
                    Closer.close(fis);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                Closer.close(fis);
                throw throwable;
            }
            while (true) {
                int offset;
                if ((offset = dis.readInt()) < base) {
                    continue;
                }
                int slotNo = offset - base;
                if (slotNo == this.wasOnline.length) break;
                if (slotNo > this.wasOnline.length || slotNo < 0) {
                    Logger.error(this, "Corrupt data read from uptime file " + file + ": 5-minutes-from-epoch is now " + (base + this.wasOnline.length) + " but read " + slotNo);
                    break;
                }
                this.wasOnline[slotNo] = true;
            }
            Object var8_9 = null;
            Closer.close(dis);
        }
        Object var10_13 = null;
        Closer.close(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        UptimeEstimator uptimeEstimator = this;
        synchronized (uptimeEstimator) {
            this.wasOnline[this.slot] = true;
            this.slot = (this.slot + 1) % this.wasOnline.length;
        }
        long now = System.currentTimeMillis();
        if (this.logFile.length() > (long)this.wasOnline.length * 4L) {
            this.prevFile.delete();
            this.logFile.renameTo(this.prevFile);
        }
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        int fiveMinutesSinceEpoch = (int)(now / 300000L);
        try {
            try {
                fos = new FileOutputStream(this.logFile, true);
                dos = new DataOutputStream(fos);
                dos.writeInt(fiveMinutesSinceEpoch);
            }
            catch (FileNotFoundException e) {
                Logger.error(this, "Unable to create or access " + this.logFile + " : " + e, e);
                Object var8_7 = null;
                Closer.close(dos);
                Closer.close(fos);
                this.schedule(now);
                return;
            }
            catch (IOException e) {
                Logger.error(this, "Unable to write to uptime estimator log file: " + this.logFile);
                Object var8_8 = null;
                Closer.close(dos);
                Closer.close(fos);
                this.schedule(now);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Closer.close(dos);
            Closer.close(fos);
            this.schedule(now);
            throw throwable;
        }
        Closer.close(dos);
        Closer.close(fos);
        this.schedule(now);
    }

    private void schedule(long now) {
        long nextTime = now / 300000L * 300000L + this.timeOffset;
        if (nextTime < now) {
            nextTime += 300000L;
        }
        this.ticker.queueTimedJob(this, nextTime - System.currentTimeMillis());
    }

    public synchronized double getUptime() {
        int upCount = 0;
        for (int i = 0; i < this.wasOnline.length; ++i) {
            if (!this.wasOnline[i]) continue;
            ++upCount;
        }
        return (double)upCount / (double)this.wasOnline.length;
    }
}

