/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;

public class ThrottleWindowManager {
    private static volatile boolean logMINOR;
    static final float PACKET_DROP_DECREASE_MULTIPLE = 0.97f;
    static final float PACKET_TRANSMIT_INCREMENT = 0.07879996f;
    private long _totalPackets = 0L;
    private long _droppedPackets = 0L;
    private double _simulatedWindowSize = 2.0;
    private final Node node;

    public ThrottleWindowManager(double def, SimpleFieldSet fs, Node node) {
        this.node = node;
        if (fs != null) {
            this._totalPackets = fs.getInt("TotalPackets", 0);
            this._droppedPackets = fs.getInt("DroppedPackets", 0);
            this._simulatedWindowSize = fs.getDouble("SimulatedWindowSize", def);
        } else {
            this._simulatedWindowSize = def;
        }
    }

    public synchronized double currentValue() {
        if (this._simulatedWindowSize < 1.0) {
            this._simulatedWindowSize = 1.0;
        }
        return this._simulatedWindowSize * (double)Math.max(1, this.node.peers.countNonBackedOffPeers());
    }

    public synchronized void rejectedOverload() {
        ++this._droppedPackets;
        ++this._totalPackets;
        this._simulatedWindowSize *= (double)0.97f;
        if (logMINOR) {
            Logger.minor(this, "request rejected overload: " + this);
        }
    }

    public synchronized void requestCompleted() {
        ++this._totalPackets;
        this._simulatedWindowSize += 0.07879996299743652 / this._simulatedWindowSize;
        if (logMINOR) {
            Logger.minor(this, "requestCompleted on " + this);
        }
    }

    public synchronized String toString() {
        return super.toString() + " w: " + this._simulatedWindowSize + ", d:" + (float)this._droppedPackets / (float)this._totalPackets + '=' + this._droppedPackets + '/' + this._totalPackets;
    }

    public SimpleFieldSet exportFieldSet(boolean shortLived) {
        SimpleFieldSet fs = new SimpleFieldSet(shortLived);
        fs.putSingle("Type", "ThrottleWindowManager");
        fs.put("TotalPackets", this._totalPackets);
        fs.put("DroppedPackets", this._droppedPackets);
        fs.put("SimulatedWindowSize", this._simulatedWindowSize);
        return fs;
    }

    public double realCurrentValue() {
        return this._simulatedWindowSize;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

