/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.TestnetStatusUploader;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;

public class TestnetHandler
implements Runnable {
    private final TestnetStatusUploader uploader;
    private final Node node;
    private ServerSocket server;
    private int testnetPort;

    public TestnetHandler(Node node2, int testnetPort) {
        this.node = node2;
        this.testnetPort = testnetPort;
        Logger.error(this, "STARTING TESTNET SERVER!");
        Logger.error(this, "ANONYMITY MODE: OFF");
        System.err.println("STARTING TESTNET SERVER!");
        System.err.println("ANONYMITY MODE: OFF");
        System.err.println("You have no anonymity. Thank you for running a testnet node, this will help the developers to efficiently debug Freenet, by letting them (and anyone else who knows how!!) automatically fetch your log files.");
        System.err.println("We repeat: YOU HAVE NO ANONYMITY WHATSOEVER. DO NOT POST ANYTHING YOU DO NOT WANT TO BE ASSOCIATED WITH.");
        System.err.println("If you want a real Freenet node, with anonymity, turn off testnet mode.");
        System.err.println("Note, this node will not connect to non-testnet nodes, for security reasons. You can of course run a testnet node and a non-testnet node separately.");
        this.uploader = new TestnetStatusUploader(this.node, 180000);
    }

    public void start() {
        this.node.executor.execute(this, "Testnet handler thread");
        this.uploader.start();
        System.err.println("Started testnet handler on port " + this.testnetPort);
    }

    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                this.server = new ServerSocket(this.testnetPort);
                Logger.normal(this, "Starting testnet server on port" + this.testnetPort);
            }
            catch (IOException e) {
                Logger.error(this, "Could not bind to testnet port: " + this.testnetPort);
                this.node.exit(7);
                return;
            }
            while (!this.server.isClosed()) {
                try {
                    Socket s = this.server.accept();
                    new TestnetSocketHandler(s).start();
                }
                catch (IOException e) {
                    Logger.error(this, "Testnet failed to accept socket: " + e, e);
                }
            }
            Logger.normal(this, "Testnet handler has been stopped : restarting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(int port) {
        ServerSocket serverSocket = this.server;
        synchronized (serverSocket) {
            try {
                if (!this.server.isClosed() && this.server.isBound()) {
                    this.server.close();
                }
                this.testnetPort = port;
            }
            catch (IOException e) {
                Logger.error(this, "Error while stopping the testnet handler.");
                this.node.exit(7);
                return;
            }
        }
    }

    public int getPort() {
        return this.testnetPort;
    }

    public static TestnetHandler maybeCreate(Node node, Config config) throws NodeInitException {
        SubConfig testnetConfig = new SubConfig("node.testnet", config);
        testnetConfig.register("enabled", false, 1, true, true, "TestnetHandler.enable", "TestnetHandler.enableLong", new TestnetEnabledCallback(node));
        boolean enabled = testnetConfig.getBoolean("enabled");
        if (enabled) {
            testnetConfig.register("port", node.getDarknetPortNumber() + 1000, 2, true, false, "TestnetHandler.port", "TestnetHandler.portLong", (IntCallback)new TestnetPortNumberCallback(node), false);
            int port = testnetConfig.getInt("port");
            testnetConfig.finishedInitialization();
            return new TestnetHandler(node, port);
        }
        testnetConfig.finishedInitialization();
        return null;
    }

    static class TestnetPortNumberCallback
    extends IntCallback {
        Node node;

        TestnetPortNumberCallback(Node n) {
            this.node = n;
        }

        public Integer get() {
            return this.node.testnetHandler.getPort();
        }

        public void set(Integer val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.node.testnetHandler.rebind(val);
        }
    }

    private static class TestnetEnabledCallback
    extends BooleanCallback {
        final Node node;

        TestnetEnabledCallback(Node node) {
            this.node = node;
        }

        public Boolean get() {
            return this.node.testnetEnabled;
        }

        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.node.testnetEnabled == val) {
                return;
            }
            throw new InvalidConfigValueException(L10n.getString("TestnetHandler.cannotEnableDisableOnTheFly"));
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    public class TestnetSocketHandler
    implements Runnable {
        private Socket s;

        public TestnetSocketHandler(Socket s2) {
            this.s = s2;
        }

        void start() {
            ((TestnetHandler)TestnetHandler.this).node.executor.execute(this, "Testnet handler for " + this.s.getInetAddress() + " at " + System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block48: {
                block43: {
                    block47: {
                        block42: {
                            block40: {
                                block41: {
                                    Logger.OSThread.logPID(this);
                                    logMINOR = Logger.shouldLog(4, this);
                                    is = null;
                                    os = null;
                                    try {
                                        try {
                                            is = this.s.getInputStream();
                                            os = this.s.getOutputStream();
                                            isr = new InputStreamReader(is, "ISO-8859-1");
                                            br = new BufferedReader(isr);
                                            command = br.readLine();
                                            if (command == null) {
                                                var13_8 = null;
                                                if (is == null) break block40;
                                                break block41;
                                            }
                                            if (logMINOR) {
                                                Logger.minor(this, "Command: " + command);
                                            }
                                            if ((loggerHook = Node.logConfigHandler.getFileLoggerHook()) == null) {
                                                Logger.error(this, "Could not serve testnet command because no FileLoggerHook");
                                                osw = new OutputStreamWriter(os);
                                                osw.write("ERROR: Could not serve testnet command because no FileLoggerHook");
                                                break block42;
                                            }
                                            if (command.equalsIgnoreCase("LIST")) {
                                                if (logMINOR) {
                                                    Logger.minor(this, "Listing available logs");
                                                }
                                                osw = new OutputStreamWriter(os, "ISO-8859-1");
                                                loggerHook.listAvailableLogs(osw);
                                                osw.close();
                                                break block43;
                                            }
                                            if (command.startsWith("GET:")) {
                                                if (logMINOR) {
                                                    Logger.minor(this, "Sending log: " + command);
                                                }
                                                date = command.substring("GET:".length());
                                                df = DateFormat.getDateTimeInstance(3, 3, Locale.ENGLISH);
                                                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                                                try {
                                                    d = df.parse(date);
                                                }
                                                catch (ParseException e) {
                                                    if (logMINOR) {
                                                        Logger.minor(this, "Cannot parse: " + e + " for " + date);
                                                    }
                                                    var13_10 = null;
                                                    if (is != null) {
                                                        try {
                                                            is.close();
                                                        }
                                                        catch (IOException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (os == null) return;
                                                    try {
                                                        os.close();
                                                        return;
                                                    }
                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                    return;
                                                }
                                                loggerHook.sendLogByContainedDate(d.getTime(), os);
                                                break block43;
                                            }
                                            if (command.equalsIgnoreCase("STATUS")) {
                                                if (logMINOR) {
                                                    Logger.minor(this, "Sending status");
                                                }
                                                osw = new OutputStreamWriter(os, "ISO-8859-1");
                                                osw.write(TestnetHandler.access$000(TestnetHandler.this).getStatus());
                                                osw.close();
                                                break block43;
                                            }
                                            if (command.equalsIgnoreCase("PEERS")) {
                                                if (logMINOR) {
                                                    Logger.minor(this, "Sending references");
                                                }
                                                osw = new OutputStreamWriter(os, "ISO-8859-1");
                                                bw = new BufferedWriter(osw);
                                                bw.write("My darknet ref:\n\n");
                                                fs = TestnetHandler.access$000(TestnetHandler.this).exportDarknetPublicFieldSet();
                                                fs.writeTo(bw);
                                                if (TestnetHandler.access$000(TestnetHandler.this).isOpennetEnabled()) {
                                                    bw.write("My opennet ref:\n\n");
                                                    fs = TestnetHandler.access$000(TestnetHandler.this).exportOpennetPublicFieldSet();
                                                    fs.writeTo(bw);
                                                }
                                                bw.write("\n\nMy peers:\n");
                                                bw.write(TestnetHandler.access$000((TestnetHandler)TestnetHandler.this).peers.getDarknetPeersString().toString());
                                                bw.close();
                                                break block43;
                                            } else {
                                                Logger.error(this, "Unknown testnet command: " + command);
                                            }
                                            break block43;
                                        }
                                        catch (IOException e) {
                                            block45: {
                                                Logger.normal(this, "Failure handling testnet connection: " + e);
                                                var13_12 = null;
                                                if (is != null) {
                                                    ** try [egrp 3[TRYBLOCK] [11 : 600->607)] { 
lbl94:
                                                    // 1 sources

                                                    is.close();
                                                    break block45;
lbl96:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (os == null) return;
                                            try {}
                                            catch (IOException e) {
                                                return;
                                            }
                                            os.close();
                                            return;
                                        }
                                    }
                                    catch (Throwable var12_31) {
                                        block46: {
                                            var13_13 = null;
                                            if (is != null) {
                                                ** try [egrp 3[TRYBLOCK] [11 : 600->607)] { 
lbl110:
                                                // 1 sources

                                                is.close();
                                                break block46;
lbl112:
                                                // 1 sources

                                                catch (IOException e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (os == null) throw var12_31;
                                        ** try [egrp 4[TRYBLOCK] [12 : 613->620)] { 
lbl117:
                                        // 1 sources

                                        os.close();
                                        throw var12_31;
lbl119:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                        throw var12_31;
                                    }
                                }
                                ** try [egrp 3[TRYBLOCK] [11 : 600->607)] { 
lbl124:
                                // 1 sources

                                is.close();
                                break block40;
lbl126:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            if (os == null) return;
                            ** try [egrp 4[TRYBLOCK] [12 : 613->620)] { 
lbl131:
                            // 1 sources

                            os.close();
                            return;
lbl133:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            return;
                        }
                        var13_9 = null;
                        if (is != null) {
                            ** try [egrp 3[TRYBLOCK] [11 : 600->607)] { 
lbl140:
                            // 1 sources

                            is.close();
                            break block47;
lbl142:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (os == null) return;
                    ** try [egrp 4[TRYBLOCK] [12 : 613->620)] { 
lbl147:
                    // 1 sources

                    os.close();
                    return;
lbl149:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                var13_11 = null;
                if (is != null) {
                    ** try [egrp 3[TRYBLOCK] [11 : 600->607)] { 
lbl156:
                    // 1 sources

                    is.close();
                    break block48;
lbl158:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (os == null) return;
            try {}
            catch (IOException e) {}
            os.close();
            return;
        }
    }
}

