/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentChosenBlock;
import freenet.client.async.PersistentChosenRequest;
import freenet.node.KeysFetchingLocally;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.RandomGrabArrayItem;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SendableRequest
implements RandomGrabArrayItem {
    private final int hashCode;
    protected RandomGrabArray parentGrabArray;
    protected final boolean persistent;

    SendableRequest(boolean persistent) {
        this.persistent = persistent;
        this.hashCode = super.hashCode();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public abstract short getPriorityClass(ObjectContainer var1);

    public abstract int getRetryCount();

    public abstract SendableRequestItem chooseKey(KeysFetchingLocally var1, ObjectContainer var2, ClientContext var3);

    public abstract long countAllKeys(ObjectContainer var1, ClientContext var2);

    public abstract long countSendableKeys(ObjectContainer var1, ClientContext var2);

    public abstract SendableRequestSender getSender(ObjectContainer var1, ClientContext var2);

    public abstract boolean isCancelled(ObjectContainer var1);

    public abstract RequestClient getClient(ObjectContainer var1);

    @Override
    public final boolean persistent() {
        return this.persistent;
    }

    public abstract ClientRequester getClientRequest();

    @Override
    public synchronized RandomGrabArray getParentGrabArray() {
        return this.parentGrabArray;
    }

    @Override
    public boolean knowsParentGrabArray() {
        return true;
    }

    @Override
    public synchronized void setParentGrabArray(RandomGrabArray parent, ObjectContainer container) {
        this.parentGrabArray = parent;
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public void unregister(ObjectContainer container, ClientContext context) {
        RandomGrabArray arr = this.getParentGrabArray();
        if (arr != null) {
            if (this.persistent) {
                container.activate((Object)arr, 1);
            }
            arr.remove(this, container);
        } else if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "Cannot unregister " + this + " : not registered", (Throwable)new Exception("debug"));
        }
        ClientRequester cr = this.getClientRequest();
        if (this.persistent) {
            container.activate((Object)cr, 1);
        }
        this.getScheduler(context).removeFromAllRequestsByClientRequest(cr, this, true, container);
    }

    public abstract ClientRequestScheduler getScheduler(ClientContext var1);

    public abstract boolean isSSK();

    public abstract boolean isInsert();

    public abstract void internalError(Throwable var1, RequestScheduler var2, ObjectContainer var3, ClientContext var4, boolean var5);

    public abstract List<PersistentChosenBlock> makeBlocks(PersistentChosenRequest var1, RequestScheduler var2, ObjectContainer var3, ClientContext var4);
}

